c---------------------------------------------------
c make ps-figure of triangulation
c---------------------------------------------------
      subroutine graph(nv,vrt,nt,tri,name)
      character*3 name
      integer nv,nt
      double precision vrt(2,*)
      integer          tri(3,*)
      double precision xymax(2),xymin(2),kx, scale
      integer UNIT,CHAN
      integer k,l,i

      xymin(1)=vrt(1,1)
      xymin(2)=vrt(2,1)
      xymax(1)=vrt(1,1)
      xymax(2)=vrt(2,1)
      do i=2,nv
         xymin(1)=min(xymin(1),vrt(1,i))
         xymin(2)=min(xymin(2),vrt(2,i))
         xymax(1)=max(xymax(1),vrt(1,i))
         xymax(2)=max(xymax(2),vrt(2,i))
      end do
      scale = max(xymax(1)-xymin(1),xymax(2)-xymin(2))
      KX=500.0 / scale
      OPEN( UNIT=1, FILE=name//".ps" )
      WRITE(1,'(a)') '%!PS-Adobe-2.0 EPSF-2.0'
      WRITE(1,'(a)') '%%BoundingBox: 0 0  520 520'
      WRITE(1,'(a)') '%%EndComments'
      WRITE(1,*) ' 10 10 translate 0 setlinewidth'
      WRITE(1,*)' /t{newpath moveto lineto lineto closepath stroke}def'
      do k=1,nt
        WRITE(1,*)(((vrt(i,tri(l,k))-xymin(i))*kx,i=1,2),l=1,3),' t'
      end do
      WRITE(1,*) ' showpage'
      close(1)
      return
      end

c---------------------------------------------------
c make ps-figure of solution isolines, their number is ni
c---------------------------------------------------
      subroutine isolines(u,nv,vrt,nt,tri,nb,bnd,name,ni)
      implicit none
      character*3 name
      integer nv,nt,nb,ni
      double precision u(*),vrt(2,*)
      integer          tri(3,*),bnd(4,*)
      double precision xymax(2),xymin(2),umin,umax,ucur,x(2),y(2), scale
      double precision vi,kx,tet
      integer UNIT,CHAN
      integer k,l,i,j,is,icount

      xymin(1)=vrt(1,1)
      xymin(2)=vrt(2,1)
      xymax(1)=vrt(1,1)
      xymax(2)=vrt(2,1)
       umin   =u(1)
       umax   =u(1)
      do i=2,nv
         xymin(1)=min(xymin(1),vrt(1,i))
         xymin(2)=min(xymin(2),vrt(2,i))
         xymax(1)=max(xymax(1),vrt(1,i))
         xymax(2)=max(xymax(2),vrt(2,i))
          umax   =max( umax   , u(i)   )
          umin   =min( umin   , u(i)   )
      end do
      scale = max(xymax(1)-xymin(1),xymax(2)-xymin(2))
      KX=500.0 / scale
      OPEN( UNIT=1, FILE=name//".ps" )
      WRITE(1,'(a)') '%!PS-Adobe-2.0 EPSF-2.0'
      WRITE(1,'(a)') '%%BoundingBox: 0 0  520 520'
      WRITE(1,'(a)') '%%EndComments'
      WRITE(1,*) ' 10 10 translate 0 setlinewidth'
      WRITE(1,*)' /v{moveto lineto stroke}def'
      DO I = 1, nt
         DO IS = 1, NI
            ICOUNT = 0
            UCUR = UMIN+(IS-1)*(UMAX-UMIN)/(NI-1)

            DO J = 1, 3
               IF (J.GE.2) THEN
                  K = J-1
               ELSE
                  K=3
               END IF

               IF (U(TRI(J,I)).EQ.U(TRI(K,I)).AND.
     &              U(TRI(J,I)).EQ.UCUR.AND.ICOUNT.LT.2) THEN
                  X(1)=VRT(1,TRI(J,I))
                  X(2)=VRT(1,TRI(K,I))
                  Y(1)=VRT(2,TRI(J,I))
                  Y(2)=VRT(2,TRI(K,I))
                  VI = UCUR
                  ICOUNT = 2
               END IF

               IF (((U(TRI(J,I)).LT.UCUR.AND.UCUR.LE.U(TRI(K,I)))
     &              .OR.(U(TRI(J,I)).GE.UCUR.AND.UCUR.GT.U(TRI(K,I))))
     &              .AND.ICOUNT.LT.2)   THEN

                  ICOUNT = ICOUNT+1
                  TET = (UCUR-U(TRI(J,I)))/(U(TRI(K,I))-U(TRI(J,I)))
                  X(ICOUNT)=
     &            VRT(1,TRI(J,I))+TET*(VRT(1,TRI(K,I))-VRT(1,TRI(J,I)))
                  Y(ICOUNT)=
     &            VRT(2,TRI(J,I))+TET*(VRT(2,TRI(K,I))-VRT(2,TRI(J,I)))
                  VI = UCUR
               END IF
            END DO
            IF (ICOUNT.NE.0) THEN
              WRITE(1,'(4f7.1,a)')(X(1)-xymin(1))*kx,(Y(1)-xymin(2))*kx,
     &                  (X(2)-xymin(1))*kx,(Y(2)-xymin(2))*kx,' v'
            END IF
         END DO
      END DO
C   WRITE BOUNDARY 
      DO  I = 1, nb
          WRITE(1,'(4f7.1,a)') (VRT(1,BND(1,I))-xymin(1))*KX, 
     &                         (VRT(2,BND(1,I))-xymin(2))*KX,
     &                         (VRT(1,BND(2,I))-xymin(1))*KX, 
     &                         (VRT(2,BND(2,I))-xymin(2))*KX,' v'
      END DO


      WRITE(1,*) ' showpage'
      close(1)
      return
      end

