      subroutine erInt(U,nv,vrt,nt,tri,erInttri)
      implicit none

      double precision Func,erInttri(*),U(*),vrt(2,*)
      integer          tri(3,*),nv,nt


      integer Nstpan,Nstpsz
      parameter ( Nstpan=20, Nstpsz=20 )
      integer i,j,k, ip(3)
      double precision dx21,dy21,dx31,dy31,da,an,dl,lx,ly,
     &                 xy(2),diff,Fint, a,b,c,d,detff,F1,F2,F3

      da = 1d0/Nstpan

      do i = 1, nt
         erInttri(i) = 0d0
         dx21 = vrt(1,tri(2,i)) - vrt(1,tri(1,i))
         dy21 = vrt(2,tri(2,i)) - vrt(2,tri(1,i))
         dx31 = vrt(1,tri(3,i)) - vrt(1,tri(1,i))
         dy31 = vrt(2,tri(3,i)) - vrt(2,tri(1,i))
         ip(1) = tri(1, i)
         ip(2) = tri(2, i)
         ip(3) = tri(3, i)
         F1 = U(ip(1))
         F2 = U(ip(2))
         F3 = U(ip(3))

         do j = 0, Nstpan
            an = j*da
            do k = 0, Nstpsz
               lx = dx21*(1d0-an) + dx31*an
               ly = dy21*(1d0-an) + dy31*an
               dl = 1d0/Nstpsz
               xy(1) = vrt(1,tri(1,i)) + (k*dl)*lx 
               xy(2) = vrt(2,tri(1,i)) + (k*dl)*ly 
               a = detff(2, 3, ip,xy,vrt)
               b = detff(3, 1, ip,xy,vrt)
               c = detff(1, 2, ip,xy,vrt)
               d = a + b + c
               Fint = ( a * F1 + b * F2 + c * F3 ) / d
               diff = dabs( Func(xy) - Fint )
               erInttri(i) = max ( erInttri(i), diff )
            end do
         end do
c         erInttri(i) = log10 ( erInttri(i) )
      end do

      return
      end

         

      double precision function detff(i,j,ip,xy,vrt)
      implicit none
      integer i,j,ip(*)
      double precision xy(2),vrt(2,*)
        detff = (vrt(1, ip(i)) - xy(1))*(vrt(2, ip(j)) - xy(2))
     &       - (vrt(2, ip(i)) - xy(2))*(vrt(1, ip(j)) - xy(1))
      return
      end


      subroutine erGrd(U,nv,vrt,nt,tri,erGrdtri)
      implicit none

      double precision erGrdtri(*),U(*),vrt(2,*)
      integer          tri(3,*),nv,nt



      integer Nstpan,Nstpsz
      parameter ( Nstpan=20, Nstpsz=20 )
      integer i,j,k, L1,L2,L3
      double precision dx12,dy12,dx13,dy13,dx21,dy21,dx31,dy31,
     &                 da,an,dl,lx,ly,
     &                 xy(2),diff, det,
     &                 UGrd(2),fGrd(2)
      double precision Ht,d23,h,s1,s2,Strap

      da = 1d0/Nstpan
      dl = 1d0/Nstpsz

      do i = 1, nt
         erGrdtri(i) = 0d0
         L1 = tri(1,i)
         L2 = tri(2,i)
         L3 = tri(3,i)

         DX12 = VRT(1,L1)-VRT(1,L2)
         DX13 = VRT(1,L1)-VRT(1,L3)
         DY12 = VRT(2,L1)-VRT(2,L2)
         DY13 = VRT(2,L1)-VRT(2,L3)
         DET = DX12*DY13-DX13*DY12

         UGrd(1) = ((U(L1)-U(L2))*DY13 
     &            - (U(L1)-U(L3))*DY12)/DET
         UGrd(2) = (-(U(L1)-U(L2))*DX13 
     &             + (U(L1)-U(L3))*DX12)/DET

         dx21 = vrt(1,tri(2,i)) - vrt(1,tri(1,i))
         dy21 = vrt(2,tri(2,i)) - vrt(2,tri(1,i))
         dx31 = vrt(1,tri(3,i)) - vrt(1,tri(1,i))
         dy31 = vrt(2,tri(3,i)) - vrt(2,tri(1,i))
         d23  = dsqrt((vrt(1,L2)-vrt(1,L3))**2+(vrt(2,L2)-vrt(2,L3))**2)
         Ht   = dabs(DET)/d23

         do j = 0, Nstpan
            an = j*da
            lx = dx21*(1d0-an) + dx31*an
            ly = dy21*(1d0-an) + dy31*an
            do k = 0, Nstpsz
               xy(1) = vrt(1,tri(1,i)) + (k*dl)*lx 
               xy(2) = vrt(2,tri(1,i)) + (k*dl)*ly 
               s1 = d23*(k-0.5)*dl/Nstpan
               s2 = d23*(k+0.5)*dl/Nstpan
               if (k.eq.0) s1 = 0d0
               if (k.eq.Nstpsz) s2 = d23/Nstpan
               h  = Ht/Nstpsz
               if (k.eq.0.or.k.eq.Nstpsz) h  = Ht/2d0/Nstpsz
               Strap = (s1+s2)*h/2d0
               call FuncGrd(xy,fGrd)
               diff = (fGrd(1)-UGrd(1))**2 + (fGrd(2)-UGrd(2))**2
c              erGrdtri(i) = max ( erGrdtri(i), diff )
               erGrdtri(i) = erGrdtri(i) +  diff*Strap 
            end do
         end do
         erGrdtri(i) = dsqrt(erGrdtri(i))
      end do

      return
      end

      subroutine funcgrd(xy,fGrd)
      implicit none
      double precision xy(2),fGrd(2)
      double precision x0,y0,v,u,ux,vx,uy,vy
      x0 = 0.5
      y0 = -0.2
      u = (xy(1)-x0)**2-(dsqrt(1d1)*xy(2)-y0)**2
      v = (xy(1)-x0)**2+(dsqrt(1d1)*xy(2)-y0)**2
      ux = 2*(xy(1)-x0)
      vx = 2*(xy(1)-x0)
      uy =-2*dsqrt(1d1)*(dsqrt(1d1)*xy(2)-y0)
      vy = 2*dsqrt(1d1)*(dsqrt(1d1)*xy(2)-y0)
      fGrd(1) =( ux*v**2 - 2*u*v*vx ) / v**4
      fGrd(2) =( uy*v**2 - 2*u*v*vy ) / v**4
      return
      end

