MODULE lapack
  INTERFACE potrf
     SUBROUTINE spotrf(uplo,n,a,lda,info)
       INTEGER, INTENT(IN) :: n, lda
       INTEGER, INTENT(OUT) :: info
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(INOUT) :: a
       CHARACTER*1, INTENT(IN) :: uplo
     END SUBROUTINE spotrf
     SUBROUTINE dpotrf(uplo,n,a,lda,info)
       INTEGER, INTENT(IN) :: n, lda
       INTEGER, INTENT(OUT) :: info
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(INOUT) :: a
       CHARACTER*1, INTENT(IN) :: uplo
     END SUBROUTINE dpotrf
  END INTERFACE
  INTERFACE trtrs
     SUBROUTINE strtrs(uplo,trans,diag,n,nrhs,a,lda,b,ldb,info)
       INTEGER, INTENT(IN) :: n, nrhs, lda, ldb
       INTEGER, INTENT(OUT) :: info
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.e0)), DIMENSION(ldb,*), INTENT(INOUT) :: b
       CHARACTER*1, INTENT(IN) :: uplo, trans, diag
     END SUBROUTINE strtrs
     SUBROUTINE dtrtrs(uplo,trans,diag,n,nrhs,a,lda,b,ldb,info)
       INTEGER, INTENT(IN) :: n, nrhs, lda, ldb
       INTEGER, INTENT(OUT) :: info
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(IN) :: a
       REAL(KIND(1.d0)), DIMENSION(ldb,*), INTENT(INOUT) :: b
       CHARACTER*1, INTENT(IN) :: uplo, trans, diag
     END SUBROUTINE dtrtrs
  END INTERFACE
  INTERFACE getrf
     SUBROUTINE sgetrf(m,n,a,lda,ipiv,info)
       INTEGER, INTENT(in) :: m,n,lda
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(inout) :: a
     END SUBROUTINE sgetrf
     SUBROUTINE dgetrf(m,n,a,lda,ipiv,info)
       INTEGER, INTENT(in) :: m,n,lda
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(inout) :: a
     END SUBROUTINE dgetrf
     SUBROUTINE cgetrf(m,n,a,lda,ipiv,info)
       INTEGER, INTENT(in) :: m,n,lda
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       COMPLEX(KIND(1.e0)), DIMENSION(lda,*), INTENT(inout) :: a
     END SUBROUTINE cgetrf
     SUBROUTINE zgetrf(m,n,a,lda,ipiv,info)
       INTEGER, INTENT(in) :: m,n,lda
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       COMPLEX(KIND(1.d0)), DIMENSION(lda,*), INTENT(inout) :: a
     END SUBROUTINE zgetrf
  END INTERFACE
  INTERFACE getri
     SUBROUTINE sgetri(n, a, lda, ipiv, work, lwork, info)
       INTEGER, INTENT(in) :: n, lda, lwork
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(in) :: a
       REAL(KIND(1.e0)), DIMENSION(lwork), INTENT(inout) :: work
     END SUBROUTINE sgetri
     SUBROUTINE dgetri(n, a, lda, ipiv, work, lwork, info)
       INTEGER, INTENT(in) :: n, lda, lwork
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(in) :: a
       REAL(KIND(1.d0)), DIMENSION(lwork), INTENT(inout) :: work
     END SUBROUTINE dgetri
  END INTERFACE
  INTERFACE getrs
     SUBROUTINE sgetrs(trans, n, nrhs, a, lda, ipiv, b, ldb, info)
       INTEGER, INTENT(in) :: n, nrhs, lda, ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       REAL(KIND(1.e0)), DIMENSION(lda,*), INTENT(in) :: a
       REAL(KIND(1.e0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE sgetrs
     SUBROUTINE dgetrs(trans, n, nrhs, a, lda, ipiv, b, ldb, info)
       INTEGER, INTENT(in) :: n, nrhs, lda, ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       REAL(KIND(1.d0)), DIMENSION(lda,*), INTENT(in) :: a
       REAL(KIND(1.d0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE dgetrs
     SUBROUTINE cgetrs(trans, n, nrhs, a, lda, ipiv, b, ldb, info)
       INTEGER, INTENT(in) :: n, nrhs, lda, ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       COMPLEX(KIND(1.e0)), DIMENSION(lda,*), INTENT(in) :: a
       COMPLEX(KIND(1.e0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE cgetrs
     SUBROUTINE zgetrs(trans, n, nrhs, a, lda, ipiv, b, ldb, info)
       INTEGER, INTENT(in) :: n, nrhs, lda, ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       COMPLEX(KIND(1.d0)), DIMENSION(lda,*), INTENT(in) :: a
       COMPLEX(KIND(1.d0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE zgetrs
  END INTERFACE
  INTERFACE gbtrf
     SUBROUTINE sgbtrf(m,n,kl,ku,ab,ldab,ipiv,info)
       INTEGER, INTENT(in) :: m,n,kl,ku,ldab
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.e0)), DIMENSION(ldab,*), INTENT(inout) :: ab
     END SUBROUTINE sgbtrf
     SUBROUTINE dgbtrf(m,n,kl,ku,ab,ldab,ipiv,info)
       INTEGER, INTENT(in) :: m,n,kl,ku,ldab
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       REAL(KIND(1.d0)), DIMENSION(ldab,*), INTENT(inout) :: ab
     END SUBROUTINE dgbtrf
     SUBROUTINE cgbtrf(m,n,kl,ku,ab,ldab,ipiv,info)
       INTEGER, INTENT(in) :: m,n,kl,ku,ldab
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       COMPLEX(KIND(1.e0)), DIMENSION(ldab,*), INTENT(inout) :: ab
     END SUBROUTINE cgbtrf
     SUBROUTINE zgbtrf(m,n,kl,ku,ab,ldab,ipiv,info)
       INTEGER, INTENT(in) :: m,n,kl,ku,ldab
       INTEGER, DIMENSION(*), INTENT(out) :: ipiv
       INTEGER, INTENT(out) :: info
       COMPLEX(KIND(1.d0)), DIMENSION(ldab,*), INTENT(inout) :: ab
     END SUBROUTINE zgbtrf
  END INTERFACE
  INTERFACE gbtrs
     SUBROUTINE sgbtrs(trans,n,kl,ku,nrhs,ab,ldab,ipiv,b,ldb,info)
       INTEGER, INTENT(in) :: n,kl,ku,nrhs,ldab,ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       REAL(KIND(1.e0)), DIMENSION(ldab,*), INTENT(in) :: ab
       REAL(KIND(1.e0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE sgbtrs
     SUBROUTINE dgbtrs(trans,n,kl,ku,nrhs,ab,ldab,ipiv,b,ldb,info)
       INTEGER, INTENT(in) :: n,kl,ku,nrhs,ldab,ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       REAL(KIND(1.d0)), DIMENSION(ldab,*), INTENT(in) :: ab
       REAL(KIND(1.d0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE dgbtrs
     SUBROUTINE cgbtrs(trans,n,kl,ku,nrhs,ab,ldab,ipiv,b,ldb,info)
       INTEGER, INTENT(in) :: n,kl,ku,nrhs,ldab,ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       COMPLEX(KIND(1.e0)), DIMENSION(ldab,*), INTENT(in) :: ab
       COMPLEX(KIND(1.e0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE cgbtrs
     SUBROUTINE zgbtrs(trans,n,kl,ku,nrhs,ab,ldab,ipiv,b,ldb,info)
       INTEGER, INTENT(in) :: n,kl,ku,nrhs,ldab,ldb
       INTEGER, DIMENSION(*), INTENT(in) :: ipiv
       INTEGER, INTENT(out) :: info
       CHARACTER*1, INTENT(in) :: trans
       COMPLEX(KIND(1.d0)), DIMENSION(ldab,*), INTENT(in) :: ab
       COMPLEX(KIND(1.d0)), DIMENSION(ldb), INTENT(inout) :: b
     END SUBROUTINE zgbtrs
  END INTERFACE
END MODULE lapack
