      IMPLICIT         NONE
      INTEGER          NEQ
      PARAMETER        (NEQ = 3)
*
      INTEGER          NumStep, WHICH, INFO, IWORK(NEQ), I, J
      DOUBLE PRECISION H, TF, X0(NEQ), XIN(NEQ), XOUT(NEQ), 
     $                 WORK(NEQ*(NEQ+1))
*
      EXTERNAL          LRZJEX, LRZFEX
*
*     Common block that defines Lorenz Strange Attractor.
*
      DOUBLE PRECISION SIGMA, R, B
      COMMON /LORENZ/SIGMA, R, B
*
*                                       Ren-Cang Li, June 1, 1996
*                                       na.rcli@na-net.ornl.gov
*
*     Open a file for output.
*
      OPEN(10, FILE='Results',STATUS='NEW')
*
      SIGMA = 10.0D0
      R     = 28.0D0
      B     = 8.0D0/3.0D0
*
*     WHICH scheme
*
      print*, '------------------------------------------'
      print*, ' '
      print*, '        WHICH                 The Scheme  '
      print*, ' '
      print*, '          1                      s1odr2 '
      print*, '          2                      s3odr4 '
      print*, '          3                      s5odr4 '
      print*, '          4                      s5odr4a '
      print*, '          5                      s7odr6 '
      print*, '          6                      s9odr6a '
      print*, '          7                      s9odr6b '
      print*, '          8                     s15odr8 '
      print*, '          9                     s17odr8a '
      print*, '         10                     s17odr8b '
      print*, '         11                    s31odr10a '
      print*, '         12                    s31odr10b '
      print*, '         13                    s33odr10a '
      print*, '         14                    s33odr10b '
      print*, '         15                    s33odr10c '
      print*, ' '
      print*, '------------------------------------------'
      print*, ' Input WHICH '
      read*, WHICH
*
*     Initial Values
*
      X0(1) = 10.0D0
      X0(2) =-20.0D0
      X0(3) = 20.0D0
*
*     Stepsize
*
      H = 0.01D0
*
*     Integrate from T=0 to T=1.
*
      TF = 1.0D0
*
*     The Number of Steps
*
      NumStep = TF/H
      print*, 'NumStep = ', NumStep
*
      DO 5 J=1,NEQ
	    XIN(J) = X0(J)
 5    CONTINUE
*
      WRITE(10,*) XIN
      DO 20 I = 1, NumStep
	 CALL ALLS1(WHICH, LRZJEX, LRZFEX, NEQ, H, XIN, XOUT,
     $              WORK, IWORK, INFO)
	 DO 10 J=1,NEQ
	    XIN(J) = XOUT(J)
 10      CONTINUE
      WRITE(10,*) XIN
 20   CONTINUE
*
      STOP
      END
