      SUBROUTINE ONESTEP(JEX, FEX, NEQ, H, XIN, XOUT, 
     $                   PD, IPIV, INFO)
      IMPLICIT          NONE
*
*     .. Scalar Arguments ..
      INTEGER           NEQ, INFO
      DOUBLE PRECISION  H
*
*     .. Array Arguments ..
      INTEGER           IPIV(NEQ)
      DOUBLE PRECISION  XIN(NEQ), XOUT(NEQ), PD(NEQ,NEQ)
*
*     .. External Subroutines ..
      EXTERNAL          JEX, FEX
*
*-------------------------------------------------------------------------
*
*  Purpose
*  =======
*
*  ONESTEP is the implementation of the refelxive updating formula
*  based on symmetric splitting for a quadratic differential system:
*
*         y' = f(y),
*
*  where each component of f(y) is qudratic in y. ONESTEP is called
*  repeatedly by ALLS1 for doing palindromic compositions.
*
*                                       Ren-Cang Li, June 1, 1996
*                                       na.rcli@na-net.ornl.gov
*
*  Arguments:
*  ==========
*  
*  JEX       External Subroutine that calculates the Jacobian of f(y);
*
*  FEX       External Subroutine that calculates f(y).
*
*  NEQ       (input) INTEGER scalar
*            The dimension of the system.
*
*  H         (input) DOUBLE PRECISION scalar
*            Stepsize.
*
*  XIN       (input) DOUBLE PRECISION array, dimension (NEQ)
*            The value of y at T, the current time. (Since this is for
*            autonomous system, T does not appear as an argument.)
*
*  XOUT      (output) DOUBLE PRECISION array, dimension (NEQ)
*            The calculated y at T+H.
*
*  PD        (working) DOUBLE PRECISION array, dimension (NEQ,NEQ)
*            It is used by JEX to return the Jacobian of f(y) at XIN.
*
*  IPIV      (working) INTEGER array, dimension (NEQ)
*            It is used by DGESV to do Gaussian elimination with partial
*            pivoting.
*
*  INFO      (output) INTEGER scalar
*            It is used by DGESV to return information about the status of
*            Gaussian elimination with partial pivoting.
*
*-------------------------------------------------------------------------
*
*     .. Parameters ..
      DOUBLE PRECISION HALF, ONE
      PARAMETER        (HALF = 0.5D0, ONE = 1.0D0)
C
C  local variable
C
      INTEGER          I, J
      DOUBLE PRECISION TMP
C
      INFO = 0
      CALL  JEX(NEQ, XIN, PD, NEQ)
      CALL  FEX(NEQ, XIN, XOUT)
C
      TMP =  -HALF*H
      DO 20 J = 1, NEQ
	 DO 10 I = 1, NEQ
	    PD(I,J)= TMP * PD(I,J)
 10      CONTINUE
 20   CONTINUE
C
      DO 30 I = 1, NEQ
	 PD(I,I) = ONE  + PD(I,I)
	 XOUT(I) = H*XOUT(I)
 30   CONTINUE
C
C     Call LAPACK routine DGESV to solve a linear system
C
      CALL DGESV(NEQ, 1, PD, NEQ, IPIV, XOUT, NEQ, INFO)
C
C     Update
C
      DO 40 I=1, NEQ
	 XOUT(I) = XIN(I) + XOUT(I)
 40   CONTINUE
C
C     End of ONESTEP
C
      RETURN
      END
