fprintf(2, '\n** Sending a blocking request for "dsysv"\n\n')
clear
B=rand(20,5);
C=rand(20);
A=C+C';
[A1,IPIV,X,info]=netsolve('dsysv','U',A,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r1=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DSYSV(U) Failure **')
    r1
  else
    fprintf(2, '** DSYSV(U) Passed Tests **\n')
  end
end

[A1,IPIV,X,info]=netsolve('dsysv','L',A,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r2=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DSYSV(L) Failure **')
    r2
  else
    fprintf(2, '** DSYSV(L) Passed Tests **\n')
  end
end
