fprintf(2, '\n** Sending a blocking request for "dsygvx"\n\n')
clear N C1 A C2 B ITYPE info A1 B1 W r1 r
N=20;
C1=rand(N);
A=C1+C1';
C2=rand(N);
B=C2*C2';
ITYPE=1;
vl=1.0;
vu=5.0;
il=1;
iu=N;
abstol=0.5*eps;
[A1,B1,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'N','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
     r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=U) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=U) Passed Tests **\n')
  end
end

clear A1 B1 W info r1 r
[A1,B1,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'N','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
   r1(k)=(norm(A*A1(:,k)-W(k)*B*A1(:,k)))/(norm(A)*norm(B)*norm(A1(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 100.0 )
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=L) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=1,UPLO=L) Passed Tests **\n')
  end
end


ITYPE=2;
[A2,B2,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=U) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=U) Passed Tests **\n')
  end
end


clear A2 B2 W info r1 r
[A2,B2,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(A*B*A2(:,k)-W(k)*A2(:,k)))/(norm(A*B)*norm(A2(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=L) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=2,UPLO=L) Passed Tests **\n')
  end
end

ITYPE=3;
[A3,B3,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','U',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=U) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=U) Passed Tests **\n')
  end
end
clear A3 B3 W info r1 r
[A3,B3,m,W,Z,ifail,info]=netsolve('dsygvx',ITYPE,'V','A','L',A,B,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(B*A*A3(:,k)-W(k)*A3(:,k)))/(norm(B*A)*norm(A3(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=L) Failure **')
    r
  else
    fprintf(2, '** DSYGVX(ITYPE=3,UPLO=L) Passed Tests **\n')
  end
end
