fprintf(2, '\n** Sending a blocking request for "dsyevd"\n\n')
clear
N=20;
C=rand(N);
A=C+C';
[X,W,info]=netsolve('dsyevd','V','U',A);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
      r1(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVD(U) Failure **')
    r
  else
    fprintf(2, '** DSYEVD(U) Passed Tests **\n')
  end
end

clear
N=20;
C=rand(N);
A=C+C';
[X,W,info]=netsolve('dsyevd','V','L',A);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
      r2(k)=norm(A*X(:,k)-W(k)*X(:,k))/(norm(A)*norm(X(:,k))*eps);
  end
  r=max(r2);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSYEVD(L) Failure **')
    r
  else
    fprintf(2, '** DSYEVD(L) Passed Tests **\n')
  end
end
