fprintf(2, '\n** Sending a blocking request for "dsbevd"\n\n')
clear
N=20;
C1=rand(N);
KL=4;
KU=3;
B=rand(N,5);
for i=1:N
  for j=max(1,i-KL):min(N,i+KU)
        C2(i,j)=C1(i,j);
  end
end
A=C2+C2';
KD=KL+KU;
for j=1:N
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
W=zeros(N,1);
Z=zeros(N,N);
[AB1,W,Z,info]=netsolve('dsbevd','V','U',KD,AB1);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
      r1(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  rr=max(r1);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVD(U) Failure **')
    rr
  else
    fprintf(2, '** DSBEVD(U) Passed Tests **\n')
  end
end

for j=1:N
  for i=j:min(N,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
[AB2,W,Z,info]=netsolve('dsbevd','V','L',KD,AB2);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
      r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*eps);
  end
  clear rr
  rr=max(r2);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSBEVD(L) Failure **')
    rr
  else
    fprintf(2, '** DSBEVD(L) Passed Tests **\n')
  end
end
