fprintf(2, '\n** Sending a blocking request for "dposv"\n\n')
clear
n=20;
c=rand(n);
b=rand(n,5);
a=c*c';
[a1,x,info]=netsolve('dposv','U',a,b);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r1=norm(a*x-b)/(norm(a)*norm(x)*n*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DPOSV(U) Failure **')
    r1
  else
    fprintf(2, '** DPOSV(U) Passed Tests **\n')
  end
end

[a1,x,info]=netsolve('dposv','L',a,b);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r2=norm(a*x-b)/(norm(a)*norm(x)*n*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DPOSV(L) Failure **')
    r2
  else
    fprintf(2, '** DPOSV(L) Passed Tests **\n')
  end
end
