/*****************************************************************/
/*      netsolve.h                                               */
/*/*****************************************************************/

#define NetSolveOK                       0
#define NetSolveNotReady                -1
#define NetSolveSetNetSolveAgent        -2
#define NetSolveSetNetSolveRoot         -3
#define NetSolveSetNetSolveArch         -4
#define NetSolveInternalError           -5
#define NetSolveUnknownHost             -6
#define NetSolveNetworkError            -7
#define NetSolveUnknownProblem          -8
#define NetSolveProtocolError           -9
#define NetSolveNoServer                -10
#define NetSolveBadProblemSpecification -11
#define NetSolveNotAllowed              -12
#define NetSolveBadValues               -13
#define NetSolveDimensionMismatch       -14
#define NetSolveNoSolution              -15
#define NetSolveUnknownError            -16
#define NetSolveInvalidRequestID        -17
#define NetSolveBadProblemName          -18
#define NetSolveInvalidMajor            -19
#define NetSolveTooManyPendingRequests  -20
#define NetSolveFileError               -21
#define NetSolveUnknownDataFormat       -22
#define NetSolveInvalidUPFFilename      -23
#define NetSolveMismatch                -24
#define NetSolveSystemError             -25
#define NetSolveConnectionRefused       -26
#define NetSolveCannotBind              -27
#define NetSolveUPFError                -28
#define NetSolveUPFUnsafe               -29
#define NetSolveServerError             -30
#define NetSolveBadIterationRange       -31
#define NetSolveFarmingError            -32
#define NetSolveCannotStartProxy	-33
#define NetSolveUnknownServer		-34
#define NetSolveProxyError		-35
#define NetSolveCondorError		-36
#define NetSolveCannotContactAgent	-37
#define NetSolveTimedOut  -38

/* Sequences */
extern void*    NS_EndArg;           
#define NS_NULL   &NS_EndArg

/* Iterator */

typedef struct{
  char *expression;
}NS_IntIterator;

typedef struct{
  int *array;
  char *expression;
}NS_IntArrayIterator;

typedef struct{
  void **array;
  char *expression;
}NS_PtrArrayIterator;


typedef struct {
  int type;
  union {
    NS_IntIterator *int_iterator;
    NS_IntArrayIterator *int_array_iterator;
    NS_PtrArrayIterator *ptr_array_iterator;
  } it;
} NS_SpecificIterator;

typedef struct {
  int returned_type;
  int i;
  NS_SpecificIterator *specific;
}NS_Iterator;

NS_Iterator *ns_int(char*);
NS_Iterator *ns_int_array(int*,char*);
NS_Iterator *ns_ptr_array(void**,char*);

int netslmajor(char*);
void netslerr(int);

int netsl(char*,...);
int netslnb(char*,...);
int netslwt(int);
int netslpr(int);

int netslpr_assignment(int);
int netslwt_assignment(int,int*);
int netsl_assignment(char*,...);
int netslnb_assignment(char*,...);

int *netsl_farm(char*,...);

void    netsl_sequence_begin();     
int     netsl_sequence_end(void*,...);  
int     netsl_sequence_status();

int netslinit(char *agent);

void netsolvePerror(char*,int);
char *netsolveErrorMessage(int);

