function Z = msns_pst(Z,MU,iprm)
%
%  Postprocessing. This routine is the counterpart of 'msns_pre'. It 
%  backtransforms data generated by LYAPACK routines after the 
%  preprocessing:  Z <-- P'*inv(MU)*Z, where P is a permutation matrix
%  (P' is defined by iprm) and MU is the Cholesky factor of the system 
%  matrix M  (see description of 'msns_pre'!).
%
%  Calling sequence:
%
%    Z = msns_pst(Z,MU,iprm)
%    Z = msns_pst(Z,[],iprm)
%
%  Input:
%
%    Z         n-x-m matrix;
%    MU        Cholesky factor of (reordered) system matrix MU;
%              if MU is available as global data (i.e., if 'msns_m_i'
%              has been called before calling this routine, but not
%              'msns_d_i'), MU needs not be provided as parameter: 
%              set MU = [];
%    iprm      the inverse permutation generated by 'msns_pre'.
%
%  Output:
%
%    Z         backtransformed input matrix.
%
%
%  LYAPACK 1.0 (Thilo Penzl, October 1999)

% Input data not completely checked!
 
if length(MU)
  Z = MU\Z;
  Z = Z(iprm,:);
else
  global LP_MU
  if ~length(LP_MU)
  error('If MU is not provided via the command line, this routine needs global data which must be generated by calling ''msns_m_i'' first. Note: this data might have been destroyed by ''msns_m_d''.');
  end

  Z = LP_MU\Z;
  Z = Z(iprm,:);
end  
