function Y = au_qmr_ilu_m(tr,X)
%
%  Evaluates matrix-matrix products with the real matrix A or its
%  transposed A':
%
%  for tr = 'N':
%
%    Y = A*X,
%
%  for tr = 'T':
%
%    Y = A'*X.
%
%  A is provided as global data. This data must be generated by calling
%  'au_qmr_ilu_m_i' before calling this routine!
%  
%  If called without input parameters, this routine returns the order of
%  the matrix A.
%
%  Calling sequence:
%
%    Y = au_qmr_ilu_m(tr,X)
%    n = au_qmr_ilu_m
%
%  Input:
%
%    tr        (= 'N' or 'T') determines whether products with A or A' 
%              should be computed;
%    X         a matrix of proper size.
%
%  Output:
%
%    Y         the resulting product;
%    n         the order of the matrix A.
%
%
%  LYAPACK 1.0 (Thilo Penzl, August 1999)

ni = nargin;

if ni~=2 & ni~=0
  error('Wrong number of input arguments.');
end

global LP_A

if ~length(LP_A)
  error('This routine needs global data which must be generated by calling ''au_qmr_ilu_m_i'' first.');
end 

if ni==0
  Y = size(LP_A,1);  
else
  if tr=='N'
    Y = LP_A*X;
  elseif tr=='T'
    Y = LP_A'*X;
  else
    error('tp must be either ''N'' or ''T''.');
  end
end


