function X = as_pst(X,iprm)
%
%  Postprocessing. This routine is the counterpart of 'as_pre'. It 
%  re-reorderes data generated by LYAPACK routines after the 
%  preprocessing:  X <-- X(:,iprm).
%
%  Calling sequence:
%
%    X = as_pst(X,iprm)
%
%  Input:
%
%    X         n-x-m matrix; 
%    iprm      the inverse permutation generated by 'as_pre'.
%
%  Output:
%
%    X         re-permuted matrix.
%
%  Example:
%
%    After preprocessing with 'as_pre' the Lyapunov equation 
%    A*Q + Q*A = - B*B' has been solved by 'lp_lrsl', which has delivered
%    a low rank approximation Q~Z*Z'. If the solution of the original
%    Lyapunov equation (i.e., the equation before preprocessing) is sought,
%    Z must be re-reordered by calling
%
%      Z = as_pst(Z,iprm);
%  
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

% Input data not completely checked!
 
X = X(iprm,:);
