function as_l_i
%
%  Generates the data used in 'as_l'. Data are stored in global
%  variables.
%
%  NOTE that 'as_m_i' must be called before calling this routine.
% 
%  Calling sequence:
%
%    as_l_i
%
%  Remarks:
% 
%    The matrix A, which has been provided as global data by 'as_m_i',
%    must be real, symmetric, negative definite. 
%
%
%  LYAPACK 1.0 (Thilo Penzl, May 1999)

global LP_A LP_U

if ~length(LP_A)
  error('This routine needs global data which must be generated by calling ''as_m_i'' first.');
end 

[LP_U,t] = chol(-LP_A);        % Note the minus!

if t~=0
  error('The matrix A, which has been provided as global data by routine ''as_m_i'', is not (numerically) negative definite!');
end



