**********************************************************************
C
C     Copyright (C) 1992  Roland W. Freund and Noel M. Nachtigal
C     All rights reserved.
C
C     This code is part of a copyrighted package.  For details, see the
C     file `cpyrit.doc' in the top-level directory.
C
C     *****************************************************************
C     ANY USE OF  THIS CODE CONSTITUTES ACCEPTANCE OF  THE TERMS OF THE
C                             COPYRIGHT NOTICE
C     *****************************************************************
C
C**********************************************************************
C
      DOUBLE PRECISION FUNCTION DZNRM1 (N,ZX,INCX)
C
C     Purpose:
C     This function computes the 1-norm of ZX.
C
C     Parameters:
C     N    = the dimension of the vectors (input).
C     ZX   = the vector whose 1-norm is to be computed (input).
C     INCX = the stride (input).
C
C     Noel M. Nachtigal
C     March 23, 1993
C
C**********************************************************************
C
      INTRINSIC CDABS
C
      INTEGER INCX, N
      DOUBLE COMPLEX ZX(N)
C
C     Local variables.
C
      INTEGER I, IX
      DOUBLE PRECISION DTMP
C
      IF (N.LE.0) RETURN
      DTMP = 0.0D0
      IF (INCX.EQ.1) GO TO 20
C
      IX = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      DO 10 I = 1, N 
         DTMP = DTMP + CDABS(ZX(IX))
         IX   = IX + INCX
 10   CONTINUE
      DZNRM1 = DTMP
      RETURN
C
 20   DO 30 I = 1, N
         DTMP = DTMP + CDABS(ZX(I))
 30   CONTINUE
      DZNRM1 = DTMP
      RETURN
C
      END
C
C**********************************************************************
