#if defined(_EIG_)
#define _L1_ 30
#define _L2_ 40
#else
#define _L1_ 80
#define _L2_ 90
#endif
C**********************************************************************
C
C     Copyright (C) 1992  Roland W. Freund and Noel M. Nachtigal
C     All rights reserved.
C
C     This code is part of a copyrighted package.  For details, see the
C     file "cpyrit.doc" in the top-level directory.
C
C     *****************************************************************
C     ANY USE OF  THIS CODE CONSTITUTES ACCEPTANCE OF  THE TERMS OF THE
C                             COPYRIGHT NOTICE
C     *****************************************************************
C
C**********************************************************************
C
      PROGRAM _MAIN_
C
#if defined(_LAL_)
C     This program uses the three-term look-ahead  Lanczos algorithm to
C     compute eigenvalue estimates.
#else
C     This is an example driver code for the solution of linear systems
C     with coefficient  matrices stored  in the  compressed  sparse row
#endif
#if defined(_ALLSYS_)
C     format.
#elif defined(_BCG_)
C     format, using the BCG algorithm.
#elif defined(_CPL_)
C     format, using the coupled QMR algorithm with look-ahead.
#elif defined(_CPX_)
C     format, using the coupled QMR algorithm without look-ahead.
#elif defined(_QBG_)
C     format, using the QMR-from-BCG algorithm.
#elif defined(_QMR_)
C     format, using the QMR algorithm with look-ahead.
#elif defined(_QMX_)
C     format, using the QMR algorithm without look-ahead.
#elif defined(_TFX_)
C     format, using the TFQMR algorithm.
#endif
C
C     The driver will ask the user for various run-time parameters, and
C     will expect to find the starting guess  in a file called "x.dat".
C     Note that the  file name is in  lower case (for systems where the
C     case is significant, such as Unix).  All the vectors  are assumed
C     to be of length NROW.  It is  the responsibility  of the  user to
C     ensure that there is enough data in the files.
C
C     NOTE: This code uses an input format that, while valid on the Sun
C     and Cray compilers, might not be accepted  by other compilers. In
C     particular, the construct
C        WRITE (6,'(A30,$)') 'This is a test'
C     is used to prevent  the output processor from  moving to the next
C     line after writing the text.  If this construct  is not supported
C     by the compiler, remove the dollar sign ($).
C     Also, the user input in this code is not bullet-proof. It assumes
C     that the user will provide valid inputs, i.e., numbers where they
C     are expected, etc. Providing invalid input type will likely crash
C     the program.
C
C     Noel M. Nachtigal
C     March 9, 1992
C
C**********************************************************************
C
#if defined(_TRANSP_REQ_)
      EXTERNAL ZUIL1I, ZUIL1T, ZUIL2I, ZUIL2T, ZUILST
      EXTERNAL ZUS2SI, ZUS2ST, ZUSS1I, ZUSS1T, ZUSS2I, ZUSS2T, ZUSSST
      EXTERNAL ZSPAXB, ZSPATX, ZSPRAS, ZSPRRW, ZAXPBY, _ZALG_
#else
      EXTERNAL ZUIL1I, ZUIL2I, ZUILST, ZUS2SI, ZUSS1I, ZUSS2I, ZUSSST
      EXTERNAL ZSPAXB, ZSPRAS, ZSPRRW, ZAXPBY, _ZALG_
#endif
C
C     Parameters for the data format and the preconditioners.
C
      INTEGER NDIM, NZMAX, NZLMAX, NZUMAX
      PARAMETER (NDIM=1000,NZMAX=300000,NZLMAX=150000,NZUMAX=150000)
#include "csr.inc"
#if defined(_CPL_)
C
C     Parameters for some of the solvers.
C
      INTEGER M, MAXN, MAXPQ, MAXVW
      PARAMETER (MAXN = 5002, MAXPQ = 3, MAXVW = 3)
      PARAMETER (M = MAXVW+MAXPQ+2)
#elif defined(_LAL_)
C
C     Parameters for some of the solvers.
C
      INTEGER M, MAXN, MAXVW
      PARAMETER (MAXN = 202, MAXVW = 3, M = 2*MAXVW+2)
#elif defined(_QMR_)
C
C     Parameters for some of the solvers.
C
      INTEGER M, MAXN, MAXVW
      PARAMETER (MAXN = 5002, MAXVW = 3, M = 2*MAXVW+2)
#endif
C
C     Miscellaneous parameters.
C
      DOUBLE COMPLEX ZONE, ZZERO
      PARAMETER (ZONE = (1.0D0,0.0D0), ZZERO = (0.0D0,0.0D0))
C
C     Variables for the data format and the preconditioners.
C
      LOGICAL JT(NDIM)
      CHARACTER TYPE*3
      INTEGER IA(NDIM+1), IDA(NDIM), IL(NDIM+1), IU(NDIM+1), JA(NZMAX)
      INTEGER JI(NDIM), JL(NZLMAX), JU(NZUMAX), NCOL, NROW, PRECON
      DOUBLE COMPLEX A(NZMAX), AINV(NDIM), DR(NDIM), DUINV(NDIM)
      DOUBLE COMPLEX L(NZLMAX), U(NZUMAX)
      DOUBLE PRECISION DN(NDIM), DS(NDIM), OMEGA
C
      EQUIVALENCE (IDA,JI)
      EQUIVALENCE (AINV,DUINV)
C
C     Variables for the solver.
C
      INTEGER INFO(4), NLEN, NLIM
#if defined(_BCG_)
      DOUBLE COMPLEX VECS(NDIM,VECDIM), XZR(NDIM)
      DOUBLE PRECISION TOL
#elif defined(_CPL_)
      INTEGER IDX(6,MAXN), IWK(M,13), MVEC
      DOUBLE COMPLEX VECS(NDIM,5*(MAXPQ+MAXVW)+3), XZR(NDIM)
      DOUBLE COMPLEX ZWK(M,8*M+7)
      DOUBLE PRECISION DWK(M,11), NORMS(2), TOL
#elif defined(_CPX_)
      DOUBLE COMPLEX VECS(NDIM,VECDIM), XZR(NDIM)
      DOUBLE PRECISION TOL
#elif defined(_LAL_)
      INTEGER IDX(3,MAXN), IWK(M,4)
      DOUBLE COMPLEX VECS(NDIM,2*MAXVW+6)
      DOUBLE COMPLEX ZWK(M,5*M+3)
      DOUBLE PRECISION DWK(M,4), HWK(MAXN,4*MAXN+8), NORM
#elif defined(_QBG_)
      DOUBLE COMPLEX VECS(NDIM,VECDIM), XZR(NDIM)
      DOUBLE PRECISION TOL
#elif defined(_QMR_)
      INTEGER IDX(3,MAXN), IWK(M,4)
      DOUBLE COMPLEX VECS(NDIM,4*MAXVW+8), XZR(NDIM)
      DOUBLE COMPLEX ZWK(M,5*M+7)
      DOUBLE PRECISION DWK(M,6), NORM, TOL
#elif defined(_QMX_)
      DOUBLE COMPLEX VECS(NDIM,VECDIM), XZR(NDIM)
      DOUBLE PRECISION TOL
#elif defined(_TFX_)
      DOUBLE COMPLEX VECS(NDIM,VECDIM), XZR(NDIM)
      DOUBLE PRECISION TOL
#endif
C
C     Variables used by reverse communication.
C
      INTEGER CB, CX, IERR, REVCOM
C
C     Local driver variables.
C
#if defined(_BCG_)
      INTEGER I, OLDPRE, PRE
#elif defined(_CPL_)
      INTEGER I, MAXXPQ, MAXXVW, OLDPRE, PRE
#elif defined(_CPX_)
      INTEGER I, OLDPRE, PRE
#elif defined(_LAL_)
      INTEGER MAXXVW, OLDPRE, PRE
#elif defined(_QBG_)
      INTEGER I, OLDPRE, PRE
#elif defined(_QMR_)
      INTEGER I, MAXXVW, OLDPRE, PRE
#elif defined(_QMX_)
      INTEGER I, OLDPRE, PRE
#elif defined(_TFX_)
      INTEGER I, OLDPRE, PRE
#endif
      LOGICAL NEWMAT
      CHARACTER ANS*1, FNAME*72
      DOUBLE COMPLEX XTMP(NDIM)
C
C     Get the data file from the user.
C
      PRE    = 0
      NEWMAT = .TRUE.
 10   NROW = 0
      WRITE (6,'(A26,$)') 'Enter CSR data file name: '
      READ (5,'(A72)') FNAME
      WRITE (6,'(A26,$)')  'A)SCII or B)inary data ? '
      READ (5,'(A1)') ANS
C
C     Read in the matrix.
C
      IF ((ANS.EQ.'B').OR.(ANS.EQ.'b')) THEN
         OPEN (10,FILE=FNAME,FORM='UNFORMATTED',STATUS='old',ERR=20)
         CALL ZSPRRW (NDIM,NZMAX,NROW,NCOL,A,IA,JA,TYPE,10,6,IERR)
      ELSE
         OPEN (10,FILE=FNAME,STATUS='old',ERR=20)
         CALL ZSPRAS (NDIM,NZMAX,NROW,NCOL,A,IA,JA,TYPE,10,6,IERR)
      END IF
      CLOSE (10)
C
C     Check for errors.
C
      IF (IERR.NE.0) NROW = 0
 20   IF (NROW.EQ.0) THEN
         WRITE (6,'(A42)') 'Error encountered reading the matrix file.'
      ELSE IF (NROW.NE.NCOL) THEN
         WRITE (6,'(A28)') 'Error, matrix is not square.'
         NROW = 0
      END IF
      IF (NROW.EQ.0) GO TO _L2_
#if defined(_EIG_)
      NLEN = NROW
#endif
#if defined(_SYS_)
C
C     Read in the vector b.
C
 30   NLEN = 0
      WRITE (6,'(A31,$)') 'Enter rhs data file name     : '
      READ (5,'(A72)') FNAME
      OPEN (10,FILE=FNAME,STATUS='old',ERR=40)
      READ (10,*,END=40,ERR=40) (VECS(I,2),I=1,NROW)
      NLEN = NROW
 40   CLOSE (10)
      IF (NLEN.EQ.0) THEN
         WRITE (6,'(A39)') 'Error encountered reading the rhs file.'
         WRITE (6,'(A20,$)') 'Try another (Y/N) ? '
         READ (5,'(A1)') ANS
         IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 30
         GO TO 70
      END IF
C
C     Read in the vector x_0.
C
 50   NLEN = 0
      WRITE (6,'(A31,$)') 'Enter starting guess file    : '
      READ (5,'(A72)') FNAME
      OPEN (10,FILE=FNAME,STATUS='old',ERR=40)
      READ (10,*,END=60,ERR=60) (XZR(I),I=1,NROW)
      NLEN = NROW
 60   CLOSE (10)
      IF (NLEN.EQ.0) THEN
         WRITE (6,'(A32)') 'Error encountered reading x.dat.'
         WRITE (6,'(A18,$)') 'Try again (Y/N) ? '
         READ (5,'(A1)') ANS
         IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 50
         GO TO 70
      END IF
 70   IF (NLEN.EQ.0) GO TO _L2_
C
C     Get the convergence tolerance.
C
      WRITE (6,'(A31,$)') 'Enter convergence tolerance  : '
      READ (5,*) TOL
#endif
C
C     Get the maximum number of iteration steps.
C
      WRITE (6,'(A31,$)') 'Maximum number of steps NLIM : '
      READ (5,*) NLIM
#if defined(_CPL_) || defined(_LAL_) || defined(_QMR_)
      IF (NLIM.GT.MAXN-2) THEN
         NLIM = MAXN-2
         WRITE (6,'(A31,I10)') 'NLIM too large, adjusted to  : ', NLIM
      END IF
C
C     Solver-specific initialization.
C
#if defined(_CPL_)
      WRITE (6,'(A31,$)') 'Enter estimated norm for P&Q : '
      READ (5,*) NORMS(1)
      WRITE (6,'(A31,$)') 'Enter estimated norm for V&W : '
      READ (5,*) NORMS(2)
#else
      WRITE (6,'(A31,$)') 'Enter estimated norm for V&W : '
      READ (5,*) NORM
#endif
C
C     Set the maximum block and storage information.
C
      MAXXVW = MAXVW
#if defined(_CPL_)
      MAXXPQ = MAXPQ
      MVEC   = MAXPQ + MAXVW
#endif
#endif
C
C     Select a preconditioner.
C
      OLDPRE = PRE
      PRE    = 0
      WRITE (6,'(A42)') 'Choices of preconditioner    : 0 = no prec'
      WRITE (6,'(A44)') '                               1 = Left ILUT'
      WRITE (6,'(A45)') '                               2 = Right ILUT'
      WRITE (6,'(A49)')
     $       '                               3 = Two-sided ILUT'
      WRITE (6,'(A44)') '                               4 = Left SSOR'
      WRITE (6,'(A45)') '                               5 = Right SSOR'
      WRITE (6,'(A49)')
     $       '                               6 = Two-sided SSOR'
      WRITE (6,'(A31,$)') 'Select a preconditioner      : '
      READ (5,*) PRECON
      IF ((PRECON.EQ.ILUTLF).OR.(PRECON.EQ.ILUTRT).OR.(PRECON.EQ.ILUT2S)) THEN
         PRE = 1
      ELSE IF ((PRECON.EQ.SSORLF).OR.(PRECON.EQ.SSORRT).OR.(PRECON.EQ.SSOR2S)) THEN
         PRE = 2
      ELSE
         PRECON = 0
         OLDPRE = PRE + 1
      END IF
C
C     Initialize the preconditioner.
C
      IF ((.NOT.NEWMAT).AND.(PRE.EQ.OLDPRE)) THEN
         WRITE (6,'(A31,$)') 'Reuse the preconditioner (Y/N) '
         READ (5,'(A1)') ANS
         NEWMAT = (ANS.EQ.'N').OR.(ANS.EQ.'n')
      END IF
      IF (NEWMAT.OR.(PRE.NE.OLDPRE)) THEN
         IF (PRE.EQ.1) THEN
            CALL ZUILST (NROW,A,IA,JA,L,IL,JL,U,IU,JU,JT,JI,DN,DR,DS,
     $                   DUINV,NZLMAX,NZUMAX,IERR)
         ELSE IF (PRE.EQ.2) THEN
            CALL ZUSSST (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON)
         END IF
      END IF
#if defined(_SYS_)
C
C     Compute the modified right hand side.
C
      CALL ZSPAXB (NROW,A,IA,JA,TYPE,XZR,XTMP)
      CALL ZAXPBY (NLEN,VECS(1,2),ZONE,VECS(1,2),-ZONE,XTMP)
      IF (PRE.EQ.1) THEN
         CALL ZUIL1I (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,VECS(1,2))
      ELSE IF (PRE.EQ.2) THEN
         CALL ZUSS1I (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,VECS(1,2))
      END IF
C
C     Set up call to linear systems solver.
C     Compute true residual norms, generate second starting vector.
C
      INFO(2) = 0
      INFO(1) = 011106
#else
C
C     Set up call to eigenvalue solver.
C     Generate both starting vectors.
C
      INFO(2) = 0
      INFO(1) = 001106
#endif
C
C     Open the output files.
C
#if defined(_SYS_)
      OPEN (11,FILE = 'res.out')
#else
      OPEN (11,FILE = 'eig.out')
#endif
C
C     Call the solver.
C
#if defined(_BCG_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,VECS,TOL,INFO)
#elif defined(_CPL_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,MAXXPQ,MAXXVW,M,MVEC,NORMS,ZWK,DWK,IDX,
     $           IWK,VECS,TOL,INFO)
#elif defined(_CPX_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,VECS,TOL,INFO)
#elif defined(_LAL_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,MAXN,MAXXVW,M,NORM,ZWK,DWK,IDX,IWK,HWK,
     $           VECS,INFO)
#elif defined(_QBG_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,VECS,TOL,INFO)
#elif defined(_QMR_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,MAXXVW,M,NORM,ZWK,DWK,IDX,IWK,VECS,TOL,
     $           INFO)
#elif defined(_QMX_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,VECS,TOL,INFO)
#elif defined(_TFX_)
 _L1_   CALL _ZALG_ (NDIM,NLEN,NLIM,VECS,TOL,INFO)
#endif
C
C     Perform matrix-vector multiplications when needed.
C
      IERR   = INFO(1)
      REVCOM = INFO(2)
      CX     = INFO(3)
      CB     = INFO(4)
C
C     Multiply VECS(1,CX) with the preconditioned matrix.
C
      IF (REVCOM.EQ.1) THEN
         IF (PRE.EQ.0) THEN
            CALL ZSPAXB (NROW,A,IA,JA,TYPE,VECS(1,CX),VECS(1,CB))
         ELSE IF (PRE.EQ.1) THEN
            CALL ZAXPBY (NLEN,XTMP,ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUIL2I (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,XTMP)
            CALL ZSPAXB (NROW,A,IA,JA,TYPE,XTMP,VECS(1,CB))
            CALL ZUIL1I (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,VECS(1,CB))
         ELSE IF ((PRECON.EQ.SSORLF).OR.(PRECON.EQ.SSORRT)) THEN
            CALL ZAXPBY (NLEN,XTMP,ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUSS2I (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,XTMP)
            CALL ZSPAXB (NROW,A,IA,JA,TYPE,XTMP,VECS(1,CB))
            CALL ZUSS1I (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,VECS(1,CB))
         ELSE IF (PRECON.EQ.SSOR2S) THEN
            CALL ZAXPBY (NLEN,VECS(1,CB),ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUS2SI (NROW,A,IA,JA,AINV,IDA,OMEGA,PRECON,
     $                   VECS(1,CB),XTMP)
         END IF
         GO TO _L1_
#if defined(_TRANSP_REQ_)
C
C     Multiply VECS(1,CX) with the preconditioned transpose.
C
      ELSE IF (REVCOM.EQ.2) THEN
         IF (PRE.EQ.0) THEN
            CALL ZSPATX (NLEN,A,IA,JA,TYPE,VECS(1,CX),VECS(1,CB))
         ELSE IF (PRE.EQ.1) THEN
            CALL ZAXPBY (NLEN,XTMP,ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUIL1T (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,XTMP)
            CALL ZSPATX (NLEN,A,IA,JA,TYPE,XTMP,VECS(1,CB))
            CALL ZUIL2T (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,VECS(1,CB))
         ELSE IF ((PRECON.EQ.SSORLF).OR.(PRECON.EQ.SSORRT)) THEN
            CALL ZAXPBY (NLEN,XTMP,ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUSS1T (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,XTMP)
            CALL ZSPATX (NLEN,A,IA,JA,TYPE,XTMP,VECS(1,CB))
            CALL ZUSS2T (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,VECS(1,CB))
         ELSE IF (PRECON.EQ.SSOR2S) THEN
            CALL ZAXPBY (NLEN,VECS(1,CB),ZONE,VECS(1,CX),ZZERO,XTMP)
            CALL ZUS2ST (NROW,A,IA,JA,AINV,IDA,OMEGA,PRECON,
     $                   VECS(1,CB),XTMP)
         END IF
         GO TO _L1_
#endif
#if defined(_P_SYMM_)
C
C     Multiply VECS(1,CX) by the symmetry matrix P.
C
      ELSE IF (REVCOM.EQ.3) THEN
         CALL ZAXPBY (NLEN,VECS(1,CB),ZONE,VECS(1,CX),ZZERO,XTMP)
         GO TO _L1_
#endif
      END IF
C
C     Close the output files.
C
      CLOSE (11)
C
C     Check why the solver stopped.
C
#if defined(_CPL_) || defined(_LAL_) || defined(_QMR_)
      IF (IERR.LT.0) THEN
         WRITE (6,'(A40,I5)')
     $          'Error encountered in the ZSVDC routine: ', -IERR
      ELSE IF (IERR.EQ.0) THEN
#else
      IF (IERR.EQ.0) THEN
#endif
#if defined(_LAL_)
         WRITE (6,'(A34)') 'The algorithm terminated normally.'
#else
         WRITE (6,'(A32)') 'The residual norm has converged.'
#endif
      ELSE IF (IERR.EQ.1) THEN
         WRITE (6,'(A35)') 'Invalid reverse communication call.'
      ELSE IF (IERR.EQ.2) THEN
         WRITE (6,'(A27)') 'Invalid inputs encountered.'
#if !defined(_LAL_)
      ELSE IF (IERR.EQ.4) THEN
         WRITE (6,'(A31)') 'The algorithm did not converge.'
#endif
#if defined(_CPL_) || defined(_QMR_) || defined(_LAL_)
      ELSE IF (IERR.EQ.8) THEN
         WRITE (6,'(A35)') 'The last block could not be closed.'
      ELSE IF (IERR.EQ.16) THEN
         WRITE (6,'(A39)') 'An A-invariant subspace has been found.'
      ELSE IF (IERR.EQ.32) THEN
         WRITE (6,'(A41)') 'An A^T-invariant subspace has been found.'
      ELSE IF (IERR.EQ.48) THEN
         WRITE (6,'(A41)') 'Both invariant subspaces have been found.'
#if defined(_CPL_)
      ELSE IF (IERR.EQ.64) THEN
         WRITE (6,'(A30)') 'Insufficient memory allocated.'
      ELSE IF (IERR.EQ.128) THEN
         WRITE (6,'(A32)') 'Cannot convert regular to inner.'
#endif
#else
      ELSE IF (IERR.EQ.8) THEN
         WRITE (6,'(A25)') 'The algorithm broke down.'
#if defined(_CPX_)
      ELSE IF (IERR.EQ.16) THEN
         WRITE (6,'(A39)') 'An A-invariant subspace has been found.'
      ELSE IF (IERR.EQ.32) THEN
         WRITE (6,'(A41)') 'An A^T-invariant subspace has been found.'
      ELSE IF (IERR.EQ.48) THEN
         WRITE (6,'(A41)') 'Both invariant subspaces have been found.'
#endif
#endif
      ELSE
         WRITE (6,'(A19,I5)') 'Unknown INFO code: ', IERR
      END IF
#if !defined(_LAL_)
C
C     Compute the unpreconditioned solution.
C
      IF (PRE.EQ.1) THEN
         CALL ZUIL2I (NROW,L,IL,JL,U,IU,JU,DUINV,PRECON,VECS(1,1))
      ELSE IF (PRE.EQ.2) THEN
         CALL ZUSS2I (NLEN,A,IA,JA,AINV,IDA,OMEGA,PRECON,VECS(1,1))
      END IF
      CALL ZAXPBY (NLEN,XZR,ZONE,XZR,ZONE,VECS(1,1))
C
C     Dump X to file x.out.
C
      OPEN (11,FILE = 'x.out')
      WRITE(11,'(2E25.17)') (XZR(I),I=1,NLEN)
      CLOSE (11)
#endif
C
C     Do it again?
C
 _L2_   WRITE (6,'(A18,$)') 'Run again (Y/N) ? '
      READ (5,'(A1)') ANS
      NEWMAT = .TRUE.
      IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) THEN
         IF (NLEN.EQ.0) GO TO 10
         WRITE (6,'(A28,$)') 'Read another matrix (Y/N) ? '
         READ (5,'(A1)') ANS
         IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 10
         NEWMAT = .FALSE.
         GO TO 20
      END IF
C
C     Done.
C
      STOP
      END
C
C**********************************************************************
