************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WWSAX - Generalized saxpy routine (^)
**
************************************************************************
**
      subroutine zwsax ( z , y , x , c ,  iparm , fparm , iwk , fwk , ie
     &r  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Performs the saxpy operation (alpha x plus y, where alpha is a
**    scalar and x and y are vectors) and places the result in z.
**    Here the scalar constant value is passed as c (z = c x + y).
**    The operation is general in that the result is placed into z
**    instead of overwriting y.  This routine is part of the Low-level
**    level-1 BLAS-type routine required by pcg package.  Written for
**    Sun, Cray YMP, Ncube, iPSC 860, or generic f77; as set by m4
**    variable f77.
**    
**    On a Cray YMP the vector is partitioned out to all available
**    processors.  The partitioning is done using compiler directives,
**    thus the compiler decides how the partitioning is done.
**    
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below. 
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**     Basic vector addition and multiplication of a vector by a scalar.
**    
**  ^REFERENCES:
**    
**  ^DOCUMENTATION:
**      
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
**  ^MACROS USED:
**
************************************************************************
*
*     implicit character*1 (a-z)
*#    BASICAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      double complex       z(*)
      double complex       x(*)
      double complex       y(*)
      double complex c
      integer nv
      integer i
      double complex cval
      double precision cval2(2)
      equivalence (cval,cval2)
      external zwset
      external zwadd
      external zwsub
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: wsax.fm4,v 1.10 1994/07/15 19:43:46 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
*-----------------------------------------------------------------------
*--- First check for special cases based on the value of c -------------
*-----------------------------------------------------------------------
      if (c .eq. (0d0,0.0d0)) then
        call zwset ( z , y ,  iparm , fparm , iwk , fwk , ier  )
        go to 910
      endif
      if (c .eq. (1d0,0.0d0)) then
        call zwadd ( z , y , x ,  iparm , fparm , iwk , fwk , ier  )
        go to 910
      endif
      if (c .eq. -(1d0,0.0d0)) then
        call zwsub ( z , y , x ,  iparm , fparm , iwk , fwk , ier  )
        go to 910
      endif
*-----------------------------------------------------------------------
*--- General case: handle different machines----------------------------
*-----------------------------------------------------------------------
      nv = iparm(3)
      cval = c
      do 5500 i = 1, nv
              z(i) = y(i) + c*x(i)
5500  continue
*
*-----------------------------------------------------------------------
*--- Final exit---------------------------------------------------------
*-----------------------------------------------------------------------
*
 900  continue
*
      fparm(3) = fparm(3) + (8.*nv)
*
 910  continue
      return
      end
