************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WRIGRX - Preconditioning routine for Richardson method
**            preconditioner, regular grid format. Essentially sets the 
**            output vector vo to the input vector vi.
**            (^)
**    
************************************************************************
**    
      subroutine zrigrx ( ijob , ia , ja , a , vi , vo ,
     &       iwk , fwk , iparm , fparm , ier )
**    
************************************************************************
**    
**  ^DESCRIPTION: Preconditioning routine for Richardson method
**      preconditioner, regular grid format. Essentially sets the 
**      output vector vo to the input vector vi. 
**    
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: see External declerations below
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**    
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**   
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    MVFFAL            -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer ia(*)
      integer ja(*)
      double complex a(*)
      double complex vi(*)
      double complex vo(*)
*
        integer ipme
        integer nproc
*
      external zwset
*
******^^****************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: rigrx.fm4,v 1.10 1994/09/06 17:34:57 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      ipme  = 0
      nproc = 1
      if (ijob.eq.1) then
        iparm(11) = (iparm(6))
        if (iparm(2) .ge. 4) then
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),*) '     Richardson''s Method (null) Preconditio
     &ner.'
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        endif
        go to 900
      endif
*
      if (ijob.eq.-1) then
        go to 900
      endif
*
      if      (ijob .eq. 5) then
        call zwset ( vo , vi ,  iparm , fparm , iwk , fwk , ier  )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 6) then
        call zwset ( vo , vi ,  iparm , fparm , iwk , fwk , ier  )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 7) then
        call zwset ( vo , vi ,  iparm , fparm , iwk , fwk , ier  )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 8) then
        call zwset ( vo , vi ,  iparm , fparm , iwk , fwk , ier  )
           if (ier .lt. 0) go to 900
      else
                ier = -4
                call xersho ( ier, 'zrigrx' , iparm , ' ' )
                go to 900
      endif
*
 900  continue
*
      return
      end
