************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WPCG - Top-level pcg package routine. (^)
**
************************************************************************
**
      subroutine zpcg ( ijob , precon , accel , ia , ja , a ,
     &       u , uexact , b ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This is the main top-level routine of the package.  It does some
**    initializations and then passes everything down to the
**    preconditioner generator.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WARGCK - Routine to check the validity of iparm and
**                fparm entries on entry to the package.
**       WIFPPR - Routine to print iparm/fparm variables if requested.
**       xtimer - Package timer routine.  Returns cpu time as well as
**                real time.
**       precon - local value of subroutine name of preconditioner
**                passed through as argument to this subroutine.  The
**                precon routine generates the preconditioner and calls
**                the accelerator.
**       accel  - local value of subroutine name for accelerator.
**                Passed down through precon.
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**       Solves the linear system.  Modifies u, iparm, fparm, and
**       sometimes others.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    TOPAL             - Top Level arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external precon, accel
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer ia(*)
      integer ja(*)
      double complex a(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
*
        integer ipme
        integer nproc
        integer itimer
        double precision tc1, tr1, tc2, tr2
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
*
      external zargck
      external zifppr
      external xtimer
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: pcg.fm4,v 1.22 1994/07/06 05:51:46 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      itimer = 0
*
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 2
      if (iparm(27) .eq. 2) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call zfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call zargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      if (ijob.ne.1 .and. ijob.ne.2 .and. ijob.ne.-1 .and.
     &    ijob.ne.0  .and.
     &    ijob.ne.3  .and. ijob.ne.4  .and. ijob.ne.5) then
                ier = -4
                call xersho ( ier, 'zpcg' , iparm ,
     &                        'Argument ijob' )
                go to 900
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 2) then
        call zifppr ( 1 , iparm, fparm, ier )
           if (ier .lt. 0) go to 900
      endif
*
      call precon ( ijob , accel , ia , ja , a , u , uexact , b ,
     &       iwk , fwk , iparm , fparm , ier )
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(21) = fparm(21) + (tc2-tc1)
        fparm(22) = fparm(22) + (tr2-tr1)
      endif
      if (iparm(27) .eq. 2) then
        call zifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---reset iclev----------
      if (iparm(27) .eq. 2) iparm(27) = 0
*
      return
      end
