************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WMETH  - Workhorse routine to implement a particular
**                     itmeth level algorithm, direct communication
**                     interface. (^)
**
************************************************************************
**
      subroutine zmeth ( wmethr ,  ijob , suba , ia , ja  , a ,
     &       subq , iq , jq , q , u , uexact , b ,
     &       iwk , fwk , iparm , fparm , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Wrapper routine to provide direct communication interface to
**    a given iterative method's reverse communication routine.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Wrapper to give direct communication interface for a reverse
**    communication iterative acceleration routine.
**    The central part of this routine is a loop which alternately
**    calls the revcom routine and processes its requests for the
**    matrix-vector product, preconditioning, and so forth.
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*     ****Subroutine Arguments**********
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer ia(*)
      integer ja(*)
      integer iq(*)
      integer jq(*)
      double complex a(*)
      double complex q(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
      external wmethr
*
*     ****Local Variables**********
        integer ipme
        integer nproc
        integer itimer
        double precision tc1, tr1, tc2, tr2
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
      integer iptr
      integer    iptrrc
      integer    ijobr, ireq
      integer    needrc
          integer ivql
          integer iva
          integer ivqr
      double complex flops
*
*     ****Externals**********
      external   zargck
      external   zifppr
      external   xtimer
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: meth.fm4,v 1.21 1994/11/22 05:20:38 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
*     *---preliminary work----------
      itimer = 0
      ijobr = 1
*
*     *---initialize----------
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 1
      if (iparm(27) .eq. 1) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call zfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call zargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
*     *---check ijob----------
      if (ijob.lt.0 .or. ijob.gt.0) then
                ier = -4
                call xersho ( ier, 'zmeth' , iparm ,
     &                        'Argument ijob' )
                go to 900
      endif
*
*     *---start timer------
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 1) then
        call zifppr ( 1 , iparm, fparm, ier )
           if (ier .lt. 0) go to 900
      endif
*
*
      needrc = iparm(15)
      iparm(15) = 0
      iptrrc = (iparm(6))
*
*-----------------------------revcom loop-------------------------------
*
 10   continue
*       *---call the revcom routine----------
        flops = fparm(3)
        iptr        = iparm(11)
        iparm(11) = iptrrc
        call wmethr ( ijobr , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
        iptrrc      = iparm(11)
        iparm(11) = iptr
        fparm(13) = fparm(13) + (fparm(3)-flops)
*       *---check for termination----------
        if (ier .lt. 0) then
          ireq = -1
          go to 900
        endif
*
*       *---if init, then loop again----------
        if (ijobr .eq. 1) then
          ijobr  = 3
        endif
*
*       *---matvec----------
        if (ireq .eq. 3) then
        if (iparm(27) .eq. 2) then
          call zsatop ( suba , 18,
     &                   3 , ia , ja , a , fwk(ivqr) , fwk(iva) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call suba   ( 3 , ia , ja , a , fwk(ivqr) , fwk(iva) )
        endif
        endif
*
*       *---transpose matvec----------
        if (ireq .eq. 4) then
        if (iparm(27) .eq. 2) then
          call zsatop ( suba , 18,
     &                   4 , ia , ja , a , fwk(iva) , fwk(ivqr) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call suba   ( 4 , ia , ja , a , fwk(iva) , fwk(ivqr) )
        endif
        endif
*
*       *---left precon----------
        if (ireq .eq. 5) then
        if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) then
          call zwset (fwk(ivql),fwk(iva),
     &     iparm , fparm , iwk , fwk , ier  )
        else
        if (iparm(27) .eq. 2) then
          call zsatop ( subq , 19,
     &                   5 , ia , ja , a , fwk(iva) , fwk(ivql) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call subq   ( 5 , iq , jq , q , fwk(iva) , fwk(ivql) )
        endif
        endif
        endif
*
*       *---transpose left precon----------
        if (ireq .eq. 6) then
        if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) then
          call zwset (fwk(iva),fwk(ivql),
     &     iparm , fparm , iwk , fwk , ier  )
        else
        if (iparm(27) .eq. 2) then
          call zsatop ( subq , 19,
     &                   6 , ia , ja , a , fwk(ivql) , fwk(iva) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call subq   ( 6 , iq , jq , q , fwk(ivql) , fwk(iva) )
        endif
        endif
        endif
*
*       *---right precon----------
        if (ireq .eq. 7) then
        if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwset (fwk(ivqr),fwk(ivql),
     &     iparm , fparm , iwk , fwk , ier  )
        else
        if (iparm(27) .eq. 2) then
          call zsatop ( subq , 19,
     &                   7 , ia , ja , a , fwk(ivql) , fwk(ivqr) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call subq   ( 7 , iq , jq , q , fwk(ivql) , fwk(ivqr) )
        endif
        endif
        endif
*
*       *---transpose right precon----------
        if (ireq .eq. 8) then
        if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwset (fwk(ivql),fwk(ivqr),
     &     iparm , fparm , iwk , fwk , ier  )
        else
        if (iparm(27) .eq. 2) then
          call zsatop ( subq , 19,
     &                   8 , ia , ja , a , fwk(ivqr) , fwk(ivql) ,
     &       iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        else
          call subq   ( 8 , iq , jq , q , fwk(ivqr) , fwk(ivql) )
        endif
        endif
        endif
*
*       *---termination----------
        if (ireq .eq. -1) then
          ijobr = 1
          go to 900
        endif
*
*       *---end revcom loop----------
 1600   continue
      goto 10
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
*     *---terminate revcom routine if necessary----------
      if (ijobr .ne. 1) then
        flops = fparm(3)
        ijobr = -1
        iptr        = iparm(11)
        iparm(11) = iptrrc
        call wmethr ( ijobr , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
        iptrrc      = iparm(11)
        iparm(11) = iptr
        fparm(13) = fparm(13) + (fparm(3)-flops)
      endif
      iparm(15) = needrc
*
*     *---shut off and pack timer----------
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(11) = fparm(11) + (tc2-tc1)
        fparm(12) = fparm(12) + (tr2-tr1)
      endif
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 1) then
        call zifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---terminate----------
*     *---reset iclev----------
      if (iparm(27) .eq. 1) iparm(27) = 0
*
      return
      end
