************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WMCH - function to return machine constants. (^)
**
************************************************************************
**
      double precision function zmch ( ch ,  iparm , fparm , iwk , fwk ,
     & ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine returns the relevant machine constant as specified
**    by the argument ch.
**    This version relies on routines taken from Lapack.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:53:05 1994 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
*#    BASICAL             - (^)
      character ch
*
        integer ipme
        integer nproc
      integer i
      logical first
      save    first
      double precision values(10)
      save  values
      character*10 names
*
      double precision    dlamch
      external dlamch
*
      data first /.true./
      data names /'ESBPNRMULO'/
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: mch.fm4,v 1.2 1994/04/30 04:39:55 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      ipme  = 0
      nproc = 1
      if (first) then
       do 5500 i = 1, 10
       values(i) = dlamch(names(i:i))
 5500  continue
        first = .false.
      endif
      zmch = values(index(names,ch))
 900  continue
      return
      end
