************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WLSQER - Reverse communication level routine for the
**                     LSQE normal equations method.
**                     (^)
**
************************************************************************
**
      subroutine zlsqer ( ijob , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Preconditioned LSQE algorithm.  This algorithm gives the same
**    iterates as the CGNE normal equations algorithm (Craig's method)
**    but has improved numerical properties.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: Modified: wdj@lanl.gov Tue Sep 28 08:27:54 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    preconditioned LSQE
**
**  ^REFERENCES:
**    The algorithm is similar to the LSQR algorithm described in:
**
**#   Christopher C. Paige and Michael Saunders, ``LSQR: An Algorithm
**    for Sparse Linear Equations and Sparse Least Squares,''
**    ACM Transactions on Mathematical Software, vol. 8., no. 1,
**    March 1982, pp. 43--71.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer    iitab
      integer    iftab
      integer    iwkstg
      integer    iclstg
      integer    in
      integer    is
      integer    iretlb
      integer    ivitmp, ivotmp
      integer    iv1tst, iv2tst
      integer    istab1, istab2, istab
      integer    ib1,ib2, iu1,iu2
      integer    iud
      parameter (iud  =0)
      integer    ibd
      parameter (ibd  =1)
      integer    ilbd
      parameter (ilbd =2)
      integer    irlbd
      parameter (irlbd=3)
      integer    ied
      parameter (ied  =4)
      integer    ird
      parameter (ird  =5)
      integer    ilrd
      parameter (ilrd =6)
      integer    irlrd
      parameter (irlrd=7)
      double complex      urndf
      double complex      top
      double complex      bot
      parameter (urndf=.1)
      double complex      mydot1, mydot2
      external   zargck
      external   zckstg
      external   zwrnd
      external   zifppr
      external   zitput
      external   xtimer
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
*     integer imv1, imv2
      integer    ir
      integer    iqlr
      integer    iqrqlr
      integer    iuvec
      integer    iv, irv, iarv, ilarv
      integer        irw, iarw, ilarw
      integer    iv1, iv2, iv3
      double complex      rdot
      double complex      rnorm
      double complex      r0norm
      double complex      alpha
      double complex      beta
      double complex      theta, rho, phi, rhobar, phibar, c, s
      double complex      rhobol, rhobnu, rhoold, phibol, phibnu, phiold
      double complex      uudot, uexdt
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: lsqer.fm4,v 1.7 1994/11/22 05:20:34 joubert Exp $
*     $Revision: 1.0 $
*     $Log: lsqer.fm4,v $
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      iuvec = (iparm(6))
      iv = (iparm(6))
      irv = (iparm(6))
      iarv = (iparm(6))
      ilarv = (iparm(6))
      irw = (iparm(6))
      iarw = (iparm(6))
      ilarw = (iparm(6))
      iv1 = (iparm(6))
      iv2 = (iparm(6))
      iv3 = (iparm(6))
*
*     *---go to the brancher unless this is the init call---
      if (ijob .ne. 1) go to 1000
*
*     *---inits----------
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
*     *---initialize pointers----------
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
*     *---initialize----------
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call zfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call zargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
*     *---start timer------
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 0) then
        call zifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
*     *---reserve place to save integer and float variables----------
*     *---across revcom calls----------
      call ximal (iitab,33, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iftab,20, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/''     LSQE Method.''/)') 
      endif
*
      call zfmal (iuvec,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iv,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (irw,iparm(3)*((2)), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
        call zfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (iarw,iparm(3)*((2)), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
      endif
      if (((mod(iparm(15)/4,2).eq.1)   .or.
     &    iparm(12).eq.3    .or. iparm(12).eq.7) .or. ((mod(iparm(15)/8,
     &2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
        if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(ipar
     &m(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          iqlr = ir
        else
          call zfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call zfmal (ilarw,iparm(3)*((2)), iparm , fparm , iwk , fwk , 
     &ier )
           if (ier .lt. 0) go to 900
        endif
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call zfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
      else
        iqrqlr = iqlr
      endif
      call zfmal (iv1 ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iv2 ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iv3 ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      iarv = iv2
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        ilarv = iv3
      else
        ilarv = iv2
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        irv = iv1
      else
        irv = iv
      endif
*
*
*     *---set u to zero----------
      if (iparm(14) .eq. -2
     &    .or. iparm(14) .eq. -1) then
          call zwfil (u,(0d0,0.0d0),
     &     iparm , fparm , iwk , fwk , ier  )
      endif
*
*     *---random u----------
      if (iparm(14) .eq. 2
     &    ) go to 5500
                 go to 5501
 5500  continue
          call zwrdot (mydot1,b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
        call zwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2000
        go to 1500
 2000   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwrdot (mydot2,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwscl ( u, u, urndf*sqrt(mydot1/mydot2),  iparm , fparm ,
     & iwk , fwk , ier  )
                go to 5502
 5501 continue
 5502 continue
*
*     *---random u perturbation----------
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2001
        go to 1500
 2001   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (mydot1,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iv1),u,
     &     iparm , fparm , iwk , fwk , ier  )
        call zwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv2 
         ireq = 3
        iretlb = 2002
        go to 1500
 2002   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwrdot (mydot2,fwk(iv2),
     &    fwk(iv2),  iparm , fparm , iwk , fwk , ier  )
          call zwsax (u,fwk(iv1),
     &    u, -urndf*sqrt(mydot1/mydot2),  iparm , fparm , iwk , fwk , ie
     &r  )
                go to 5505
 5504 continue
 5505 continue
*
*     *---begin iteration statistics calculation----------
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
        call zfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call zwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call zwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call zwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5511
 5510 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2003
        go to 1500
 2003   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5511 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5514
 5513 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2004
        go to 1500
 2004   continue
         if (ijob .eq. -1) go to 900
 5514 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call zwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2005
        go to 1500
 2005   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call zwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5517
 5516 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2006
        go to 1500
 2006   continue
         if (ijob .eq. -1) go to 900
 5517 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5520
 5519 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2007
        go to 1500
 2007   continue
         if (ijob .eq. -1) go to 900
 5520 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Initial iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call zffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*     *---end iteration statistics calculation----------
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2)) .or. iparm(14).eq.-1) 
     &go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5527
                 go to 5528
 5527  continue
          call zwset (fwk(iuvec),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5529
 5528 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iuvec 
         ireq = 5
        iretlb = 2008
        go to 1500
 2008   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5529 continue
*        *---end revcom precon----------
                go to 5526
 5525 continue
          call zwset (fwk(iuvec),b,
     &     iparm , fparm , iwk , fwk , ier  )
 5526 continue
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5530
                 go to 5531
 5530  continue
          call zwset (fwk(ir),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5532
 5531 continue
 5532 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2009
        go to 1500
 2009   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          call zwset (fwk(iuvec),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5538
 5537 continue
          iva = iv1 
          ivql = iuvec 
         ireq = 5
        iretlb = 2010
        go to 1500
 2010   continue
         if (ijob .eq. -1) go to 900
 5538 continue
*        *---end revcom precon----------
                go to 5535
 5534 continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iuvec 
         ireq = 3
        iretlb = 2011
        go to 1500
 2011   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(iuvec),
     &    b, fwk(iuvec),  iparm , fparm , iwk , fwk , ier  )
 5535 continue
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5539
                 go to 5540
 5539  continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call zwset (fwk(ir),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5544
 5543 continue
          call zwset (fwk(ir),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
 5544 continue
                go to 5541
 5540 continue
 5541 continue
 5523 continue
      if (iqlr.ne.(iparm(6)) .and. iqlr.ne.ir) go to 5545
                 go to 5546
 5545  continue
          call zwset (fwk(iqlr),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5547
 5546 continue
 5547 continue
      if (iqrqlr.ne.(iparm(6)) .and. iqrqlr.ne.iqlr) go to 5548
                 go to 5549
 5548  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5551
                 go to 5552
 5551  continue
          call zwset (fwk(iqrqlr),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5553
 5552 continue
          ivql = iqlr 
          ivqr = iqrqlr 
         ireq = 7
        iretlb = 2012
        go to 1500
 2012   continue
         if (ijob .eq. -1) go to 900
 5553 continue
*        *---end revcom precon----------
                go to 5550
 5549 continue
 5550 continue
*
          call zwrdot (rdot,fwk(iuvec),
     &    fwk(iuvec),  iparm , fparm , iwk , fwk , ier  )
      rnorm  = sqrt(abs(rdot))
      r0norm = rnorm
      beta = r0norm
      if (beta .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Initial beta' )
                go to 900
      endif
          call zwscl ( fwk(iuvec), fwk(iuvec), (1d0,0.0d0)/beta,  iparm 
     &, fparm , iwk , fwk , ier  )
      phibnu = beta
*     rdot = phibnu**2
*
*---------------------------iteration loop------------------------------
*
 100  continue
*
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'rnorm               ', rnorm
        endif
*
*     *---begin user stopping test----------
        if (iparm(12).eq.-3) go to 5554
                 go to 5555
 5554  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir 
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr 
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr 
          endif
          ireq   = 9
        iretlb = 2013
        go to 1500
 2013   continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        write (iparm(1),'(/a/)') ' User-requested termination of iterati
     &ve method.'
            endif
            go to 900
          endif
                go to 5556
 5555 continue
 5556 continue
        if (iparm(12) .gt. 1) go to 5557
                 go to 5558
 5557  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
              endif
          call zwdot (bot, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            endif
            call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
          call zwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
            call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call zwdot (bot, b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
            endif
          call zwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
          endif
          if (iparm(12) .eq. 3) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call zwdot (bot, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5568
 5567 continue
                call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call zwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5571
 5570 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2014
        go to 1500
 2014   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5571 continue
*        *---end revcom precon----------
          call zwdot (bot, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
                call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
                go to 5565
 5564 continue
 5565 continue
          call zwdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 4) go to 5572
                 go to 5573
 5572  continue
            if (iparm(5) .eq. 0) go to 5575
                 go to 5576
 5575  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5578
                 go to 5579
 5578  continue
          call zwdot (bot, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5580
 5579 continue
                call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
                call zfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
          call zwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5583
 5582 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2015
        go to 1500
 2015   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5583 continue
*        *---end revcom precon----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call zwset (fwk(iv2tst),fwk(iv1tst),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5586
 5585 continue
          ivql = iv1tst 
          ivqr = iv2tst 
         ireq = 7
        iretlb = 2016
        go to 1500
 2016   continue
         if (ijob .eq. -1) go to 900
 5586 continue
*        *---end revcom precon----------
          call zwdot (bot, fwk(iv2tst),
     &    fwk(iv2tst),  iparm , fparm , iwk , fwk , ier  )
                call zffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
                call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5580 continue
                go to 5577
 5576 continue
 5577 continue
          call zwdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5574
 5573 continue
 5574 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call zwdot (top, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            else
              call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          call zwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
              call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk
     & , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call zwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call zwdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call zwdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (dble(top) .lt. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (dble(bot) .le. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(dble(top)/dble(bot))
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
                go to 5559
 5558 continue
 5559 continue
*     *---end user stopping test----------
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. (0d0,0.0d0)) then
                ier = -10
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
        endif
*
*       *---begin exact stopping test----------
        if (iparm(12) .eq. -2) then
          call zwsub ( fwk(iv1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (uudot,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (uexdt,uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
          if (dble(uudot)  .lt. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (dble(uexdt) .le. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(dble(uudot)/dble(uexdt))
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
        endif
*       *---end exact stopping test----------
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'zlsqer' , iparm , ' ' )
          go to 900
        endif
*
        call zckstg ( iclstg, iwkstg,  iparm , fparm , iwk , fwk , ier  
     &)
           if (ier .lt. 0) go to 900
*
*-----------------------proceed with iteration--------------------------
*
        if (in .eq. 0) go to 5587
                 go to 5588
 5587  continue
          if (.not.((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5590
                 go to 5591
 5590  continue
            if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
*        *---begin revcom matvec----------
          iva = iuvec 
          ivqr = iv 
         ireq = 4
        iretlb = 2017
        go to 1500
 2017   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
                go to 5595
 5594 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5596
                 go to 5597
 5596  continue
          call zwset (fwk(iv1),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5598
 5597 continue
          ivql = iuvec 
          iva = iv1 
         ireq = 6
        iretlb = 2018
        go to 1500
 2018   continue
         if (ijob .eq. -1) go to 900
 5598 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          iva = iv1 
          ivqr = iv 
         ireq = 4
        iretlb = 2019
        go to 1500
 2019   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5595 continue
                go to 5592
 5591 continue
            if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5599
                 go to 5600
 5599  continue
*        *---begin revcom matvec----------
          iva = iuvec 
          ivqr = iv1 
         ireq = 4
        iretlb = 2020
        go to 1500
 2020   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
          call zwset (fwk(iv),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5604
 5603 continue
          ivqr = iv1 
          ivql = iv 
         ireq = 8
        iretlb = 2021
        go to 1500
 2021   continue
         if (ijob .eq. -1) go to 900
 5604 continue
*        *---end revcom precon----------
                go to 5601
 5600 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5605
                 go to 5606
 5605  continue
          call zwset (fwk(iv1),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5607
 5606 continue
          ivql = iuvec 
          iva = iv1 
         ireq = 6
        iretlb = 2022
        go to 1500
 2022   continue
         if (ijob .eq. -1) go to 900
 5607 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          iva = iv1 
          ivqr = iv2 
         ireq = 4
        iretlb = 2023
        go to 1500
 2023   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
          call zwset (fwk(iv),fwk(iv2),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5610
 5609 continue
          ivqr = iv2 
          ivql = iv 
         ireq = 8
        iretlb = 2024
        go to 1500
 2024   continue
         if (ijob .eq. -1) go to 900
 5610 continue
*        *---end revcom precon----------
 5601 continue
 5592 continue
          call zwrdot (alpha,fwk(iv),
     &    fwk(iv),  iparm , fparm , iwk , fwk , ier  )
          alpha = sqrt(alpha)
          if (alpha .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Initial alpha' )
                go to 900
          endif
          call zwscl ( fwk(iv), fwk(iv), (1d0,0.0d0)/alpha,  iparm , fpa
     &rm , iwk , fwk , ier  )
          rhobnu = alpha
                go to 5589
 5588 continue
 5589 continue
*
        if (.not.((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5611
                 go to 5612
 5611  continue
          if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5614
                 go to 5615
 5614  continue
*        *---begin revcom matvec----------
          ivqr = iv 
          iva = iarv 
         ireq = 3
        iretlb = 2025
        go to 1500
 2025   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
                go to 5616
 5615 continue
*        *---begin revcom matvec----------
          ivqr = iv 
          iva = iarv 
         ireq = 3
        iretlb = 2026
        go to 1500
 2026   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5617
                 go to 5618
 5617  continue
          call zwset (fwk(ilarv),fwk(iarv),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5619
 5618 continue
          iva = iarv 
          ivql = ilarv 
         ireq = 5
        iretlb = 2027
        go to 1500
 2027   continue
         if (ijob .eq. -1) go to 900
 5619 continue
*        *---end revcom precon----------
 5616 continue
                go to 5613
 5612 continue
          if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5620
                 go to 5621
 5620  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5623
                 go to 5624
 5623  continue
          call zwset (fwk(irv),fwk(iv),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5625
 5624 continue
          ivql = iv 
          ivqr = irv 
         ireq = 7
        iretlb = 2028
        go to 1500
 2028   continue
         if (ijob .eq. -1) go to 900
 5625 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          ivqr = irv 
          iva = iarv 
         ireq = 3
        iretlb = 2029
        go to 1500
 2029   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
                go to 5622
 5621 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5626
                 go to 5627
 5626  continue
          call zwset (fwk(irv),fwk(iv),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5628
 5627 continue
          ivql = iv 
          ivqr = irv 
         ireq = 7
        iretlb = 2030
        go to 1500
 2030   continue
         if (ijob .eq. -1) go to 900
 5628 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          ivqr = irv 
          iva = iarv 
         ireq = 3
        iretlb = 2031
        go to 1500
 2031   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5629
                 go to 5630
 5629  continue
          call zwset (fwk(ilarv),fwk(iarv),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5631
 5630 continue
          iva = iarv 
          ivql = ilarv 
         ireq = 5
        iretlb = 2032
        go to 1500
 2032   continue
         if (ijob .eq. -1) go to 900
 5631 continue
*        *---end revcom precon----------
 5622 continue
 5613 continue
*
        if (in .eq. 0) then
          if (rhobnu .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'rhobar' )
                go to 900
          endif
          call zwscl ( fwk(irw+iparm(3)*(mod((in),(2)))), fwk(irv), (1d0
     &,0.0d0)/rhobnu,  iparm , fparm , iwk , fwk , ier  )
          if (ir.ne.(iparm(6))) then
          call zwscl ( fwk(iarw+iparm(3)*(mod((in),(2)))), fwk(iarv), (1
     &d0,0.0d0)/rhobnu,  iparm , fparm , iwk , fwk , ier  )
          endif
          if (iqlr.ne.(iparm(6)) .and. iqlr.ne.ir) then
          call zwscl ( fwk(ilarw+iparm(3)*(mod((in),(2)))), fwk(ilarv), 
     &(1d0,0.0d0)/rhobnu,  iparm , fparm , iwk , fwk , ier  )
          endif
        else
          if (rho .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'rho' )
                go to 900
          endif
          call zwsax (fwk(irw+iparm(3)*(mod((in),(2)))),fwk(irv),
     &    fwk(irw+iparm(3)*(mod((in-1),(2)))), -theta*rhobar/rho,  iparm
     & , fparm , iwk , fwk , ier  )
          call zwscl ( fwk(irw+iparm(3)*(mod((in),(2)))), fwk(irw+iparm(
     &3)*(mod((in),(2)))), (1d0,0.0d0)/rhobnu,  iparm , fparm , iwk , fw
     &k , ier  )
          if (ir.ne.(iparm(6))) then
          call zwsax (fwk(iarw+iparm(3)*(mod((in),(2)))),fwk(iarv),
     &    fwk(iarw+iparm(3)*(mod((in-1),(2)))), -theta*rhobar/rho,  ipar
     &m , fparm , iwk , fwk , ier  )
          call zwscl ( fwk(iarw+iparm(3)*(mod((in),(2)))), fwk(iarw+ipar
     &m(3)*(mod((in),(2)))), (1d0,0.0d0)/rhobnu,  iparm , fparm , iwk , 
     &fwk , ier  )
          endif
          if (iqlr.ne.(iparm(6)) .and. iqlr.ne.ir) then
          call zwsax (fwk(ilarw+iparm(3)*(mod((in),(2)))),fwk(ilarv),
     &    fwk(ilarw+iparm(3)*(mod((in-1),(2)))), -theta*rhobar/rho,  ipa
     &rm , fparm , iwk , fwk , ier  )
          call zwscl ( fwk(ilarw+iparm(3)*(mod((in),(2)))), fwk(ilarw+ip
     &arm(3)*(mod((in),(2)))), (1d0,0.0d0)/rhobnu,  iparm , fparm , iwk 
     &, fwk , ier  )
          endif
        endif
*
          call zwsax (fwk(iuvec),fwk(ilarv),
     &    fwk(iuvec), -alpha,  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (beta,fwk(iuvec),
     &    fwk(iuvec),  iparm , fparm , iwk , fwk , ier  )
        beta = sqrt(beta)
        if (beta .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'beta' )
                go to 900
        endif
          call zwscl ( fwk(iuvec), fwk(iuvec), (1d0,0.0d0)/beta,  iparm 
     &, fparm , iwk , fwk , ier  )
*
        if (.not.((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5632
                 go to 5633
 5632  continue
          if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5635
                 go to 5636
 5635  continue
*        *---begin revcom matvec----------
          iva = iuvec 
          ivqr = iv1 
         ireq = 4
        iretlb = 2033
        go to 1500
 2033   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
                go to 5637
 5636 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5638
                 go to 5639
 5638  continue
          call zwset (fwk(iv2),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5640
 5639 continue
          ivql = iuvec 
          iva = iv2 
         ireq = 6
        iretlb = 2034
        go to 1500
 2034   continue
         if (ijob .eq. -1) go to 900
 5640 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          iva = iv2 
          ivqr = iv1 
         ireq = 4
        iretlb = 2035
        go to 1500
 2035   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5637 continue
                go to 5634
 5633 continue
          if (.not.((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5641
                 go to 5642
 5641  continue
*        *---begin revcom matvec----------
          iva = iuvec 
          ivqr = iv2 
         ireq = 4
        iretlb = 2036
        go to 1500
 2036   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5644
                 go to 5645
 5644  continue
          call zwset (fwk(iv1),fwk(iv2),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5646
 5645 continue
          ivqr = iv2 
          ivql = iv1 
         ireq = 8
        iretlb = 2037
        go to 1500
 2037   continue
         if (ijob .eq. -1) go to 900
 5646 continue
*        *---end revcom precon----------
                go to 5643
 5642 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5647
                 go to 5648
 5647  continue
          call zwset (fwk(iv1),fwk(iuvec),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5649
 5648 continue
          ivql = iuvec 
          iva = iv1 
         ireq = 6
        iretlb = 2038
        go to 1500
 2038   continue
         if (ijob .eq. -1) go to 900
 5649 continue
*        *---end revcom precon----------
*        *---begin revcom matvec----------
          iva = iv1 
          ivqr = iv2 
         ireq = 4
        iretlb = 2039
        go to 1500
 2039   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5650
                 go to 5651
 5650  continue
          call zwset (fwk(iv1),fwk(iv2),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5652
 5651 continue
          ivqr = iv2 
          ivql = iv1 
         ireq = 8
        iretlb = 2040
        go to 1500
 2040   continue
         if (ijob .eq. -1) go to 900
 5652 continue
*        *---end revcom precon----------
 5643 continue
 5634 continue
          call zwsax (fwk(iv),fwk(iv1),
     &    fwk(iv), -beta,  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (alpha,fwk(iv),
     &    fwk(iv),  iparm , fparm , iwk , fwk , ier  )
        alpha = sqrt(alpha)
        if (alpha .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'alpha' )
                go to 900
        endif
          call zwscl ( fwk(iv), fwk(iv), (1d0,0.0d0)/alpha,  iparm , fpa
     &rm , iwk , fwk , ier  )
*
              rhoold = rho
        rho          = sqrt(rhobnu**2+beta**2)
        if (rho .eq. (0d0,0.0d0)) then
                ier = -6
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'rho' )
                go to 900
        endif
        c            =  rhobnu/rho
        s            =  beta  /rho
        theta        =  s*alpha
              rhobol =  rhobar
              rhobar =  rhobnu
        rhobnu       = -c*alpha
              phiold =  phi
        phi          =  c*phibnu
              phibol =  phibar
              phibar =  phibnu
        phibnu       =  s*phibnu
*
          call zwsax (u,u,
     &    fwk(irw+iparm(3)*(mod((in),(2)))), phibar,  iparm , fparm , iw
     &k , fwk , ier  )
        if (in .gt. 0) then
          if (rhoold .eq. (0d0,0.0d0)) then
                ier = -6
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'rho old' )
                go to 900
          endif
          call zwsax (u,u,
     &    fwk(irw+iparm(3)*(mod((in-1),(2)))), (phiold*rhobol/rhoold-phi
     &bol),  iparm , fparm , iwk , fwk , ier  )
        endif
        if (ir .ne. (iparm(6))) then
          call zwsax (fwk(ir),fwk(ir),
     &    fwk(iarw+iparm(3)*(mod((in),(2)))), -(phibar),  iparm , fparm 
     &, iwk , fwk , ier  )
          if (in .gt. 0) then
          call zwsax (fwk(ir),fwk(ir),
     &    fwk(iarw+iparm(3)*(mod((in-1),(2)))), -(phiold*rhobol/rhoold-p
     &hibol),  iparm , fparm , iwk , fwk , ier  )
          endif
        endif
        if (iqlr.ne.(iparm(6)) .and. iqlr.ne.ir) then
          call zwsax (fwk(iqlr),fwk(iqlr),
     &    fwk(ilarw+iparm(3)*(mod((in),(2)))), -(phibar),  iparm , fparm
     & , iwk , fwk , ier  )
          if (in .gt. 0) then
          call zwsax (fwk(iqlr),fwk(iqlr),
     &    fwk(ilarw+iparm(3)*(mod((in-1),(2)))), -(phiold*rhobol/rhoold-
     &phibol),  iparm , fparm , iwk , fwk , ier  )
          endif
        endif
        if (iqrqlr.ne.(iparm(6)) .and. iqrqlr.ne.iqlr) go to 5653
                 go to 5654
 5653  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5656
                 go to 5657
 5656  continue
          call zwset (fwk(iqrqlr),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5658
 5657 continue
          ivql = iqlr 
          ivqr = iqrqlr 
         ireq = 7
        iretlb = 2041
        go to 1500
 2041   continue
         if (ijob .eq. -1) go to 900
 5658 continue
*        *---end revcom precon----------
                go to 5655
 5654 continue
 5655 continue
*
        if (rhobar .eq. (0d0,0.0d0)) then
                ier = -6
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'rhobar' )
                go to 900
        endif
        rdot   = (phibar*beta/rhobar)**2
        rnorm  = sqrt(abs(rdot))
*
        in         = in + 1
        iparm(5) = in
        is         = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/a,i7,a/)') '     LSQE Method has converged in
     & ', iparm(5), ' iterations.'
      endif
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
      if (iclstg .ne. 1) then
        call zckstg (-1, iwkstg,  iparm , fparm , iwk , fwk , ier )
      endif
*
*     *---begin iteration statistics calculation----------
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5659
                 go to 5660
 5659  continue
        call zfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call zwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call zwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5662
                 go to 5663
 5662  continue
          call zwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5664
 5663 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2042
        go to 1500
 2042   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
 5664 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5665
                 go to 5666
 5665  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5667
 5666 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2043
        go to 1500
 2043   continue
         if (ijob .eq. -1) go to 900
 5667 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call zwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2044
        go to 1500
 2044   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5668
                 go to 5669
 5668  continue
          call zwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5670
 5669 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2045
        go to 1500
 2045   continue
         if (ijob .eq. -1) go to 900
 5670 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5671
                 go to 5672
 5671  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5673
 5672 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2046
        go to 1500
 2046   continue
         if (ijob .eq. -1) go to 900
 5673 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. (0d0,0.0d0)) then
                ier = 4
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Value of RELERR may be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. (0d0,0.0d0)) then
                ier = 4
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Value of RELRSD may be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Final iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10,2
     &x,1pg20.10)') fparm(8)
        endif
        write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10,2
     &x,1pg20.10)') fparm(7)
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call zffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (istab2,8, iparm , fparm , iwk , fwk , ier )
        call zffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5661
 5660 continue
 5661 continue
*     *---end iteration statistics calculation----------
*
      call zffre (iv3 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call zffre (iv2 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call zffre (iv1 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call zffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
        endif
      endif
      if (((mod(iparm(15)/4,2).eq.1)   .or.
     &    iparm(12).eq.3    .or. iparm(12).eq.7) .or. ((mod(iparm(15)/8,
     &2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
        if (.not.(.not.((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mo
     &d(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6))) then
          call zffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier
     & )
          call zffre (ilarw,iparm(3)*((2)), iparm , fparm , iwk , fwk , 
     &ier )
        endif
      endif
      if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
        call zffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (iarw,iparm(3)*((2)), iparm , fparm , iwk , fwk , ier
     & )
      endif
      call zffre (irw,iparm(3)*((2)), iparm , fparm , iwk , fwk , ier )
      call zffre (iv,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call zffre (iuvec,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call zffre (iftab,20, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,33, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
 910  continue
      if (iparm(27) .eq. 0) then
        call zifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---reset iclev----------
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq        = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme  = 0
      nproc = 1
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Values of ijob and iparm(iptr) incompatib
     &le' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
*     *---remember parameters out of tables----------
        iitab  = iwk(iitab+0)
        iftab  = iwk(iitab+1)
        istab  = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in     = iwk(iitab+5)
        is     = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ib1    = iwk(iitab+15)
        ib2    = iwk(iitab+16)
        iu1    = iwk(iitab+17)
        iu2    = iwk(iitab+18)
        ir     = iwk(iitab+19)
        iqlr   = iwk(iitab+20)
        iqrqlr = iwk(iitab+21)
        iuvec  = iwk(iitab+22)
        iv     = iwk(iitab+23)
        irv    = iwk(iitab+24)
        iarv   = iwk(iitab+25)
        ilarv  = iwk(iitab+26)
        irw    = iwk(iitab+27)
        iarw   = iwk(iitab+28)
        ilarw  = iwk(iitab+29)
        iv1    = iwk(iitab+30)
        iv2    = iwk(iitab+31)
        iv3    = iwk(iitab+32)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot   = fwk(iftab+2)
        rnorm  = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        alpha  = fwk(iftab+5)
        beta   = fwk(iftab+6)
        theta  = fwk(iftab+7)
        rho    = fwk(iftab+8)
        phi    = fwk(iftab+9)
        rhobar = fwk(iftab+10)
        phibar = fwk(iftab+11)
        c      = fwk(iftab+12)
        s      = fwk(iftab+13)
        rhobol = fwk(iftab+14)
        rhobnu = fwk(iftab+15)
        rhoold = fwk(iftab+16)
        phibol = fwk(iftab+17)
        phibnu = fwk(iftab+18)
        phiold = fwk(iftab+19)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'zlsqer' , iparm ,
     &                        'Argument ijob invalid' )
      endif
*
*     *---perform the branch to where we left off----------
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011
     &,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,
     &2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2
     &038,2039,2040,2041,2042,2043,2044,2045,2046),
     &       iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
*     *---save tables----------
        iwk(iitab+0) = iitab 
        iwk(iitab+1) = iftab 
        iwk(iitab+2) = istab 
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in    
        iwk(iitab+6) = is    
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ib1   
        iwk(iitab+16) = ib2   
        iwk(iitab+17) = iu1   
        iwk(iitab+18) = iu2   
        iwk(iitab+19) = ir    
        iwk(iitab+20) = iqlr  
        iwk(iitab+21) = iqrqlr
        iwk(iitab+22) = iuvec 
        iwk(iitab+23) = iv    
        iwk(iitab+24) = irv   
        iwk(iitab+25) = iarv  
        iwk(iitab+26) = ilarv 
        iwk(iitab+27) = irw   
        iwk(iitab+28) = iarw  
        iwk(iitab+29) = ilarw 
        iwk(iitab+30) = iv1   
        iwk(iitab+31) = iv2   
        iwk(iitab+32) = iv3   
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot  
        fwk(iftab+3) = rnorm 
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = alpha 
        fwk(iftab+6) = beta  
        fwk(iftab+7) = theta 
        fwk(iftab+8) = rho   
        fwk(iftab+9) = phi   
        fwk(iftab+10) = rhobar
        fwk(iftab+11) = phibar
        fwk(iftab+12) = c     
        fwk(iftab+13) = s     
        fwk(iftab+14) = rhobol
        fwk(iftab+15) = rhobnu
        fwk(iftab+16) = rhoold
        fwk(iftab+17) = phibol
        fwk(iftab+18) = phibnu
        fwk(iftab+19) = phiold
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10,2x,1pg20.10 )
*
      end
