************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WJAGR - Preconditioner linking routine,
**                     ja preconditioner, gr format.(^)
**
************************************************************************
**
      subroutine zjagr ( ijob , accel , ia , ja , a , u , uexact , b ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine links in the package routines necessary for the ja
**    preconditioner, gr format, and then passes things down to
**    the routine "prec".
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WPREC  - routine to actually call preconditioner generator
**                and itmeth
**       WCKJA  - routine to check correctness of the format
**       WSCJA  - scaling routine
**       WMVJA  - matvec routine
**       WJAJAX - preconditioner routine
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*#    PRECAL            - preconditioner routine arg list
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      external accel
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer ia(*)
      integer ja(*)
      double complex a(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
      external zprec
      external zckgr
      external zscgr
      external zmvgr
      external zjagrx
*
************************************************************************
*
      call zprec ( zckgr, zscgr,
     &             zscgr, zmvgr, zjagrx,  ijob , accel , ia , ja , a , u
     & , uexact , b ,
     &       iwk , fwk , iparm , fparm , ier  )
      return
      end
******^^****************************************************************
************************************************************************
