************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WFFRE - routine to free floating point memory. (^)
**
************************************************************************
**
      subroutine zffre ( iptr, nwords,  iparm , fparm , iwk , fwk , ier 
     & )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine is the general purpose floating point memory
**#   deallocator.  It calls either the Fortran or the C memory
**    deallocator.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    BASICAL - (^)
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer    iptr
      integer    nwords
*
      integer iertmp
      integer fused
      integer iequiv
      double complex   requiv
      equivalence (iequiv,requiv)
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: ffre.fm4,v 1.2 1995/04/03 22:54:24 joubert Exp $
************************************************************************
*
      if (iptr .eq. (iparm(6))) go to 900
      if (nwords .le. 0) go to 900
*
      iertmp = ier
      ier    = 0
**#        WNAME(mfree)
**#        call WMFREE (fwk,iptr,ier)
**#        FETCH(fused,IWFUSD)
**#        fused = fused - (nwords) - 2
**#        SAVE(IWFUSD,fused)
         requiv = fwk(1)
         fused = iequiv
           fused = fused - (nwords)
         iequiv = fused
         fwk(1) = requiv
           iptr = (iparm(6))
*
*
         if (ier .lt. 0) then
                ier = -14
                call xersho ( ier, 'zffre' , iparm , ' ' )
                go to 900
         else
           ier = iertmp
         endif
*
 900  continue
*
      iptr = (iparm(6))
*
      return
      end
