************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WCKGR  - to check the validity of the user-supplied
**                     regular grid format.
**                     (^)
**
************************************************************************
**
      subroutine zckgr ( u , uexact , b , ia , ja , a ,
     &       iq , jq , q , iparm , fparm ,
     &       suba , subq , iwk , fwk , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**     Routine to check the validity of the user-supplied regular 
**     grid format.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: See *Subroutine Arguments* below.
**      
**  ^REQUIREMENTS:
**   Common Blocks: none
**   Subroutines:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    ALLAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      external suba , subq
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      integer ia(*)
      integer ja(*)
      integer iq(*)
      integer jq(*)
      double complex a(*)
      double complex q(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
*
      integer  nv
      integer  ndim
      integer  nsten
      integer  nb
      integer  ns
      integer  imaxgr
      external imaxgr
      integer  ivaxgr
      external ivaxgr
      integer iaxis
      integer isten
      integer nsbgrd
      integer nsgax
*
        integer ipme
        integer nproc
*
*
******^^****************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: ckgr.fm4,v 1.14 1994/07/20 18:19:21 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      if (ia(1) .lt. 1 .or. ia(1) .gt. 32) then
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Invalid NDIM parameter in IA' )
                go to 900
      endif
      if (ia(2) .lt. 1) then
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Invalid NSTEN parameter in IA' )
                go to 900
      endif
      if (ia(3) .lt. 1) then
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Invalid NB parameter in IA' )
                go to 900
      endif
      if (ia(4) .lt. -1 .or. ia(4) .gt. 24-1) then
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Invalid MAXORD parameter in IA' )
                go to 900
      endif
      if (ia(5) .lt. -1 .or. ia(5) .gt.  2-1) then
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Invalid VAXORD parameter in IA' )
                go to 900
      endif
*
      ndim  = ia(1)
      nsten = ia(2)
      nb    = ia(3)
*
      nsbgrd = 1
      do 5500 iaxis = 1, ndim
        nsgax = ja(iaxis+ndim*nsten)
        if (nsgax .lt. 1) then           
                ier = -11
                call xersho ( ier, 'zckgr' , iparm ,
     &                        'Grid dimension less than 1' )
                go to 900
        endif
        nsbgrd = nsbgrd * nsgax
5500  continue
*
      iparm(3) = nb*nsbgrd
*
*
      if (iparm(2) .ge. 4) then
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),*) '     Regular Grid Matrix Format.'
        write (iparm(1),'()') 
        write (iparm(1),*) '     NDIM = ', ndim, '   NSTEN = ', nsten, '
     &   NB = ', nb
        write (iparm(1),'()') 
        write (iparm(1),*) '     Stencil Definition:'
        write (iparm(1),'()') 
        do 5501 isten = 1, nsten
        write (iparm(1),*) '     Stencil Point No. ', isten, ': Offsets:
     & ', (ja(iaxis+ndim*(isten-1)),iaxis=1,ndim)
5501  continue
        write (iparm(1),'()') 
        write (iparm(1),*) '     Global Grid Dimensions:           ', (j
     &a(iaxis+ndim*nsten),iaxis=1,ndim)
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
      endif
*
 900  continue
      return
      end
