************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WCGSLR - Reverse communication level routine for
**                     BICGSTAB(l) acceleration. (^)
**
************************************************************************
**
      subroutine zcgslr ( ijob , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    BICGSTAB(l) acceleration, which generalizes CGSTAB and BICGSTAB2
**    acceleration.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    Gerard L. G. Sleijpen and Diederick R. Fokkema, ``BICGSTAB(l)
**    for Linear Equations Involving Unsymmetric Matrices with Complex
**    Spectrum,'' {\sl Electronics Transactions on Numerical Analysis},
**    vol. 1, pp. 11-32, September 1993.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
      integer iwk(*)
      integer iparm(*)
      double complex       fwk(*)
      double complex       fparm(*)
      double complex u(*)
      double complex uexact(*)
      double complex b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer    iitab
      integer    iftab
      integer    iwkstg
      integer    iclstg
      integer    in
      integer    is
      integer    iretlb
      integer    ivitmp, ivotmp
      integer    iv1tst, iv2tst
      integer    istab1, istab2, istab
      integer    ib1,ib2, iu1,iu2
      integer    iud
      parameter (iud  =0)
      integer    ibd
      parameter (ibd  =1)
      integer    ilbd
      parameter (ilbd =2)
      integer    irlbd
      parameter (irlbd=3)
      integer    ied
      parameter (ied  =4)
      integer    ird
      parameter (ird  =5)
      integer    ilrd
      parameter (ilrd =6)
      integer    irlrd
      parameter (irlrd=7)
      double complex      urndf
      double complex      top
      double complex      bot
      parameter (urndf=.1)
      double complex      mydot1, mydot2
      external   zargck
      external   zckstg
      external   zwrnd
      external   zifppr
      external   zitput
      external   xtimer
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
*     integer imv1, imv2
      integer    irhmul
      integer    iuhmul
      integer    ns
      integer    i, j
      integer    ialpht
      integer    ibetat
      integer    isigma
      integer    igam
      integer    igamp
      integer    igampp
      integer    itau
      integer    ir
      integer    ilr
      integer    irlr
      integer    irt
      integer    irh
      integer    ilrh
      integer    irlrh
      integer    iuh
      integer    iluh
      integer    irluh
      integer    iv1
      integer    iv2
      double complex      rdot
      double complex      rnorm
      double complex      r0norm
      double complex      rho0
      double complex      rho1
      double complex      alpha
      double complex      beta
      double complex      omega
      double complex      gamma
      double complex      tmpdot
      double complex      uudot, uexdt
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: cgslr.fm4,v 1.14 1994/11/22 05:20:25 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir     = (iparm(6))
      ilr    = (iparm(6))
      irlr   = (iparm(6))
      irt    = (iparm(6))
      irh    = (iparm(6))
      ilrh   = (iparm(6))
      irlrh  = (iparm(6))
      iuh    = (iparm(6))
      iluh   = (iparm(6))
      irluh  = (iparm(6))
      iv1    = (iparm(6))
      iv2    = (iparm(6))
      ialpht = (iparm(6))
      ibetat = (iparm(6))
      isigma = (iparm(6))
      igam   = (iparm(6))
      igamp  = (iparm(6))
      igampp = (iparm(6))
      itau = (iparm(6))
*
*     *---go to the brancher unless this is the init call---
      if (ijob .ne. 1) go to 1000
*
*     *---inits----------
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
*     *---initialize pointers----------
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
*     *---initialize----------
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call zfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call zargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
*     *---start timer------
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 0) then
        call zifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
*     *---reserve place to save integer and float variables----------
*     *---across revcom calls----------
      call ximal (iitab,43, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iftab,12, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/''     BICGSTAB(l) Method.''/)') 
      endif
*
      ns = iparm(17)
*
      call zfmal (irt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iv1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (iv2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (ilrh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , ier 
     &)
           if (ier .lt. 0) go to 900
      call zfmal (iluh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , ier 
     &)
           if (ier .lt. 0) go to 900
      ilr = ilrh
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zfmal (irh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          call zfmal (iuh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          irhmul = 1
          iuhmul = 1
        else
          irh = iv1
          iuh = iv1
          irhmul = 0
          iuhmul = 0
        endif
      else
        irh = ilrh
        iuh = iluh
        irhmul = 1
        iuhmul = 1
      endif
      ir = irh
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        call zfmal (irlrh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
        call zfmal (irluh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
      else
        irlrh = ilrh
        irluh = iluh
      endif
      irlr = irlrh
      call zfmal (ialpht,ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (ibetat,ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (isigma,ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (igam,ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (igamp,ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (igampp,ns-1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmal (itau,ns*ns, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
*     *---set u to zero----------
      if (iparm(14) .eq. -2
     &    ) then
          call zwfil (u,(0d0,0.0d0),
     &     iparm , fparm , iwk , fwk , ier  )
      endif
*
*     *---random u----------
      if (iparm(14) .eq. 2
     &    .or. iparm(14) .eq. -1) go to 5500
                 go to 5501
 5500  continue
          call zwrdot (mydot1,b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
        call zwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2000
        go to 1500
 2000   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwrdot (mydot2,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwscl ( u, u, urndf*sqrt(mydot1/mydot2),  iparm , fparm ,
     & iwk , fwk , ier  )
                go to 5502
 5501 continue
 5502 continue
*
*     *---random u perturbation----------
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2001
        go to 1500
 2001   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (mydot1,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iv1),u,
     &     iparm , fparm , iwk , fwk , ier  )
        call zwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv2 
         ireq = 3
        iretlb = 2002
        go to 1500
 2002   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwrdot (mydot2,fwk(iv2),
     &    fwk(iv2),  iparm , fparm , iwk , fwk , ier  )
          call zwsax (u,fwk(iv1),
     &    u, -urndf*sqrt(mydot1/mydot2),  iparm , fparm , iwk , fwk , ie
     &r  )
                go to 5505
 5504 continue
 5505 continue
*
*     *---begin iteration statistics calculation----------
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
        call zfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call zwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call zwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call zwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5511
 5510 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2003
        go to 1500
 2003   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5511 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5514
 5513 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2004
        go to 1500
 2004   continue
         if (ijob .eq. -1) go to 900
 5514 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call zwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2005
        go to 1500
 2005   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call zwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5517
 5516 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2006
        go to 1500
 2006   continue
         if (ijob .eq. -1) go to 900
 5517 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5520
 5519 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2007
        go to 1500
 2007   continue
         if (ijob .eq. -1) go to 900
 5520 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Initial iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call zffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call zffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*     *---end iteration statistics calculation----------
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5527
                 go to 5528
 5527  continue
          call zwset (fwk(ir),b,
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          call zwset (fwk(ilr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5532
 5531 continue
          iva = ir 
          ivql = ilr 
         ireq = 5
        iretlb = 2008
        go to 1500
 2008   continue
         if (ijob .eq. -1) go to 900
 5532 continue
*        *---end revcom precon----------
                go to 5529
 5528 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call zwset (fwk(ilr),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5535
 5534 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ilr 
         ireq = 5
        iretlb = 2009
        go to 1500
 2009   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5535 continue
*        *---end revcom precon----------
 5529 continue
                go to 5526
 5525 continue
          call zwset (fwk(ilr),b,
     &     iparm , fparm , iwk , fwk , ier  )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5539
                 go to 5540
 5539  continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ir 
         ireq = 3
        iretlb = 2010
        go to 1500
 2010   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ir),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call zwset (fwk(ilr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5544
 5543 continue
          iva = ir 
          ivql = ilr 
         ireq = 5
        iretlb = 2011
        go to 1500
 2011   continue
         if (ijob .eq. -1) go to 900
 5544 continue
*        *---end revcom precon----------
                go to 5541
 5540 continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2012
        go to 1500
 2012   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5545
                 go to 5546
 5545  continue
          call zwset (fwk(ilr),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5547
 5546 continue
          iva = iv1 
          ivql = ilr 
         ireq = 5
        iretlb = 2013
        go to 1500
 2013   continue
         if (ijob .eq. -1) go to 900
 5547 continue
*        *---end revcom precon----------
 5541 continue
                go to 5538
 5537 continue
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ilr 
         ireq = 3
        iretlb = 2014
        go to 1500
 2014   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ilr),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
 5538 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5548
                 go to 5549
 5548  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5551
                 go to 5552
 5551  continue
          call zwset (fwk(irlr),fwk(ilr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5553
 5552 continue
          ivql = ilr 
          ivqr = irlr 
         ireq = 7
        iretlb = 2015
        go to 1500
 2015   continue
         if (ijob .eq. -1) go to 900
 5553 continue
*        *---end revcom precon----------
                go to 5550
 5549 continue
 5550 continue
*
          call zwrdot (rdot,fwk(ilr),
     &    fwk(ilr),  iparm , fparm , iwk , fwk , ier  )
      rnorm  = sqrt(abs(rdot))
      r0norm = rnorm
*
          call zwset (fwk(irt),fwk(ilr),
     &     iparm , fparm , iwk , fwk , ier  )
      rho0  = (1d0,0.0d0)
      alpha = (0d0,0.0d0)
      omega = (1d0,0.0d0)
      if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)/2
     &,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwfil (fwk(iuh+iparm(3)*(0)),(0d0,0.0d0),
     &     iparm , fparm , iwk , fwk , ier  )
      endif
          call zwfil (fwk(iluh+iparm(3)*(0)),(0d0,0.0d0),
     &     iparm , fparm , iwk , fwk , ier  )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwfil (fwk(irluh+iparm(3)*(0)),(0d0,0.0d0),
     &     iparm , fparm , iwk , fwk , ier  )
      endif
*
*---------------------------iteration loop------------------------------
*
 100  continue
*
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'QL r norm           ', rnorm
        endif
*
*     *---begin user stopping test----------
        if (iparm(12).eq.-3) go to 5554
                 go to 5555
 5554  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir 
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = ilr 
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = irlr 
          endif
          ireq   = 9
        iretlb = 2016
        go to 1500
 2016   continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        write (iparm(1),'(/a/)') ' User-requested termination of iterati
     &ve method.'
            endif
            go to 900
          endif
                go to 5556
 5555 continue
 5556 continue
        if (iparm(12) .gt. 1) go to 5557
                 go to 5558
 5557  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
              endif
          call zwdot (bot, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            endif
            call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
          call zwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
            call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call zwdot (bot, b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
            endif
          call zwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
          endif
          if (iparm(12) .eq. 3) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call zwdot (bot, fwk(ilr),
     &    fwk(ilr),  iparm , fparm , iwk , fwk , ier  )
                go to 5568
 5567 continue
                call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call zwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5571
 5570 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2017
        go to 1500
 2017   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5571 continue
*        *---end revcom precon----------
          call zwdot (bot, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
                call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
                go to 5565
 5564 continue
 5565 continue
          call zwdot (top, fwk(ilr),
     &    fwk(ilr),  iparm , fparm , iwk , fwk , ier  )
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 4) go to 5572
                 go to 5573
 5572  continue
            if (iparm(5) .eq. 0) go to 5575
                 go to 5576
 5575  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5578
                 go to 5579
 5578  continue
          call zwdot (bot, fwk(irlr),
     &    fwk(irlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5580
 5579 continue
                call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
                call zfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
          call zwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5583
 5582 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2018
        go to 1500
 2018   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5583 continue
*        *---end revcom precon----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call zwset (fwk(iv2tst),fwk(iv1tst),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5586
 5585 continue
          ivql = iv1tst 
          ivqr = iv2tst 
         ireq = 7
        iretlb = 2019
        go to 1500
 2019   continue
         if (ijob .eq. -1) go to 900
 5586 continue
*        *---end revcom precon----------
          call zwdot (bot, fwk(iv2tst),
     &    fwk(iv2tst),  iparm , fparm , iwk , fwk , ier  )
                call zffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
                call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5580 continue
                go to 5577
 5576 continue
 5577 continue
          call zwdot (top, fwk(irlr),
     &    fwk(irlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5574
 5573 continue
 5574 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call zwdot (top, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            else
              call zfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          call zwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
              call zffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk
     & , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call zwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call zwdot (top, fwk(ilr),
     &    fwk(ilr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call zwdot (top, fwk(irlr),
     &    fwk(irlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (dble(top) .lt. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (dble(bot) .le. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(dble(top)/dble(bot))
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
                go to 5559
 5558 continue
 5559 continue
*     *---end user stopping test----------
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. (0d0,0.0d0)) then
                ier = -10
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
        endif
*
*       *---begin exact stopping test----------
        if (iparm(12) .eq. -2) then
          call zwsub ( fwk(iv1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (uudot,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call zwrdot (uexdt,uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
          if (dble(uudot)  .lt. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (dble(uexdt) .le. dble((0d0,0.0d0))) then
                ier = -10
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(dble(uudot)/dble(uexdt))
          call zitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (dble(fparm(5)) .le. dble(fparm(4))) go to 2500
        endif
*       *---end exact stopping test----------
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'zcgslr' , iparm , ' ' )
          go to 900
        endif
*
        if (iparm(18) .ne. -1) then
          call zckstg ( iclstg, iwkstg,  iparm , fparm , iwk , fwk , ier
     &  )
           if (ier .lt. 0) go to 900
        endif
*
*-----------------------proceed with iteration--------------------------
*
        if (mod(in,2*ns) .lt. ns) go to 5587
                 go to 5588
 5587  continue
          j = mod(in,2*ns)
          if (j .eq. 0) rho0 = -omega * rho0
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'rho0                ', rho0
          endif
          call zwcdot (rho1, fwk(irt),
     &    fwk(ilrh+iparm(3)*(j)), iparm(20),  iparm , fparm , iwk , fwk 
     &, ier  )
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'rho1                ', rho1
          endif
          if (rho0 .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zcgslr' , iparm , ' ' )
                go to 900
          endif
          beta = alpha*rho1/rho0
          fwk(ibetat+(j)) = beta
          if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'beta('
     &,j,')              ', beta
          endif
          rho0 = rho1
          do 5590 i = 0, j
            if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm
     &(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwsax (fwk(iuh+iparm(3)*(i)),fwk(irh+iparm(3)*(i)),
     &    fwk(iuh+iparm(3)*(i)), -beta,  iparm , fparm , iwk , fwk , ier
     &  )
            endif
          call zwsax (fwk(iluh+iparm(3)*(i)),fwk(ilrh+iparm(3)*(i)),
     &    fwk(iluh+iparm(3)*(i)), -beta,  iparm , fparm , iwk , fwk , ie
     &r  )
            if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwsax (fwk(irluh+iparm(3)*(i)),fwk(irlrh+iparm(3)*(i)),
     &    fwk(irluh+iparm(3)*(i)), -beta,  iparm , fparm , iwk , fwk , i
     &er  )
            endif
5590  continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5591
                 go to 5592
 5591  continue
*        *---begin revcom matvec----------
          ivqr = irluh + iparm(3)*(j)
          iva = iuh + iparm(3)*((iuhmul*(j+1)))
         ireq = 3
        iretlb = 2020
        go to 1500
 2020   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5594
                 go to 5595
 5594  continue
          call zwset (fwk(iluh+iparm(3)*(j+1 )),fwk(iuh+iparm(3)*((iuhmu
     &l*(j+1)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5596
 5595 continue
          iva = iuh + iparm(3)*((iuhmul*(j+1)))
          ivql = iluh + iparm(3)*(j+1 )
         ireq = 5
        iretlb = 2021
        go to 1500
 2021   continue
         if (ijob .eq. -1) go to 900
 5596 continue
*        *---end revcom precon----------
                go to 5593
 5592 continue
*        *---begin revcom matvec----------
          ivqr = irluh + iparm(3)*(j)
          iva = iluh + iparm(3)*(j+1 )
         ireq = 3
        iretlb = 2022
        go to 1500
 2022   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5593 continue
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5597
                 go to 5598
 5597  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5600
                 go to 5601
 5600  continue
          call zwset (fwk(irluh+iparm(3)*(j+1 )),fwk(iluh+iparm(3)*(j+1)
     &),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5602
 5601 continue
          ivql = iluh + iparm(3)*(j+1)
          ivqr = irluh + iparm(3)*(j+1 )
         ireq = 7
        iretlb = 2023
        go to 1500
 2023   continue
         if (ijob .eq. -1) go to 900
 5602 continue
*        *---end revcom precon----------
                go to 5599
 5598 continue
 5599 continue
          call zwcdot (gamma, fwk(irt),
     &    fwk(iluh+iparm(3)*(j+1)), iparm(20),  iparm , fparm , iwk , fw
     &k , ier  )
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'gamma               ', gamma
          endif
          if (gamma .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zcgslr' , iparm , ' ' )
                go to 900
          endif
          alpha = rho0/gamma
          fwk(ialpht+(j)) = alpha
          if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'alpha(
     &',j,')             ', alpha
          endif
          do 5603 i = 0, j
            if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm
     &(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwsax (fwk(irh+iparm(3)*(i)),fwk(irh+iparm(3)*(i)),
     &    fwk(iuh+iparm(3)*(i+1)), -alpha,  iparm , fparm , iwk , fwk , 
     &ier  )
            endif
          call zwsax (fwk(ilrh+iparm(3)*(i)),fwk(ilrh+iparm(3)*(i)),
     &    fwk(iluh+iparm(3)*(i+1)), -alpha,  iparm , fparm , iwk , fwk ,
     & ier  )
            if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwsax (fwk(irlrh+iparm(3)*(i)),fwk(irlrh+iparm(3)*(i)),
     &    fwk(irluh+iparm(3)*(i+1)), -alpha,  iparm , fparm , iwk , fwk 
     &, ier  )
            endif
5603  continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5604
                 go to 5605
 5604  continue
*        *---begin revcom matvec----------
          ivqr = irlrh + iparm(3)*(j)
          iva = irh + iparm(3)*((irhmul*(j+1)))
         ireq = 3
        iretlb = 2024
        go to 1500
 2024   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5607
                 go to 5608
 5607  continue
          call zwset (fwk(ilrh+iparm(3)*(j+1 )),fwk(irh+iparm(3)*((irhmu
     &l*(j+1)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5609
 5608 continue
          iva = irh + iparm(3)*((irhmul*(j+1)))
          ivql = ilrh + iparm(3)*(j+1 )
         ireq = 5
        iretlb = 2025
        go to 1500
 2025   continue
         if (ijob .eq. -1) go to 900
 5609 continue
*        *---end revcom precon----------
                go to 5606
 5605 continue
*        *---begin revcom matvec----------
          ivqr = irlrh + iparm(3)*(j)
          iva = ilrh + iparm(3)*(j+1 )
         ireq = 3
        iretlb = 2026
        go to 1500
 2026   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5606 continue
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5610
                 go to 5611
 5610  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5613
                 go to 5614
 5613  continue
          call zwset (fwk(irlrh+iparm(3)*(j+1 )),fwk(ilrh+iparm(3)*(j+1)
     &),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5615
 5614 continue
          ivql = ilrh + iparm(3)*(j+1)
          ivqr = irlrh + iparm(3)*(j+1 )
         ireq = 7
        iretlb = 2027
        go to 1500
 2027   continue
         if (ijob .eq. -1) go to 900
 5615 continue
*        *---end revcom precon----------
                go to 5612
 5611 continue
 5612 continue
          call zwsax (u,u,
     &    fwk(irluh+iparm(3)*(0)), alpha,  iparm , fparm , iwk , fwk , i
     &er  )
                go to 5589
 5588 continue
        if (mod(in,2*ns) .eq. 2*ns-1) go to 5616
                 go to 5617
 5616  continue
          do 5619 j = 1, ns
            do 5620 i = 1, j-1
          call zwdot (tmpdot, fwk(ilrh+iparm(3)*(i)),
     &    fwk(ilrh+iparm(3)*(j)),  iparm , fparm , iwk , fwk , ier  )
              if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') '(rh(',
     &i,'),rh(',j,'))    ', tmpdot
              endif
              if (fwk(isigma+(i)-1) .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zcgslr' , iparm , ' ' )
                go to 900
              endif
              fwk(itau  +(i)-1 + ns*((j)-1)) = tmpdot/fwk(isigma+(i)-1)
              if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') 'tau(',
     &i,',',j,')         ', fwk(itau  +(i)-1 + ns*((j)-1))
              endif
              if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'alpha(j)            ', alpha
              endif
              if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(ipa
     &rm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwsax (fwk(irh+iparm(3)*(j)),fwk(irh+iparm(3)*(j)),
     &    fwk(irh+iparm(3)*(i)), -fwk(itau  +(i)-1 + ns*((j)-1)),  iparm
     & , fparm , iwk , fwk , ier  )
              endif
          call zwsax (fwk(ilrh+iparm(3)*(j)),fwk(ilrh+iparm(3)*(j)),
     &    fwk(ilrh+iparm(3)*(i)), -fwk(itau  +(i)-1 + ns*((j)-1)),  ipar
     &m , fparm , iwk , fwk , ier  )
              if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwsax (fwk(irlrh+iparm(3)*(j)),fwk(irlrh+iparm(3)*(j)),
     &    fwk(irlrh+iparm(3)*(i)), -fwk(itau  +(i)-1 + ns*((j)-1)),  ipa
     &rm , fparm , iwk , fwk , ier  )
              endif
5620  continue
          call zwdot (fwk(isigma+(j)-1), fwk(ilrh+iparm(3)*(j)),
     &    fwk(ilrh+iparm(3)*(j)),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'sigma(
     &',j,')             ', fwk(isigma+(j)-1)
            endif
            if (fwk(isigma+(j)-1) .eq. (0d0,0.0d0)) then
                ier = -7
                call xersho ( ier, 'zcgslr' , iparm , ' ' )
                go to 900
            endif
          call zwdot (tmpdot, fwk(ilrh+iparm(3)*(j)),
     &    fwk(ilrh+iparm(3)*(0)),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') '(rh(',
     &i,'),rh(',0,'))    ', tmpdot
            endif
            fwk(igamp +(j)-1) = tmpdot/fwk(isigma+(j)-1)
            if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'gamma'
     &'(',j,')           ', fwk(igamp +(j)-1)
            endif
5619  continue
          fwk(igam  +(ns)-1) = fwk(igamp +(ns)-1)
          omega  = fwk(igam  +(ns)-1)
          do 5621 j = ns-1, 1, -1
            fwk(igam  +(j)-1) = fwk(igamp +(j)-1)
            do 5622 i = j+1, ns
              fwk(igam  +(j)-1) = fwk(igam  +(j)-1) - fwk(itau  +(j)-1 +
     & ns*((i)-1))*fwk(igam  +(i)-1)
5622  continue
            if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'gamma(
     &',j,')            ', fwk(igam  +(j)-1)
            endif
5621  continue
          do 5623 j = 1, ns-1
            fwk(igampp+(j)-1) = fwk(igam  +(j+1)-1)
            do 5624 i = j+1, ns-1
              fwk(igampp+(j)-1) = fwk(igampp+(j)-1) + fwk(itau  +(j)-1 +
     & ns*((i)-1))*fwk(igam  +(i+1)-1)
5624  continue
            if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,     1pg20.10,2x,1pg20.10)') 'gamma'
     &'''(',j,')          ', fwk(igam  +(j)-1)
            endif
5623  continue
          call zwsax (u,u,
     &    fwk(irlrh+iparm(3)*(0)), fwk(igam  +(1)-1),  iparm , fparm , i
     &wk , fwk , ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(1
     &5)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwsax (fwk(irh+iparm(3)*(0)),fwk(irh+iparm(3)*(0)),
     &    fwk(irh+iparm(3)*(ns)), -fwk(igamp +(ns)-1),  iparm , fparm , 
     &iwk , fwk , ier  )
          call zwsax (fwk(iuh+iparm(3)*(0)),fwk(iuh+iparm(3)*(0)),
     &    fwk(iuh+iparm(3)*(ns)), -fwk(igam  +(ns)-1),  iparm , fparm , 
     &iwk , fwk , ier  )
          endif
          call zwsax (fwk(ilrh+iparm(3)*(0)),fwk(ilrh+iparm(3)*(0)),
     &    fwk(ilrh+iparm(3)*(ns)), -fwk(igamp +(ns)-1),  iparm , fparm ,
     & iwk , fwk , ier  )
          call zwsax (fwk(iluh+iparm(3)*(0)),fwk(iluh+iparm(3)*(0)),
     &    fwk(iluh+iparm(3)*(ns)), -fwk(igam  +(ns)-1),  iparm , fparm ,
     & iwk , fwk , ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwsax (fwk(irlrh+iparm(3)*(0)),fwk(irlrh+iparm(3)*(0)),
     &    fwk(irlrh+iparm(3)*(ns)), -fwk(igamp +(ns)-1),  iparm , fparm 
     &, iwk , fwk , ier  )
          call zwsax (fwk(irluh+iparm(3)*(0)),fwk(irluh+iparm(3)*(0)),
     &    fwk(irluh+iparm(3)*(ns)), -fwk(igam  +(ns)-1),  iparm , fparm 
     &, iwk , fwk , ier  )
          endif
          do 5625 j = 1, ns-1
          call zwsax (u,u,
     &    fwk(irlrh+iparm(3)*(j)), fwk(igampp+(j)-1),  iparm , fparm , i
     &wk , fwk , ier  )
            if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm
     &(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zwsax (fwk(iuh+iparm(3)*(0)),fwk(iuh+iparm(3)*(0)),
     &    fwk(iuh+iparm(3)*(j)), -fwk(igam  +(j)-1),  iparm , fparm , iw
     &k , fwk , ier  )
          call zwsax (fwk(irh+iparm(3)*(0)),fwk(irh+iparm(3)*(0)),
     &    fwk(irh+iparm(3)*(j)), -fwk(igamp +(j)-1),  iparm , fparm , iw
     &k , fwk , ier  )
            endif
          call zwsax (fwk(iluh+iparm(3)*(0)),fwk(iluh+iparm(3)*(0)),
     &    fwk(iluh+iparm(3)*(j)), -fwk(igam  +(j)-1),  iparm , fparm , i
     &wk , fwk , ier  )
          call zwsax (fwk(ilrh+iparm(3)*(0)),fwk(ilrh+iparm(3)*(0)),
     &    fwk(ilrh+iparm(3)*(j)), -fwk(igamp +(j)-1),  iparm , fparm , i
     &wk , fwk , ier  )
            if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call zwsax (fwk(irluh+iparm(3)*(0)),fwk(irluh+iparm(3)*(0)),
     &    fwk(irluh+iparm(3)*(j)), -fwk(igam  +(j)-1),  iparm , fparm , 
     &iwk , fwk , ier  )
          call zwsax (fwk(irlrh+iparm(3)*(0)),fwk(irlrh+iparm(3)*(0)),
     &    fwk(irlrh+iparm(3)*(j)), -fwk(igamp +(j)-1),  iparm , fparm , 
     &iwk , fwk , ier  )
            endif
5625  continue
                go to 5618
 5617 continue
 5618 continue
 5589 continue
*
          call zwrdot (rdot,fwk(ilr),
     &    fwk(ilr),  iparm , fparm , iwk , fwk , ier  )
        rnorm = sqrt(rdot)
*
        in         = in + 1
        iparm(5) = in
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/a,i7,a/)') '     BICGSTAB(l) Method has conve
     &rged in ', iparm(5), ' iterations.'
      endif
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
      if (iclstg .ne. 1) then
        call zckstg (-1, iwkstg,  iparm , fparm , iwk , fwk , ier )
      endif
*
*     *---begin iteration statistics calculation----------
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5626
                 go to 5627
 5626  continue
        call zfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call zfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call zwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call zwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5629
                 go to 5630
 5629  continue
          call zwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5631
 5630 continue
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call zwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2028
        go to 1500
 2028   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
 5631 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5632
                 go to 5633
 5632  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5634
 5633 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2029
        go to 1500
 2029   continue
         if (ijob .eq. -1) go to 900
 5634 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call zwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call zfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call zwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2030
        go to 1500
 2030   continue
          call zffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call zwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call zwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5635
                 go to 5636
 5635  continue
          call zwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5637
 5636 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2031
        go to 1500
 2031   continue
         if (ijob .eq. -1) go to 900
 5637 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call zwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5638
                 go to 5639
 5638  continue
          call zwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5640
 5639 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2032
        go to 1500
 2032   continue
         if (ijob .eq. -1) go to 900
 5640 continue
*        *---end revcom precon----------
          call zwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. (0d0,0.0d0)) then
                ier = 4
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Value of RELERR may be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. (0d0,0.0d0)) then
                ier = 4
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Value of RELRSD may be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Final iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10,2
     &x,1pg20.10)') fparm(8)
        endif
        write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10,2
     &x,1pg20.10)') fparm(7)
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call zffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call zffre (istab2,8, iparm , fparm , iwk , fwk , ier )
        call zffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5628
 5627 continue
 5628 continue
*     *---end iteration statistics calculation----------
*
      call zffre (itau,ns*ns, iparm , fparm , iwk , fwk , ier )
      call zffre (igampp,ns-1, iparm , fparm , iwk , fwk , ier )
      call zffre (igamp,ns, iparm , fparm , iwk , fwk , ier )
      call zffre (igam,ns, iparm , fparm , iwk , fwk , ier )
      call zffre (isigma,ns, iparm , fparm , iwk , fwk , ier )
      call zffre (ibetat,ns, iparm , fparm , iwk , fwk , ier )
      call zffre (ialpht,ns, iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        call zffre (irluh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
        call zffre (irlrh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
      endif
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call zffre (iuh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
          call zffre (irh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , i
     &er )
        endif
      endif
      call zffre (iluh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , ier 
     &)
      call zffre (ilrh,iparm(3)*(ns+1), iparm , fparm , iwk , fwk , ier 
     &)
      call zffre (iv2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call zffre (iv1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call zffre (irt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call zffre (iftab,12, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,43, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
 910  continue
      if (iparm(27) .eq. 0) then
        call zifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---reset iclev----------
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq        = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme  = 0
      nproc = 1
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Values of ijob and iparm(iptr) incompatib
     &le' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
*     *---remember parameters out of tables----------
        iitab  = iwk(iitab+0)
        iftab  = iwk(iitab+1)
        istab  = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in     = iwk(iitab+5)
        is     = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ib1    = iwk(iitab+15)
        ib2    = iwk(iitab+16)
        iu1    = iwk(iitab+17)
        iu2    = iwk(iitab+18)
        ir     = iwk(iitab+19)
        ilr    = iwk(iitab+20)
        irlr   = iwk(iitab+21)
        irt    = iwk(iitab+22)
        irh    = iwk(iitab+23)
        ilrh   = iwk(iitab+24)
        irlrh  = iwk(iitab+25)
        iuh    = iwk(iitab+26)
        iluh   = iwk(iitab+27)
        irluh  = iwk(iitab+28)
        iv1    = iwk(iitab+29)
        iv2    = iwk(iitab+30)
        ialpht = iwk(iitab+31)
        ibetat = iwk(iitab+32)
        isigma = iwk(iitab+33)
        igam   = iwk(iitab+34)
        igamp  = iwk(iitab+35)
        igampp = iwk(iitab+36)
        itau   = iwk(iitab+37)
        irhmul = iwk(iitab+38)
        iuhmul = iwk(iitab+39)
        ns     = iwk(iitab+40)
        i      = iwk(iitab+41)
        j      = iwk(iitab+42)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot   = fwk(iftab+2)
        rnorm  = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        rho0   = fwk(iftab+5)
        rho1   = fwk(iftab+6)
        alpha  = fwk(iftab+7)
        beta   = fwk(iftab+8)
        omega  = fwk(iftab+9)
        gamma  = fwk(iftab+10)
        tmpdot = fwk(iftab+11)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'zcgslr' , iparm ,
     &                        'Argument ijob invalid' )
      endif
*
*     *---perform the branch to where we left off----------
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011
     &,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,
     &2025,2026,2027,2028,2029,2030,2031,2032),
     &       iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
*     *---save tables----------
        iwk(iitab+0) = iitab 
        iwk(iitab+1) = iftab 
        iwk(iitab+2) = istab 
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in    
        iwk(iitab+6) = is    
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ib1   
        iwk(iitab+16) = ib2   
        iwk(iitab+17) = iu1   
        iwk(iitab+18) = iu2   
        iwk(iitab+19) = ir    
        iwk(iitab+20) = ilr   
        iwk(iitab+21) = irlr  
        iwk(iitab+22) = irt   
        iwk(iitab+23) = irh   
        iwk(iitab+24) = ilrh  
        iwk(iitab+25) = irlrh 
        iwk(iitab+26) = iuh   
        iwk(iitab+27) = iluh  
        iwk(iitab+28) = irluh 
        iwk(iitab+29) = iv1   
        iwk(iitab+30) = iv2   
        iwk(iitab+31) = ialpht
        iwk(iitab+32) = ibetat
        iwk(iitab+33) = isigma
        iwk(iitab+34) = igam  
        iwk(iitab+35) = igamp 
        iwk(iitab+36) = igampp
        iwk(iitab+37) = itau  
        iwk(iitab+38) = irhmul
        iwk(iitab+39) = iuhmul
        iwk(iitab+40) = ns    
        iwk(iitab+41) = i     
        iwk(iitab+42) = j     
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot  
        fwk(iftab+3) = rnorm 
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = rho0  
        fwk(iftab+6) = rho1  
        fwk(iftab+7) = alpha 
        fwk(iftab+8) = beta  
        fwk(iftab+9) = omega 
        fwk(iftab+10) = gamma 
        fwk(iftab+11) = tmpdot
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10,2x,1pg20.10 )
*
      end
