************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: xtimer - Package timer routine.  Returns cpu time as well
**                     as real time.  (^)
**
************************************************************************
**
      subroutine xtimer ( tcpu , treal , itimer , init )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Package timer routine.  Returns cpu time as well as real
**    time. For the generic Fortran 77 version, the installer should
**    edit this file (the .fm4 file or the .f file) to utilize
**    available system-specific routines.  Note that times are always
**    double precision.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: see IFELSE structure to see machine specific
**       subroutine calls.
**
**  ^SIDE_EFFECTS: modifies tcpu, treal.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
      integer init
      integer itimer
      double precision tcpu, treal
*
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: xtimer.fm4,v 1.12 1994/09/06 17:34:40 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
         if (init .eq. 1) return
         tcpu  = 0d0
         treal = 0d0
      return
      end
