************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
** ^ROUTINE: xslur  - Routine to compute the information for the box
**                    intersection slice.  The coordinates and size of
**                    the intersection of the subgrids is computed, as
**                    well as the processor number of where it is. (^)
**
************************************************************************
**
      subroutine xslur  ( ia, ja, isten, islice, ijob, ilbs, ilbd, inelt
     &,
     &                    ncelts
     &                    )
**
************************************************************************
**
** ^DESCRIPTION:
**      For each stencil point in a finite difference operator operating
**    over a rectangular subgrid, a perturbed grid is obtained that is
**    spread over upto 2**ndim subgrids (ndim is the number of
**    dimensions in the problem, = 2 for a 2D problem, etc.).  The
**    portions of this perturbed subgrid that lie in each of the 2**ndim
**    subgrids are referred to here as slices.
**
**      The purpose of this routine is to determine the location and
**    size of a particular slice islice, and for mimd machines, to
**    determine send and receive processor numbers.
**
**      Several numbering schemes are used to describe slices,
**    subgrids, gridpoints, etc. These are described in the header
**    for "sagrd.fm4".
**
** ^AUTHOR:   wdj@beta.lanl.gov
**
** ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for more details.
**
** ^MACROS:
**
***********************************************************************
*
*     implicit character*1 (a-z)
*
      integer isten
      integer islice
      integer ijob
      integer ncelts
      integer ia(*)
      integer ja(*)
      integer ilbs(*)
      integer ilbd(*)
      integer inelt(*)
*
      integer iaxis
      integer idofst
      integer ipofst
      integer nsten
      integer nb
      integer ncelax
      integer ndim
      integer nelsax
**#   OFFSTN - magnitude of maximum offset along -ve axial direction
**    in user's definition of neighborhood information
**#   OFFSTP - magnitude of maximum offset along +ve axial direction
**    in user's definition of neighborhood information.
**#   NBR - processor number of processor in the $1 position in the
**#    neighborhood of the $2 processor as defined by the user. 
*
      integer  imodf
      external imodf
      integer  ifloor
      external ifloor
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: xslur.fm4,v 1.5 1994/07/20 18:20:40 joubert Exp $
*     $Revision: 1.0 $
*     $Log: xslur.fm4,v $
************************************************************************
*
      ndim  = ia(1)
      nsten = ia(2)
      nb    = ia(3)
      ncelts = 1
*
      do 5500 iaxis = 1, ndim
        if (ijob .eq. 3) then
          idofst  =  ja(iaxis+ndim*(isten-1))
        else
          idofst  = -ja(iaxis+ndim*(isten-1))
        endif
*
        nelsax = ja(iaxis+ndim*nsten)
        ipofst = mod(islice/2**(iaxis-1),2)
        if (ipofst .eq. 0) then
          ncelax = nelsax - imodf(idofst,nelsax)
        else
          ncelax =          imodf(idofst,nelsax)
        endif
        ncelts = ncelts * ncelax
        if (ncelax .eq. 0) return
        inelt(iaxis) = ncelax
*
        if (ipofst .eq. 0) then
          ilbs(iaxis) = imodf(idofst,nelsax)
        else
          ilbs(iaxis) = 0
        endif
        if (ipofst .eq. 0) then
          ilbd(iaxis) = 0
        else
          ilbd(iaxis) = nelsax - imodf(idofst,nelsax)
        endif
*
5500  continue
*
*---done---------------------------------------------------------------
      return
      end
