************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: xerstr - routine to print out the header, mesage or tail
**                     of the error message. (^)
**
************************************************************************
**
       subroutine xerstr ( icall, pstr, iparm, ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine prints out error message information at a lower
**    level than xersho.  Based on icall, it either prints out the
**    header part of the message, the text lines of the message,
**    or the tail part of the message.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS: none
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*     implicit character*1 (a-z)
      integer icall
      integer ier
      character*(*) pstr
      integer iparm(*)
        integer ipme
        integer nproc
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: xerstr.fm4,v 1.8 1994/04/30 04:40:17 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      ipme  = 0
      nproc = 1
      if      (     icall  .eq. -1) then
        write (iparm(1),1010) 
      else if (     icall  .eq.  1) then
        write (iparm(1),1011) 
      else if (iabs(icall) .eq.  2) then
        write (iparm(1),1020) pstr
      else if (iabs(icall) .eq.  3) then
        write (iparm(1),1030) pstr
      else if (iabs(icall) .eq.  4) then
        write (iparm(1),1040) 
      endif
 900  continue
      return
*-------------------------format statements-----------------------------
 1010 format (//1x,60('*') /
     &          1x,18('*'),' F a t a l    E r r o r ',18('*') /
     &          1x,60('*') /)
 1011 format (//1x,60('*') /
     &          1x,22('*'),     ' W a r n i n g ',    23('*') /
     &          1x,60('*') /)
 1020 format (1x,'Routine ',a)
 1030 format (1x,a)
 1040 format (/1x,60('*')/)
      end
