************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: xersho - Package routine to print out error message. (^)
**
************************************************************************
**
       subroutine xersho ( ierp , iname , iparm , auxstr )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine is the general error message handler for the package.
**    It decodes the error code ierp and prints an informative message.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS: none
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer ierp
      character*(*) iname
      character*(*) auxstr
      integer iparm(*)
*
      integer inum
      integer iere
      integer ier
          character*72 errmsg(17), wrnmsg(4)
*
      external xerstr
*
       data errmsg(1)/'Unknown error' /
       data errmsg(2)/'Insufficient integer workspace'/
       data errmsg(3)/'Insufficient floating point workspace'/
       data errmsg(4)/'Invalid subroutine argument used'/
       data errmsg(5)/'Inadmissible i/fparm parameter'/
       data errmsg(6)/'Breakdown in iterate calculation'/
       data errmsg(7)/'Breakdown in basis vector calculation'/
       data errmsg(8)/'Iterative method has stagnated'/
       data errmsg(9)/'Missing or zero main diag matrix entry'/
       data errmsg(10)/'Error in performing stopping test'/
       data errmsg(11)/'Error in matrix specification'/
       data errmsg(12)/'Error in interprocessor communication'/
       data errmsg(13)/'Error in input/output'/
       data errmsg(14)/'Error in memory allocation'/
       data errmsg(15)/'Error in array specification'/
       data errmsg(16)/'Error in computing preconditioner'/
       data errmsg(17)/'Error in matrix vector product'/
       data wrnmsg(1) /'Unknown warning'/
       data wrnmsg(2) /'Failure to converge in ITSMAX iterations'/
       data wrnmsg(3) /'ZETA may be too small for convergence'/
       data wrnmsg(4) /'Error in computing convergence statistics'/
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: xersho.fm4,v 1.11 1994/04/30 04:40:15 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      if (ierp.eq.0) return
*
*
      if (ierp.lt.0  .and.  iparm(2).lt.1) return
      if (ierp.gt.0  .and.  iparm(2).lt.2) return
      iere = ierp
*
      if (iere .lt. -17 ) iere = -(-1)
      if (iere .gt.  4 ) iere =   1
*
      if (iere.lt.0) then
        call xerstr (-1,' ',iparm,ier)
           if (ier .lt. 0) go to 900
      endif
      if (iere .gt. 0) then
        call xerstr ( 1,' ',iparm,ier)
           if (ier .lt. 0) go to 900
      endif
*
      call xerstr (2,iname,iparm,ier)
*
      inum = iabs(iere)
      if (iere .lt. 0) then
        call xerstr (-3,errmsg(inum),iparm,ier)
           if (ier .lt. 0) go to 900
      else
        call xerstr ( 3,wrnmsg(inum),iparm,ier)
           if (ier .lt. 0) go to 900
      endif
*
      if (auxstr .ne. ' ') then
        call xerstr ( 3,auxstr,iparm,ier)
           if (ier .lt. 0) go to 900
      endif
*
      call xerstr (4,' ',iparm,ier)
           if (ier .lt. 0) go to 900
*
      return
*
 900  continue
      ierp = ier
      return
      end
