************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WWSET - Routine to copy one vector to another (^)
**
************************************************************************
**
      subroutine swset ( vo , v ,  iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Simply copies vector v to vector vo.  This routine is part of the
**    Low-level level-1 BLAS-type routine required by pcg package.
**    Written for Sun, Cray YMP, Ncube, iPSC 860, or generic f77;
**#   as set by m4 variable MACHINE.
**    
**    On a Cray YMP the vector is partitioned out to all available
**    processors.  The partitioning is done using compiler directives,
**    thus the complier decides how the partitioning is done.
**    
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below. 
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**    Basic vector addition
**    
**  ^REFERENCES:
**    
**  ^DOCUMENTATION:
**    
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
**  ^MACROS USED:
**
************************************************************************
*
*     implicit character*1 (a-z)
*#    BASICAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
      integer iwk(*)
      integer iparm(*)
      real       fwk(*)
      real       fparm(*)
      real       vo(*)
      real       v(*)
      integer nv
      integer i
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: wset.fm4,v 1.7 1994/02/04 03:00:11 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      nv = iparm(3)
      do 5500 i = 1, nv
              vo(i) = v(i)
5500  continue
      return
      end
