************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WSCGR - Grid-based matrix matrix scaling routine.
**                      (^)
**
************************************************************************
**
      subroutine sscgr ( ijob , ia , ja , a , u , uexact , b , iwk , fwk
     & ,
     &       iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Wrapper routine to apply/undo scaling to a matrix or scale
**    vectors.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    PREPAL           -
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      integer iwk(*)
      integer iparm(*)
      real       fwk(*)
      real       fparm(*)
      integer ia(*)
      integer ja(*)
      real a(*)
      real u(*)
      real uexact(*)
      real b(*)
*
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external sfmini
      external sfmal
      external sffre
      integer  nv
      integer  ndim
      integer  nsten
      integer  nb
      integer  ns
      integer  imaxgr
      external imaxgr
      integer  ivaxgr
      external ivaxgr
      integer itab
      integer idiag1
      integer idiag2
      integer imdiag
      integer isscll, issclr
      integer idbufp
      integer idbufl
      integer ncpprd
      integer ielt
      integer nelt
      integer iaxin1, iaxin2
      integer ivip
      integer iap
      integer islno
      integer iaxis
      integer isten
      integer is
      integer ibr
      integer ibc
      integer iin1, iin2
      integer nin1, nin2
      integer istrd1
      integer istrd2
      integer ivstr1
      integer ivstr2
      integer ivstrr
      integer imstr1
      integer imstr2
      integer imstrr
      integer imstrc
      integer ivstrg
      integer imstrs
      integer imstrg
      integer imins (32)
      integer imind (32)
      integer inelt (32)
      real dmin
*
      integer  islice
      external islice
*
**#   NTAB - size of the saved table
**#   IOFST - stencil offset extracted from ja
**#   NSBGR - number of subgrid points along an axis
**#   NPROCS - number of processors along an axis
*
*=======================================================================
*#    GET_CIRCUM_RECT(ipm)
*#                      - fill out iminc/imaxc, the extents of the
*#                        circumscribing rectangle, in grid points.
*#                        ipm=1 regular case, -1 transpose case.
*#                        (^)
*
*=======================================================================
*#    GET_CA_PROCS(ipm)
*#                  - fill out ncpmin/max, ncp, ncpprd, the information
*#                    on the communication active processors.
*#                    (^)
*
*=======================================================================
*#    GET_IPSEND_IPRECV(ipm)
*#              - fill out ipsend/iprecv based on iprc and ncp*.
*#                Also fill out iprcmi, the multiindex of iprc in the
*#                ncpmin/max coord system.
*#                imi2/3 temporaries.
*#                (^)
*
*=======================================================================
*#    CHECK_WHETHER_BUFFER_NEEDED(ipm,iline)
*#                  - figure out whether we will really need to use
*#                    anything from the processor in question.
*#                    Assumes iprcmi.
*#                    (^)
*
*=======================================================================
*#    GET_SUBGRID_INTERSECT_CIRCUM_RECT(ipm)
*#                  - fill out iminr/imaxr, the coords of the rectangle
*#                    that intersects the circumscribed rectangle and
*#                    the subgrid specified in iprcmi.  Also nelt.
*#                    (^)
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: scgr.fm4,v 1.27 1995/05/18 17:52:00 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*
* Table semantics:
*         1 - pointer to left  vector
*         2 - pointer to right vector
*         3 - has left  scaling been applied yet
*         4 - has right scaling been applied yet
*         5 - pointer to table of buffer pointers
*         6 - pointer to table of buffer lengths
*         7 - size of table of buffer pointers
*
*
*-----------------------------------------------------------------------
*
      ipme  = 0
      nproc = 1
      itab = (iparm(6))
      idiag1 = (iparm(6))
      idiag2 = (iparm(6))
      idbufp = (iparm(6))
      idbufl = (iparm(6))
      isscll = 0
      issclr = 0
      ncpprd = 0
*
      nv     = iparm(3     )
      ndim   = ia   (1 )
      nsten  = ia   (2)
      nb     = ia   (3   )
      ns     = nv / nb
*
      ivstrr = ivaxgr(2,1,ia(5),nb,ns,nsten)     - ivaxgr(1,1,ia(5),nb,n
     &s,nsten)
      ivstrg = ivaxgr(1,2,ia(5),nb,ns,nsten)     - ivaxgr(1,1,ia(5),nb,n
     &s,nsten)
      imstrr = imaxgr(2,1,1,1,ia(4),nb,ns,nsten) - imaxgr(1,1,1,1,ia(4),
     &nb,ns,nsten)
      imstrc = imaxgr(1,2,1,1,ia(4),nb,ns,nsten) - imaxgr(1,1,1,1,ia(4),
     &nb,ns,nsten)
      imstrs = imaxgr(1,1,2,1,ia(4),nb,ns,nsten) - imaxgr(1,1,1,1,ia(4),
     &nb,ns,nsten)
      imstrg = imaxgr(1,1,1,2,ia(4),nb,ns,nsten) - imaxgr(1,1,1,1,ia(4),
     &nb,ns,nsten)
*
*-----------------------------------------------------------------------
*-------------------------------init case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.1) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
*
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
          call ximal (itab,7, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
          call sfmal (idiag1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       do 5500 ibr = 1, nb
       do 5501 is = 1, ns
       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = 0e0
 5501  continue
 5500  continue
*
          if (iparm(41) .eq. 2) then
            imdiag = 0
            do 5502 isten = 1, nsten
              do 5503 iaxis = 1, ndim
                if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 10
5503  continue
              imdiag = 1
       do 5504 ibr = 1, nb
       do 5505 is = 1, ns
       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) =
     &               fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) 
     &+
     &               a  (         (1+((ibr)-1)*imstrr+((ibr)-1)*imstrc+(
     &(isten)-1)*imstrs+((is)-1)*imstrg))
 5505  continue
 5504  continue
   10         continue
5502  continue
            if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'No main diagonal' )
                go to 900
            endif
          else
       do 5506 ibr = 1, nb
       do 5507 is = 1, ns
       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = 0e0
 5507  continue
 5506  continue
       do 5508 ibr = 1, nb
       do 5509 ibc = 1, nb
       do 5510 isten = 1, nsten
       do 5511 is = 1, ns
           fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) =
     &                 fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)
     &) +
     &               abs(a  (       (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc
     &+((isten)-1)*imstrs+((is)-1)*imstrg)))
 5511  continue
 5510  continue
 5509  continue
 5508  continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
          endif
*
          dmin = (abs(fwk(idiag1-1+(1+((1)-1)*ivstrr+((1)-1)*ivstrg))))
       do 5512 ibr = 1, nb
       do 5513 is = 1, ns
       dmin = min((dmin),
     &                      (abs(fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-
     &1)*ivstrg)))))
 5513  continue
 5512  continue
          if ((dmin) .eq. (0e0)) then
                ier = -9
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'Zero element found on main diagonal' )
                go to 900
          endif
*
          go to 900
        endif
*
*---------------------------split diag scaling--------------------------
*
        if (iparm(41) .eq. 1) then
          call ximal (itab,7, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
          call sfmal (idiag1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
       do 5514 ibr = 1, nb
       do 5515 is = 1, ns
       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = 0e0
 5515  continue
 5514  continue
*
          imdiag = 0
          do 5516 isten = 1, nsten
            do 5517 iaxis = 1, ndim
              if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 11
5517  continue
            imdiag = 1
       do 5518 ibr = 1, nb
       do 5519 is = 1, ns
       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) =
     &             fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) +
     &             a  (         (1+((ibr)-1)*imstrr+((ibr)-1)*imstrc+((i
     &sten)-1)*imstrs+((is)-1)*imstrg))
 5519  continue
 5518  continue
   11       continue
5516  continue
          if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'No main diagonal' )
                go to 900
          endif
*
       do 5520 ibr = 1, nb
       do 5521 is = 1, ns
           fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) =
     &      sqrt((abs(fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg))
     &)))
 5521  continue
 5520  continue
          fparm(23) = fparm(23) + (4.*nb*ns)
*
          dmin = (abs(fwk(idiag1-1+(1+((1)-1)*ivstrr+((1)-1)*ivstrg))))
       do 5522 ibr = 1, nb
       do 5523 is = 1, ns
       dmin = min((dmin),
     &                      (abs(fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-
     &1)*ivstrg)))))
 5523  continue
 5522  continue
          if ((dmin) .eq. (0e0)) then
                ier = -9
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'Zero element found on main diagonal' )
                go to 900
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
                ier = -5
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'Invalid scaling request' )
                go to 900
*
*-----------------------------------------------------------------------
*
      else
        itab = iparm(11)
        if (itab .eq. (iparm(6))) go to 900
        idiag1 = iwk(itab+0)
        idiag2 = iwk(itab+1)
        isscll = iwk(itab+2)
        issclr = iwk(itab+3)
        idbufp = iwk(itab+4)
        idbufl = iwk(itab+5)
        ncpprd = iwk(itab+6)
      endif
*
*-----------------------------------------------------------------------
*------------------------------apply case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.3) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
       do 5524 ibr = 1, nb
       do 5525 ibc = 1, nb
       do 5526 isten = 1, nsten
       do 5527 is = 1, ns
       a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((isten)-1)*ims
     &trs+((is)-1)*imstrg)) =
     &           a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((ist
     &en)-1)*imstrs+((is)-1)*imstrg)) /
     &           fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg))
 5527  continue
 5526  continue
 5525  continue
 5524  continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          isscll = 1
       do 5528 ibr = 1, nb
       do 5529 is = 1, ns
       b((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = b((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) /
     &                     fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivs
     &trg))
 5529  continue
 5528  continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          go to 900
        endif
*
*-------------------------split scaling---------------------------------
*
        if (iparm(41) .eq. 1) then
       do 5530 ibr = 1, nb
       do 5531 ibc = 1, nb
       do 5532 isten = 1, nsten
       do 5533 is = 1, ns
       a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((isten)-1)*ims
     &trs+((is)-1)*imstrg)) =
     &           a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((ist
     &en)-1)*imstrs+((is)-1)*imstrg)) /
     &           fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg))
 5533  continue
 5532  continue
 5531  continue
 5530  continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          isscll = 1
          do 5534 isten = 1, nsten
            do 5535 islno = 0, 2**ndim-1
              call xslice ( ia, ja, isten, islno, 4, imins, imind, inelt
     &,
     &                      nelt
     &                     )
              if (nelt .eq. 0) goto 53
              call xplane ( ja(1+ndim*nsten), inelt, ia, iparm,
     &                      iaxin1, iaxin2, istrd1, istrd2, nin1, nin2,
     &                      ivstrr,ivstr1,ivstr2, imstrr,imstrc,imstr1,i
     &mstr2)
              do 5536 ielt = 0, nelt-1, nin1*nin2
                ivip = (1+((1)-1)*ivstrr+((1+islice(ielt,ndim,ja(1+ndim*
     &nsten),inelt,imind))-1)*ivstrg)
                iap  = (1+((1)-1)*imstrr+((1)-1)*imstrc+((isten)-1)*imst
     &rs+((1+islice(ielt,ndim,ja(1+ndim*nsten),inelt,imins))-1)*imstrg)
       do 5537 iin1 = 0, nin1-1
       do 5538 iin2 = 0, nin2-1
       do 5539 ibr = 0, nb-1
       do 5540 ibc = 0, nb-1
       a (iap +ibr*imstrr
     &                        +ibc*imstrc+iin1*imstr1+iin2*imstr2) =
     &                 a (iap +ibr*imstrr
     &                        +ibc*imstrc+iin1*imstr1+iin2*imstr2)/
     &                 fwk(idiag1-1+
     &                    ivip+ibc*ivstrr+iin1*ivstr1+iin2*ivstr2)
 5540  continue
 5539  continue
 5538  continue
 5537  continue
5536  continue
 53           continue
5535  continue
5534  continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          issclr = 1
       do 5541 ibr = 1, nb
       do 5542 is = 1, ns
       b((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = b((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) /
     &                     fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivs
     &trg))
 5542  continue
 5541  continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          if (((iparm(14).eq.0).or.(iparm(14).eq.1)
     &                 .or.(iparm(14).eq.3))) then
       do 5543 ibr = 1, nb
       do 5544 is = 1, ns
       u((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = u((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) *
     &                       fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*i
     &vstrg))
 5544  continue
 5543  continue
            fparm(23) = fparm(23) + (1.*nb*ns)
          endif
          if (iparm(19) .eq. 1) then
       do 5545 ibr = 1, nb
       do 5546 is = 1, ns
       uexact((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = uexact((1+((ibr)-1
     &)*ivstrr+((is)-1)*ivstrg)) *
     &                             fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is
     &)-1)*ivstrg))
 5546  continue
 5545  continue
            fparm(23) = fparm(23) + (1.*nb*ns)
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
      endif
*
*-----------------------------------------------------------------------
*----------------------------unapply case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.4) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
       do 5547 ibr = 1, nb
       do 5548 is = 1, ns
       b((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = b((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) *
     &                     fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivs
     &trg))
 5548  continue
 5547  continue
          fparm(23) = fparm(23) + (1.*nb*ns)
          if (isscll .eq. 1) then
       do 5549 ibr = 1, nb
       do 5550 ibc = 1, nb
       do 5551 isten = 1, nsten
       do 5552 is = 1, ns
       a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((isten)-1)*ims
     &trs+((is)-1)*imstrg)) =
     &             a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((i
     &sten)-1)*imstrs+((is)-1)*imstrg)) *
     &             fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg))
 5552  continue
 5551  continue
 5550  continue
 5549  continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
            isscll = 0
          endif
          go to 900
        endif
*
*----------------------split diag scaling-------------------------------
*
        if (iparm(41) .eq. 1) then
          if (isscll .eq. 1) then
       do 5553 ibr = 1, nb
       do 5554 ibc = 1, nb
       do 5555 isten = 1, nsten
       do 5556 is = 1, ns
       a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((isten)-1)*ims
     &trs+((is)-1)*imstrg)) =
     &             a(           (1+((ibr)-1)*imstrr+((ibc)-1)*imstrc+((i
     &sten)-1)*imstrs+((is)-1)*imstrg)) *
     &             fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivstrg))
 5556  continue
 5555  continue
 5554  continue
 5553  continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
            isscll = 0
          endif
          if (issclr .eq. 1) then
          do 5557 isten = 1, nsten
            do 5558 islno = 0, 2**ndim-1
              call xslice ( ia, ja, isten, islno, 4, imins, imind, inelt
     &,
     &                      nelt
     &                     )
              if (nelt .eq. 0) goto 54
              call xplane ( ja(1+ndim*nsten), inelt, ia, iparm,
     &                      iaxin1, iaxin2, istrd1, istrd2, nin1, nin2,
     &                      ivstrr,ivstr1,ivstr2, imstrr,imstrc,imstr1,i
     &mstr2)
              do 5559 ielt = 0, nelt-1, nin1*nin2
                ivip = (1+((1)-1)*ivstrr+((1+islice(ielt,ndim,ja(1+ndim*
     &nsten),inelt,imind))-1)*ivstrg)
                iap  = (1+((1)-1)*imstrr+((1)-1)*imstrc+((isten)-1)*imst
     &rs+((1+islice(ielt,ndim,ja(1+ndim*nsten),inelt,imind))-1)*imstrg)
       do 5560 iin1 = 0, nin1-1
       do 5561 iin2 = 0, nin2-1
       do 5562 ibr = 0, nb-1
       do 5563 ibc = 0, nb-1
       a (iap +ibr*imstrr
     &                        +ibc*imstrc+iin1*imstr1+iin2*imstr2) =
     &                 a (iap +ibr*imstrr
     &                        +ibc*imstrc+iin1*imstr1+iin2*imstr2)*
     &                 fwk(idiag1-1+
     &                    ivip+ibc*ivstrr+iin1*ivstr1+iin2*ivstr2)
 5563  continue
 5562  continue
 5561  continue
 5560  continue
5559  continue
 54           continue
5558  continue
5557  continue
          fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
          issclr = 0
          endif
*
       do 5564 ibr = 1, nb
       do 5565 is = 1, ns
       b((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = b((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) *
     &                     fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivs
     &trg))
 5565  continue
 5564  continue
          fparm(23) = fparm(23) + (1.*nb*ns)
       do 5566 ibr = 1, nb
       do 5567 is = 1, ns
       u((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = u((1+((ibr)-1)*ivstrr+(
     &(is)-1)*ivstrg)) /
     &                     fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is)-1)*ivs
     &trg))
 5567  continue
 5566  continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          if (iparm(19) .eq. 1) then
       do 5568 ibr = 1, nb
       do 5569 is = 1, ns
       uexact((1+((ibr)-1)*ivstrr+((is)-1)*ivstrg)) = uexact((1+((ibr)-1
     &)*ivstrr+((is)-1)*ivstrg)) /
     &                             fwk(idiag1-1+(1+((ibr)-1)*ivstrr+((is
     &)-1)*ivstrg))
 5569  continue
 5568  continue
            fparm(23) = fparm(23) + (4.*nb*ns)
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
      endif
*
*-----------------------------------------------------------------------
*-------------------------------term case-------------------------------
*-----------------------------------------------------------------------
*
 900  continue
*
      if (iparm(11).eq.(iparm(6))) then
        goto 910
      endif
*
*-----------------------------------------------------------------------
*
      if (ijob.eq.-1 .or. ier.lt.0) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 910
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
          call sffre (idiag1,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
          call xifre (itab,7, iparm , fparm , iwk , fwk , ier )
          go to 910
        endif
*
*----------------------split diag scaling-------------------------------
*
        if (iparm(41) .eq. 1) then
          call sffre (idiag1,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
          call xifre (itab,7, iparm , fparm , iwk , fwk , ier )
          go to 910
        endif
*-----------------------------------------------------------------------
                ier = -5
                call xersho ( ier, 'sscgr' , iparm ,
     &                        910 )
      endif
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
      if (ijob.ne.1  .and. ijob.ne.3 .and.
     &    ijob.ne.4 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'sscgr' , iparm ,
     &                        'Invalid ijob value' )
      endif
*-----------------------------------------------------------------------
*-------------------------final termination-----------------------------
*-----------------------------------------------------------------------
 910  continue
      if (itab .ne. (iparm(6))) then
        iwk(itab+0) = idiag1
        iwk(itab+1) = idiag2
        iwk(itab+2) = isscll
        iwk(itab+3) = issclr
        iwk(itab+4) = idbufp
        iwk(itab+5) = idbufl
        iwk(itab+6) = ncpprd
      endif
      iparm(11) = itab
      return
      end
*-----------------------------------------------------------------------
