************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WIOMR - Reverse communication level routine for the
**                    truncated incomplete orthogonalization method
**                    (IOM). (^)
**
************************************************************************
**
      subroutine siomr ( ijob , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    IOM iterative method of Saad, a.k.a. Arnoldi method for solving
**    linear systems of equations.  This is the truncated version;
**    if the truncation factor 16 is set sufficiently high, this
**    method becomes the full orthogonalization method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    Youcef Saad, "Krylov Subspace Methods for Solving Large
**    Unsymmetric Linear Systems", {\sl Mathematics of Computation},
**    Vol. 37, No. 155, July 1981, pp. 105--126.
**
**    Youcef Saad, ``Practical use of Some Krylov Subspace Methods for
**    Solving Indefinite and Nonsymmetric Linear Systems,'' {\sl SIAM
**    J. Sci. Stat. Comp.}, vol. 5, no. 1, March 1984, pp.  203-228.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
      integer iwk(*)
      integer iparm(*)
      real       fwk(*)
      real       fparm(*)
      real u(*)
      real uexact(*)
      real b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer    iitab
      integer    iftab
      integer    iwkstg
      integer    iclstg
      integer    in
      integer    is
      integer    iretlb
      integer    ivitmp, ivotmp
      integer    iv1tst, iv2tst
      integer    istab1, istab2, istab
      integer    ib1,ib2, iu1,iu2
      integer    iud
      parameter (iud  =0)
      integer    ibd
      parameter (ibd  =1)
      integer    ilbd
      parameter (ilbd =2)
      integer    irlbd
      parameter (irlbd=3)
      integer    ied
      parameter (ied  =4)
      integer    ird
      parameter (ird  =5)
      integer    ilrd
      parameter (ilrd =6)
      integer    irlrd
      parameter (irlrd=7)
      real      urndf
      real      top
      real      bot
      parameter (urndf=.1)
      real      mydot1, mydot2
      external   sargck
      external   sckstg
      external   swrnd
      external   sifppr
      external   sitput
      external   xtimer
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external sfmini
      external sfmal
      external sffre
*     integer imv1, imv2
      integer    ir
      integer    iqlr
      integer    iqrqlr
      integer    ip
      integer    iqlp
      integer    iqrqlp
      integer    iqrqlw
      integer    iv1
      integer    iv2
      integer    ipf, iwf, icos, isin, iu
      integer    ns
      integer    i
      real      rdot
      real      rnorm
      real      r0norm
      real      vnorm, vnold
      real      zold, zbar, zbold, ucpr, ucprol, ucfr, ucfrol
      real      uudot, uexdt
      real      pap, vdot, ut, h, v1, v2, denom, val
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: iomr.fm4,v 1.6 1994/11/22 05:20:27 joubert Exp $
*     $Revision: 1.0 $
*     $Log: iomr.fm4,v $
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      ip = (iparm(6))
      iqlp = (iparm(6))
      iqrqlp = (iparm(6))
      iqrqlw = (iparm(6))
      iv1 = (iparm(6))
      iv2 = (iparm(6))
      ipf = (iparm(6))
      iwf = (iparm(6))
      icos = (iparm(6))
      isin = (iparm(6))
      iu = (iparm(6))
*
*     *---go to the brancher unless this is the init call---
      if (ijob .ne. 1) go to 1000
*
*     *---inits----------
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
*     *---initialize pointers----------
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
*     *---initialize----------
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call sfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call sargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
*     *---start timer------
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 0) then
        call sifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
*     *---reserve place to save integer and float variables----------
*     *---across revcom calls----------
      call ximal (iitab,34, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (iftab,14, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/''     Truncated IOM Method.''/)') 
      endif
*
      ns = max(1,min(iparm(16),iparm(4)))
*
      call sfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (iqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , ie
     &r )
           if (ier .lt. 0) go to 900
      call sfmal (iqrqlw,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call sfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call sfmal (ip,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &ier )
           if (ier .lt. 0) go to 900
        endif
      else
        ir = iqlr
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        call sfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk 
     &, ier )
           if (ier .lt. 0) go to 900
      else
        iqrqlr = iqlr
        iqrqlp = iqlp
      endif
      call sfmal (iv1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (iv2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (ipf   ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (iwf   ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (icos  ,ns+1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (isin  ,ns+1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call sfmal (iu    ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
*     *---set u to zero----------
      if (iparm(14) .eq. -2
     &    .or. iparm(14) .eq. -1) then
          call swfil (u,0e0,
     &     iparm , fparm , iwk , fwk , ier  )
      endif
*
*     *---random u----------
      if (iparm(14) .eq. 2
     &    ) go to 5500
                 go to 5501
 5500  continue
          call swrdot (mydot1,b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
        call swrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2000
        go to 1500
 2000   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swrdot (mydot2,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call swscl ( u, u, urndf*sqrt(mydot1/mydot2),  iparm , fparm ,
     & iwk , fwk , ier  )
                go to 5502
 5501 continue
 5502 continue
*
*     *---random u perturbation----------
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2001
        go to 1500
 2001   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call swrdot (mydot1,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call swset (fwk(iv1),u,
     &     iparm , fparm , iwk , fwk , ier  )
        call swrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv2 
         ireq = 3
        iretlb = 2002
        go to 1500
 2002   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swrdot (mydot2,fwk(iv2),
     &    fwk(iv2),  iparm , fparm , iwk , fwk , ier  )
          call swsax (u,fwk(iv1),
     &    u, -urndf*sqrt(mydot1/mydot2),  iparm , fparm , iwk , fwk , ie
     &r  )
                go to 5505
 5504 continue
 5505 continue
*
*     *---begin iteration statistics calculation----------
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
        call sfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call swdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call swdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call swset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5511
 5510 continue
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call swset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2003
        go to 1500
 2003   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5511 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call swset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call swset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5514
 5513 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2004
        go to 1500
 2004   continue
         if (ijob .eq. -1) go to 900
 5514 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call swsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call swdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2005
        go to 1500
 2005   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call swdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call swset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5517
 5516 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2006
        go to 1500
 2006   continue
         if (ijob .eq. -1) go to 900
 5517 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call swset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call swset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5520
 5519 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2007
        go to 1500
 2007   continue
         if (ijob .eq. -1) go to 900
 5520 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Initial iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10)'
     &) sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10)'
     &) sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10)'
     &) sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10)'
     &) sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10)'
     &) sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10)'
     &) sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10)'
     &) sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10)'
     &) sqrt(fwk(istab+irlrd))
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call sffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call sffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*     *---end iteration statistics calculation----------
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2)) .or. iparm(14).eq.-1) 
     &go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5527
                 go to 5528
 5527  continue
          call swset (fwk(ir),b,
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          call swset (fwk(iqlr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5532
 5531 continue
          iva = ir 
          ivql = iqlr 
         ireq = 5
        iretlb = 2008
        go to 1500
 2008   continue
         if (ijob .eq. -1) go to 900
 5532 continue
*        *---end revcom precon----------
                go to 5529
 5528 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call swset (fwk(iqlr),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5535
 5534 continue
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call swset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iqlr 
         ireq = 5
        iretlb = 2009
        go to 1500
 2009   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5535 continue
*        *---end revcom precon----------
 5529 continue
                go to 5526
 5525 continue
          call swset (fwk(iqlr),b,
     &     iparm , fparm , iwk , fwk , ier  )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5539
                 go to 5540
 5539  continue
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ir 
         ireq = 3
        iretlb = 2010
        go to 1500
 2010   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(ir),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call swset (fwk(iqlr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5544
 5543 continue
          iva = ir 
          ivql = iqlr 
         ireq = 5
        iretlb = 2011
        go to 1500
 2011   continue
         if (ijob .eq. -1) go to 900
 5544 continue
*        *---end revcom precon----------
                go to 5541
 5540 continue
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2012
        go to 1500
 2012   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5545
                 go to 5546
 5545  continue
          call swset (fwk(iqlr),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5547
 5546 continue
          iva = iv1 
          ivql = iqlr 
         ireq = 5
        iretlb = 2013
        go to 1500
 2013   continue
         if (ijob .eq. -1) go to 900
 5547 continue
*        *---end revcom precon----------
 5541 continue
                go to 5538
 5537 continue
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iqlr 
         ireq = 3
        iretlb = 2014
        go to 1500
 2014   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(iqlr),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
 5538 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5548
                 go to 5549
 5548  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5551
                 go to 5552
 5551  continue
          call swset (fwk(iqrqlr),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5553
 5552 continue
          ivql = iqlr 
          ivqr = iqrqlr 
         ireq = 7
        iretlb = 2015
        go to 1500
 2015   continue
         if (ijob .eq. -1) go to 900
 5553 continue
*        *---end revcom precon----------
                go to 5550
 5549 continue
 5550 continue
*
          call swrdot (rdot,fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
      rnorm  = sqrt(abs(rdot))
      r0norm = rnorm
*
*---------------------------iteration loop------------------------------
*
 100  continue
*
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'QL r norm           ', rnorm
        endif
*
*     *---begin user stopping test----------
        if (iparm(12).eq.-3) go to 5554
                 go to 5555
 5554  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir 
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr 
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr 
          endif
          ireq   = 9
        iretlb = 2016
        go to 1500
 2016   continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call sitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        write (iparm(1),'(/a/)') ' User-requested termination of iterati
     &ve method.'
            endif
            go to 900
          endif
                go to 5556
 5555 continue
 5556 continue
        if (iparm(12) .gt. 1) go to 5557
                 go to 5558
 5557  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'siomr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
              endif
          call swdot (bot, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            endif
            call sfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
          call swsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call swdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
            call sffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call swdot (bot, b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
            endif
          call swdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
          endif
          if (iparm(12) .eq. 3) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call swdot (bot, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5568
 5567 continue
                call sfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call swset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5571
 5570 continue
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call swset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2017
        go to 1500
 2017   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5571 continue
*        *---end revcom precon----------
          call swdot (bot, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
                call sffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
                go to 5565
 5564 continue
 5565 continue
          call swdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 4) go to 5572
                 go to 5573
 5572  continue
            if (iparm(5) .eq. 0) go to 5575
                 go to 5576
 5575  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5578
                 go to 5579
 5578  continue
          call swdot (bot, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5580
 5579 continue
                call sfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
                call sfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
          call swset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5583
 5582 continue
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call swset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2018
        go to 1500
 2018   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5583 continue
*        *---end revcom precon----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call swset (fwk(iv2tst),fwk(iv1tst),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5586
 5585 continue
          ivql = iv1tst 
          ivqr = iv2tst 
         ireq = 7
        iretlb = 2019
        go to 1500
 2019   continue
         if (ijob .eq. -1) go to 900
 5586 continue
*        *---end revcom precon----------
          call swdot (bot, fwk(iv2tst),
     &    fwk(iv2tst),  iparm , fparm , iwk , fwk , ier  )
                call sffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
                call sffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5580 continue
                go to 5577
 5576 continue
 5577 continue
          call swdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5574
 5573 continue
 5574 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'siomr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call swdot (top, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            else
              call sfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          call swsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call swdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
              call sffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk
     & , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call swdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call swdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call swdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if ((top) .lt. (0e0)) then
                ier = -10
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if ((bot) .le. (0e0)) then
                ier = -10
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt((top)/(bot))
          call sitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
                go to 5559
 5558 continue
 5559 continue
*     *---end user stopping test----------
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. 0e0) then
                ier = -10
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call sitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
        endif
*
*       *---begin exact stopping test----------
        if (iparm(12) .eq. -2) then
          call swsub ( fwk(iv1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call swrdot (uudot,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call swrdot (uexdt,uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
          if ((uudot)  .lt. (0e0)) then
                ier = -10
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if ((uexdt) .le. (0e0)) then
                ier = -10
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt((uudot)/(uexdt))
          call sitput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
        endif
*       *---end exact stopping test----------
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'siomr' , iparm , ' ' )
          go to 900
        endif
*
        call sckstg ( iclstg, iwkstg,  iparm , fparm , iwk , fwk , ier  
     &)
           if (ier .lt. 0) go to 900
*
*-----------------------proceed with iteration--------------------------
*
        if (is .eq. 0) then
          call swset (fwk(iqlp+iparm(3)*((mod((is),(ns+1))))),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(1
     &5)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call swset (fwk(ip+iparm(3)*((mod((is),(ns+1))))),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call swset (fwk(iqrqlp+iparm(3)*((mod((is),(ns+1))))),fwk(iqrq
     &lr),
     &     iparm , fparm , iwk , fwk , ier  )
          endif
          vnorm = rnorm
          if (vnorm .eq. 0e0) then
                ier = -7
                call xersho ( ier, 'siomr' , iparm , ' ' )
                go to 900
          endif
          fwk((ipf   + mod((is),(ns+1)))) = 1e0/vnorm
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'h(1,0)              ', vnorm
          endif
        endif
*
        go to (501,502,503,504), iparm(13)+1
 501    continue
*        *---begin revcom matvec----------
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 3
        iretlb = 2020
        go to 1500
 2020   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
        go to 510
 502    continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5587
                 go to 5588
 5587  continue
*        *---begin revcom matvec----------
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 3
        iretlb = 2021
        go to 1500
 2021   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5590
                 go to 5591
 5590  continue
          call swset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip  
     &+iparm(3)*((mod((is+1),(ns+1))))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5592
 5591 continue
          iva = ip   + iparm(3)*((mod((is+1),(ns+1))))
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 5
        iretlb = 2022
        go to 1500
 2022   continue
         if (ijob .eq. -1) go to 900
 5592 continue
*        *---end revcom precon----------
                go to 5589
 5588 continue
*        *---begin revcom matvec----------
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iv1  
         ireq = 3
        iretlb = 2023
        go to 1500
 2023   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
          call swset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iv1 
     &),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5595
 5594 continue
          iva = iv1  
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 5
        iretlb = 2024
        go to 1500
 2024   continue
         if (ijob .eq. -1) go to 900
 5595 continue
*        *---end revcom precon----------
 5589 continue
        go to 510
 503    continue
*        *---begin revcom matvec----------
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 3
        iretlb = 2025
        go to 1500
 2025   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5596
                 go to 5597
 5596  continue
          call swset (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iq
     &lp  +iparm(3)*((mod((is+1),(ns+1))))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5598
 5597 continue
          ivql = iqlp   + iparm(3)*((mod((is+1),(ns+1))))
          ivqr = iqrqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 7
        iretlb = 2026
        go to 1500
 2026   continue
         if (ijob .eq. -1) go to 900
 5598 continue
*        *---end revcom precon----------
        go to 510
 504    continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5599
                 go to 5600
 5599  continue
*        *---begin revcom matvec----------
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 3
        iretlb = 2027
        go to 1500
 2027   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
          call swset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip  
     &  +iparm(3)*((mod((is+1),(ns+1))))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5604
 5603 continue
          iva = ip     + iparm(3)*((mod((is+1),(ns+1))))
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 5
        iretlb = 2028
        go to 1500
 2028   continue
         if (ijob .eq. -1) go to 900
 5604 continue
*        *---end revcom precon----------
                go to 5601
 5600 continue
*        *---begin revcom matvec----------
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iv1  
         ireq = 3
        iretlb = 2029
        go to 1500
 2029   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5605
                 go to 5606
 5605  continue
          call swset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iv1 
     &),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5607
 5606 continue
          iva = iv1  
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 5
        iretlb = 2030
        go to 1500
 2030   continue
         if (ijob .eq. -1) go to 900
 5607 continue
*        *---end revcom precon----------
 5601 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
          call swset (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iq
     &lp  +iparm(3)*((mod((is+1),(ns+1))))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5610
 5609 continue
          ivql = iqlp   + iparm(3)*((mod((is+1),(ns+1))))
          ivqr = iqrqlp + iparm(3)*((mod((is+1),(ns+1))))
         ireq = 7
        iretlb = 2031
        go to 1500
 2031   continue
         if (ijob .eq. -1) go to 900
 5610 continue
*        *---end revcom precon----------
 510    continue
*
        fwk((ipf   + mod((is+1),(ns+1)))) = fwk((ipf   + mod((is),(ns+1)
     &)))
        do 5611 i = max(0,(is+1)-ns), (is+1)-1
          call swdot (pap, fwk(iqlp+iparm(3)*((mod((i),(ns+1))))),
     &    fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),  iparm , fparm , iw
     &k , fwk , ier  )
          pap = pap * (fwk((ipf   + mod((i),(ns+1))))) * fwk((ipf   + mo
     &d((is+1),(ns+1))))
          fwk((iu    + mod((i+1)-1,(ns+1)))) = pap
          if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10)') 'h(',i+1,',',is+1,'
     &)      ', pap
          endif
          val = - pap * fwk((ipf   + mod((i),(ns+1)))) / fwk((ipf   + mo
     &d((is+1),(ns+1))))
          call swsax (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iqlp
     &+iparm(3)*((mod((is+1),(ns+1))))),
     &    fwk(iqlp+iparm(3)*((mod((i),(ns+1))))), val,  iparm , fparm , 
     &iwk , fwk , ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(1
     &5)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call swsax (fwk(ip+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip+ipa
     &rm(3)*((mod((is+1),(ns+1))))),
     &    fwk(ip+iparm(3)*((mod((i),(ns+1))))), val,  iparm , fparm , iw
     &k , fwk , ier  )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call swsax (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iq
     &rqlp+iparm(3)*((mod((is+1),(ns+1))))),
     &    fwk(iqrqlp+iparm(3)*((mod((i),(ns+1))))), val,  iparm , fparm 
     &, iwk , fwk , ier  )
          endif
5611  continue
*
          call swrdot (vdot,fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),
     &    fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),  iparm , fparm , iw
     &k , fwk , ier  )
        vdot  = vdot * (fwk((ipf   + mod((is+1),(ns+1))))) * fwk((ipf   
     &+ mod((is+1),(ns+1))))
        vnold = vnorm
        vnorm = sqrt(vdot)
        fwk((iu    + mod((is+2)-1,(ns+1)))) = vnorm
        if (iparm(2) .ge. 5) then
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10)') 'h(',is+2,',',is+1,
     &')      ', vnorm
        endif
        if ((is+1)-ns .gt. 0) fwk((iu    + mod(((is+1)-ns)-1,(ns+1)))) =
     & 0e0
        if (vnorm .eq. 0e0) then
          fwk((ipf   + mod((is+1),(ns+1)))) = 1e0
        else
          fwk((ipf   + mod((is+1),(ns+1)))) = fwk((ipf   + mod((is+1),(n
     &s+1))))/vnorm
        endif
        if (.true.) then
          call swscl ( fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(iq
     &lp+iparm(3)*((mod((is+1),(ns+1))))), fwk((ipf   + mod((is+1),(ns+1
     &)))),  iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(1
     &5)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call swscl ( fwk(ip+iparm(3)*((mod((is+1),(ns+1))))), fwk(ip+i
     &parm(3)*((mod((is+1),(ns+1))))), fwk((ipf   + mod((is+1),(ns+1))))
     &,  iparm , fparm , iwk , fwk , ier  )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call swscl ( fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(
     &iqrqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk((ipf   + mod((is+1),(
     &ns+1)))),  iparm , fparm , iwk , fwk , ier  )
          endif
          fwk((ipf   + mod((is+1),(ns+1)))) = 1e0
        endif
*
        do 5612 i = max(1,(is+1)-ns), (is+1)-1
          ut    = fwk((iu    + mod((i  )-1,(ns+1))))
          h     = fwk((iu    + mod((i+1)-1,(ns+1))))
          fwk((iu    + mod((i  )-1,(ns+1)))) = (fwk((icos  + mod((i),ns)
     &)))*ut + (fwk((isin  + mod((i),ns))))*h
          fwk((iu    + mod((i+1)-1,(ns+1)))) =      -fwk((isin  + mod((i
     &),ns))) *ut +       fwk((icos  + mod((i),ns))) *h
5612  continue
        if (iparm(2) .ge. 5) then
          do 5613 i = max(1,(is+1)-ns), (is+1)
        write (iparm(1),'(1x,a,i5,a,i5,a,1pg20.10)') 'u(',i,',',is+1,') 
     &     ', fwk((iu    + mod((i)-1,(ns+1))))
5613  continue
        endif
        ucprol = ucpr
        ucpr   = fwk((iu    + mod((is+1)-1,(ns+1))))
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'ucorner half rotated', ucpr
        endif
        v1     = ucpr
        v2     = vnorm
        denom  = sqrt ((v1)*v1 + (v2)*v2)
        if (denom .eq. 0e0) then
                ier = -6
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Iterative method has apparently converged
     &' )
                go to 900
        endif
        fwk((icos  + mod((is+1),ns))) = v1/denom
        fwk((isin  + mod((is+1),ns))) = v2/denom
        ucfrol = ucfr
        ucfr   = denom
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'ucorner rotated     ', ucfr
        endif
*
        if (is .ne. 0) then
          fwk((iwf   + mod((is-1),(ns+1)))) = fwk((iwf   + mod((is-1),(n
     &s+1)))) * ucprol/ucfrol
        endif
*
          call swset (fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))),fwk(iqrq
     &lp+iparm(3)*((mod((is),(ns+1))))),
     &     iparm , fparm , iwk , fwk , ier  )
        fwk((iwf   + mod((is),(ns+1)))) = fwk((ipf   + mod((is),(ns+1)))
     &)
        do 5614 i = max(1,(is+1)-ns), (is+1)-1
          call swsax (fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))),fwk(iqrq
     &lw+iparm(3)*((mod((is),(ns+1))))),
     &    fwk(iqrqlw+iparm(3)*((mod((i-1),(ns+1))))), -fwk((iu    + mod(
     &(i)-1,(ns+1))))*fwk((iwf   + mod((i-1),(ns+1))))/fwk((iwf   + mod(
     &(is),(ns+1)))),  iparm , fparm , iwk , fwk , ier  )
5614  continue
        fwk((iwf   + mod((is),(ns+1)))) = fwk((iwf   + mod((is),(ns+1)))
     &)/ucpr
*
        if (is .eq. 0) then
          zold = 0e0
          zbar = vnold
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'zbar                ', zbar
          endif
          if (((mod(iparm(15)/1,2).eq.1)     .or.
     &    iparm(12).eq.-2    .or.
     &    iparm(12).eq.1     .or. iparm(12).eq.5)) then
          call swsax (u,u,
     &    fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))), zbar*fwk((iwf   + m
     &od((is),(ns+1)))),  iparm , fparm , iwk , fwk , ier  )
          endif
        else
          zbold  =  zbar
          zold   =  (fwk((icos  + mod((is),ns))))*zbold
          zbar   = -      fwk((isin  + mod((is),ns)) )*zbold
          if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'z                   ', zold
        write (iparm(1),500) 'zbar                ', zbar
          endif
          if (((mod(iparm(15)/1,2).eq.1)     .or.
     &    iparm(12).eq.-2    .or.
     &    iparm(12).eq.1     .or. iparm(12).eq.5)) then
          call swsax (u,u,
     &    fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), (zold-zbold*ucfro
     &l/ucprol)*fwk((iwf   + mod((is-1),(ns+1)))),  iparm , fparm , iwk 
     &, fwk , ier  )
          call swsax (u,u,
     &    fwk(iqrqlw+iparm(3)*((mod((is  ),(ns+1))))), (zbar)           
     &         *fwk((iwf   + mod((is  ),(ns+1)))),  iparm , fparm , iwk 
     &, fwk , ier  )
          else
          call swsax (u,u,
     &    fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), (zold)           
     &         *fwk((iwf   + mod((is-1),(ns+1)))),  iparm , fparm , iwk 
     &, fwk , ier  )
          endif
        endif
*
        if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call swscl ( fwk(ir), fwk(ip+iparm(3)*((mod((is+1),(ns+1))))),
     & -vnorm*zbar/ucpr*fwk((ipf   + mod((is+1),(ns+1)))),  iparm , fpar
     &m , iwk , fwk , ier  )
        endif
*
        if (((mod(iparm(15)/4,2).eq.1)   .or.
     &    iparm(12).eq.3    .or. iparm(12).eq.7) .or. ((.not.((iparm(13)
     &.eq.1).or.(iparm(13).eq.3))).and.((mod(iparm(15)/2,2).eq.1)     .o
     &r.
     &    iparm(12).eq.2     .or. iparm(12).eq.6))
     &              .or. ((.not.((iparm(13).eq.2).or.(iparm(13).eq.3))).
     &and.((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8))) then
          call swscl ( fwk(iqlr), fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))
     &))), -vnorm*zbar/ucpr*fwk((ipf   + mod((is+1),(ns+1)))),  iparm , 
     &fparm , iwk , fwk , ier  )
        endif
*
        if (((iparm(13).eq.2).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call swscl ( fwk(iqrqlr), fwk(iqrqlp+iparm(3)*((mod((is+1),(ns
     &+1))))), -vnorm*zbar/ucpr*fwk((ipf   + mod((is+1),(ns+1)))),  ipar
     &m , fparm , iwk , fwk , ier  )
        endif
*
        rdot = (vnorm*zbar/ucpr)**2
        rnorm = sqrt(rdot)
*
        in         = in + 1
        iparm(5) = in
        is         = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/a,i7,a/)') '     Truncated IOM Method has con
     &verged in ', iparm(5), ' iterations.'
      endif
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
      if (is.ne.0 .and. .not.((mod(iparm(15)/1,2).eq.1)     .or.
     &    iparm(12).eq.-2    .or.
     &    iparm(12).eq.1     .or. iparm(12).eq.5)) then
          call swsax (u,u,
     &    fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), zbar*fwk((iwf   +
     & mod((is-1),(ns+1)))),  iparm , fparm , iwk , fwk , ier  )
      endif
*
      if (iclstg .ne. 1) then
        call sckstg (-1, iwkstg,  iparm , fparm , iwk , fwk , ier )
      endif
*
*     *---begin iteration statistics calculation----------
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5615
                 go to 5616
 5615  continue
        call sfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call sfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
        call sfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call sfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call swdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call swdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5618
                 go to 5619
 5618  continue
          call swset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5620
 5619 continue
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call swset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2032
        go to 1500
 2032   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
 5620 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call swset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5621
                 go to 5622
 5621  continue
          call swset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5623
 5622 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2033
        go to 1500
 2033   continue
         if (ijob .eq. -1) go to 900
 5623 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call swsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call swdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call sfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call swset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2034
        go to 1500
 2034   continue
          call sffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call swsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call swdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5624
                 go to 5625
 5624  continue
          call swset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5626
 5625 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2035
        go to 1500
 2035   continue
         if (ijob .eq. -1) go to 900
 5626 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call swset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5627
                 go to 5628
 5627  continue
          call swset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5629
 5628 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2036
        go to 1500
 2036   continue
         if (ijob .eq. -1) go to 900
 5629 continue
*        *---end revcom precon----------
          call swdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. 0e0) then
                ier = 4
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Value of RELERR may be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. 0e0) then
                ier = 4
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Value of RELRSD may be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Final iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10)'
     &) sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10)'
     &) sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10)'
     &) sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10)'
     &) sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10)'
     &) sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10)'
     &) sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10)'
     &) sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10)'
     &) sqrt(fwk(istab+irlrd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10)'
     &) fparm(8)
        endif
        write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10)'
     &) fparm(7)
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call sffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call sffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call sffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call sffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call sffre (istab2,8, iparm , fparm , iwk , fwk , ier )
        call sffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5617
 5616 continue
 5617 continue
*     *---end iteration statistics calculation----------
*
      call sffre (iu    ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call sffre (isin  ,ns+1, iparm , fparm , iwk , fwk , ier )
      call sffre (icos  ,ns+1, iparm , fparm , iwk , fwk , ier )
      call sffre (iwf   ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call sffre (ipf   ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call sffre (iv2 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call sffre (iv1 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        call sffre (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk 
     &, ier )
        call sffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier
     & )
      endif
      if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)/2
     &,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
        call sffre (ip,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , ie
     &r )
        call sffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      call sffre (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &ier )
      call sffre (iqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , ie
     &r )
      call sffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call sffre (iftab,14, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,34, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
 910  continue
      if (iparm(27) .eq. 0) then
        call sifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---reset iclev----------
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq        = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme  = 0
      nproc = 1
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Values of ijob and iparm(iptr) incompatib
     &le' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
*     *---remember parameters out of tables----------
        iitab  = iwk(iitab+0)
        iftab  = iwk(iitab+1)
        istab  = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in     = iwk(iitab+5)
        is     = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ib1    = iwk(iitab+15)
        ib2    = iwk(iitab+16)
        iu1    = iwk(iitab+17)
        iu2    = iwk(iitab+18)
        ir     = iwk(iitab+19)
        iqlr   = iwk(iitab+20)
        iqrqlr = iwk(iitab+21)
        ip     = iwk(iitab+22)
        iqlp   = iwk(iitab+23)
        iqrqlp = iwk(iitab+24)
        iv1    = iwk(iitab+25)
        iv2    = iwk(iitab+26)
        iqrqlw = iwk(iitab+27)
        ipf = iwk(iitab+28)
        iwf = iwk(iitab+29)
        icos = iwk(iitab+30)
        isin = iwk(iitab+31)
        iu = iwk(iitab+32)
        ns = iwk(iitab+33)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot   = fwk(iftab+2)
        rnorm  = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        vnorm  = fwk(iftab+5)
        vnold  = fwk(iftab+6)
        zold   = fwk(iftab+7)
        zbar   = fwk(iftab+8)
        zbold  = fwk(iftab+9)
        ucpr   = fwk(iftab+10)
        ucprol = fwk(iftab+11)
        ucfr   = fwk(iftab+12)
        ucfrol = fwk(iftab+13)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'siomr' , iparm ,
     &                        'Argument ijob invalid' )
      endif
*
*     *---perform the branch to where we left off----------
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011
     &,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,
     &2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036),
     &       iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
*     *---save tables----------
        iwk(iitab+0) = iitab 
        iwk(iitab+1) = iftab 
        iwk(iitab+2) = istab 
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in    
        iwk(iitab+6) = is    
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ib1   
        iwk(iitab+16) = ib2   
        iwk(iitab+17) = iu1   
        iwk(iitab+18) = iu2   
        iwk(iitab+19) = ir    
        iwk(iitab+20) = iqlr  
        iwk(iitab+21) = iqrqlr
        iwk(iitab+22) = ip    
        iwk(iitab+23) = iqlp  
        iwk(iitab+24) = iqrqlp
        iwk(iitab+25) = iv1   
        iwk(iitab+26) = iv2   
        iwk(iitab+27) = iqrqlw
        iwk(iitab+28) = ipf
        iwk(iitab+29) = iwf
        iwk(iitab+30) = icos
        iwk(iitab+31) = isin
        iwk(iitab+32) = iu
        iwk(iitab+33) = ns
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot  
        fwk(iftab+3) = rnorm 
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = vnorm 
        fwk(iftab+6) = vnold 
        fwk(iftab+7) = zold  
        fwk(iftab+8) = zbar  
        fwk(iftab+9) = zbold 
        fwk(iftab+10) = ucpr  
        fwk(iftab+11) = ucprol
        fwk(iftab+12) = ucfr  
        fwk(iftab+13) = ucfrol
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10 )
*
      end
