************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WFMAL - routine to allocate floating point memory. (^)
**
************************************************************************
**
      subroutine sfmal ( iptr, nwords,  iparm , fparm , iwk , fwk , ier 
     & )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine is the general purpose floating point memory
**#   allocator.  It calls either the Fortran or the C memory allocator
**    and does error checking.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    BASICAL - (^)
      integer ier
      integer iwk(*)
      integer iparm(*)
      real       fwk(*)
      real       fparm(*)
      integer    iptr
      integer    nwords
*
      integer fused
      integer  imem
*     external imem
      integer  smem
*     external smem
      integer iequiv
      real   requiv
      equivalence (iequiv,requiv)
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: fmal.fm4,v 1.2 1995/04/03 22:54:26 joubert Exp $
************************************************************************
*
      iptr = (iparm(6))
      if (nwords .le. 0) go to 900
*
**#        WNAME(mem)
**#        iptr = WMEM (fwk,nwords)
**#        FETCH(fused,IWFUSD)
**#        fused = fused + (nwords) + 2
**#        SAVE(IWFUSD,fused)
**#        iparm(NWFUSD) = max(iparm(NWFUSD),fused)
         requiv = fwk(1)
         fused = iequiv
           iptr = fused + 1
           fused = fused + (nwords)
         iequiv = fused
         fwk(1) = requiv
           iparm(10) = max(iparm(10),fused)
           if (iparm(10) .gt. iparm(8)) iptr = (iparm(6))
*
         if (iptr .eq. (iparm(6))) then
                ier = -3
                call xersho ( ier, 'sfmal' , iparm , ' ' )
                go to 900
         endif
*
 900  continue
*
      return
      end
