************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WDFALT - Routine to initialize iparm and fparm arrays to
**                     useful default settings. (^)
**
************************************************************************
**
      subroutine sdfalt ( iparm , fparm )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine initiailzes i/fparm, based on the default information
**    specified in defs_ifparm.m4.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**    The i/fparm arrays are set to their default values.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer iparm(*)
      real       fparm(*)
*
      integer  i
        integer ipme
        integer nproc
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: dfalt.fm4,v 1.10 1994/09/06 17:34:35 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      do 5500 i = 1, 50
        iparm(i) = 0
5500  continue
*
      do 5501 i = 1, 30
        fparm(i) = 0e0
5501  continue
*
      iparm(1) = 6
      iparm(2) = 0
      iparm(3) = 1
      iparm(4) = 500
      iparm(5) = 0
      iparm(6) = 0
      iparm(7) = 1
      iparm(8) = 1
      iparm(9) = 0
      iparm(10) = 0
      iparm(11) = 0
      iparm(12) = -1
      iparm(13) = 1
      iparm(14) = -1
      iparm(15) = 0
      iparm(16) = 10
      iparm(17) = 10
      iparm(18) = -1
      iparm(19) = 0
      iparm(20) = 1
      iparm(21) = 0
      iparm(22) = 0
      iparm(23) = 0
      iparm(24) = 0
      iparm(25) = 0
      iparm(26) = 0
      iparm(27) = 0
      iparm(41) = 1
      iparm(42) = 1
      fparm(1) = 0.
      fparm(2) = 0.
      fparm(3) = 0.
      fparm(4) = .0001
      fparm(5) = 1.
      fparm(6) = 1.
      fparm(7) = 1.
      fparm(8) = 1.
      fparm(11) = 0.
      fparm(12) = 0.
      fparm(13) = 0.
      fparm(21) = 0.
      fparm(22) = 0.
      fparm(23) = 0.
      return
      end
