************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: schad - Hadamard product, conjugating one vector. (^)
**
************************************************************************
**
      subroutine schad (n,z,iz,a,ia,x,ix)
**
************************************************************************
**
**  ^DESCRIPTION:
**
**    Computes z = z + conjg(a)*x
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED: see below.
**
**  ^MACROS USED:
**
**
************************************************************************
*
*     implicit character*1 (a-z)
      integer n
      integer iz, ia, ix
          real z(*), a(*), x(*)
      integer i
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: chad.fm4,v 1.8 1994/07/15 19:44:02 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
          if (iz.eq.1 .and. ia.eq.1 .and. ix.eq.1) then
      do 5500 i = 1, n
        z(i) = z(i) + (a(i))*x(i)
5500  continue
          else if (iz.eq.1 .and. ix.eq.1) then
      do 5501 i = 0, n-1
        z(1+i) = z(1+i) + (a(1+(i)*ia))*x(1+i)
5501  continue
          else if (iz.eq.1 .and. ia.eq.1) then
      do 5502 i = 0, n-1
        z(1+i) = z(1+i) + (a(1+i))*x(1+(i)*ix)
5502  continue
          else if (ix.eq.1 .and. ia.eq.1) then
      do 5503 i = 0, n-1
        z(1+(i)*iz) = z(1+i*iz) + (a(1+i))*x(1+i)
5503  continue
          else if (iz.eq.1) then
      do 5504 i = 0, n-1
        z(1+i) = z(1+i) + (a(1+(i)*ia))*x(1+(i)*ix)
5504  continue
          else if (ix.eq.1) then
      do 5505 i = 0, n-1
        z(1+(i)*iz) = z(1+(i)*iz) + (a(1+(i)*ia))*x(1+i)
5505  continue
          else if (ia.eq.1) then
      do 5506 i = 0, n-1
        z(1+(i)*iz) = z(1+(i)*iz) + (a(1+i))*x(1+(i)*ix)
5506  continue
          else
      do 5507 i = 0, n-1
        z(1+(i)*iz) = z(1+(i)*iz) + (a(1+(i)*ia))*x(1+(i)*ix)
5507  continue
          endif
      return
      end
