*---------------------begin include file pcg.h--------------------------
************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
*
*-------------------------iparm definitions-----------------------------
*
*     * revcom-level integer parameter indices
*
      integer nout  
      parameter (nout  =1)
      integer levout
      parameter (levout=2)
      integer nru   
      parameter (nru   =3)
      integer itsmax
      parameter (itsmax=4)
      integer its   
      parameter (its   =5)
      integer malloc
      parameter (malloc=6)
      integer nwi   
      parameter (nwi   =7)
      integer nwf   
      parameter (nwf   =8)
      integer nwiusd
      parameter (nwiusd=9)
      integer nwfusd
      parameter (nwfusd=10)
      integer iptr  
      parameter (iptr  =11)
      integer ntest 
      parameter (ntest =12)
      integer iqside
      parameter (iqside=13)
      integer iuinit
      parameter (iuinit=14)
      integer needrc
      parameter (needrc=15)
      integer ns1   
      parameter (ns1   =16)
      integer ns2   
      parameter (ns2   =17)
      integer ickstg
      parameter (ickstg=18)
      integer iuexac
      parameter (iuexac=19)
      integer idot  
      parameter (idot  =20)
      integer istats
      parameter (istats=21)
      integer itimer
      parameter (itimer=22)
      integer icomm 
      parameter (icomm =23)
      integer msgmin
      parameter (msgmin=24)
      integer msgmax
      parameter (msgmax=25)
      integer msgtyp
      parameter (msgtyp=26)
      integer iclev 
      parameter (iclev =27)
*
*     * accelerator-level integer parameter indices
*
*
*     * top-level integer parameter indices
*
      integer iscale
      parameter (iscale=41)
      integer ictran
      parameter (ictran=42)
*
*-------------------------fparm definitions-----------------------------
*
*     * revcom-level floating point parameter indices
*
      integer ctimer
      parameter (ctimer=1)
      integer rtimer
      parameter (rtimer=2)
      integer flopsr
      parameter (flopsr=3)
      integer zeta  
      parameter (zeta  =4)
      integer stptst
      parameter (stptst=5)
      integer alpha 
      parameter (alpha =6)
      integer relrsd
      parameter (relrsd=7)
      integer relerr
      parameter (relerr=8)
*
*     * accelerator-level floating point parameter indices
*
      integer ctimei
      parameter (ctimei=11)
      integer rtimei
      parameter (rtimei=12)
      integer flopsi
      parameter (flopsi=13)
*
*     * top-level floating point parameter indices
*
      integer ctimet
      parameter (ctimet=21)
      integer rtimet
      parameter (rtimet=22)
      integer flopst
      parameter (flopst=23)
*
*--------------------------warning codes--------------------------------
*
      integer wrnunk
      parameter (wrnunk=1)
      integer wrnnoc
      parameter (wrnnoc=2)
      integer wrnzet
      parameter (wrnzet=3)
      integer wrnstt
      parameter (wrnstt=4)
*
*---------------------------error codes---------------------------------
*
      integer errunk
      parameter (errunk=-1)
      integer erriiw
      parameter (erriiw=-2)
      integer errifw
      parameter (errifw=-3)
      integer errarg
      parameter (errarg=-4)
      integer errina
      parameter (errina=-5)
      integer errbdi
      parameter (errbdi=-6)
      integer errbdb
      parameter (errbdb=-7)
      integer errstg
      parameter (errstg=-8)
      integer errmdi
      parameter (errmdi=-9)
      integer errstp
      parameter (errstp=-10)
      integer errmat
      parameter (errmat=-11)
      integer errcom
      parameter (errcom=-12)
      integer errio
      parameter (errio=-13)
      integer errmem
      parameter (errmem=-14)
      integer errarr
      parameter (errarr=-15)
      integer errprc
      parameter (errprc=-16)
      integer errmvp
      parameter (errmvp=-17)
*
*-------------------other parameter definitions-------------------------
*
*     *---size if i/fparm arrays----------
      integer    niparm,           nfparm
      parameter (niparm=50, nfparm=30)
*     *---basic flags----------
      integer    yes          , no           , dfalt
      parameter (yes   =1   , no    =0    , dfalt =-1 )
*     *---preconditioner position----------
      integer    qnone        , qleft        , qright       
      parameter (qnone =0 , qleft =1 , qright=2)
      integer    qsplit
      parameter (qsplit=3)
*     *---u choices----------
      integer    uszero        , uzero         , unzero
      parameter (uszero=-2 , uzero =0  , unzero=1)
      integer    usrand         , uprand
      parameter (usrand=2 , uprand=3)
*     *---i/o level----------
      integer    lev0          , leverr        , levwrn
      parameter (lev0  =0   , leverr=1 , levwrn=2)
      integer    levit         , levprm        , levalg
      parameter (levit =3  , levprm=4 , levalg=5)
*     *---stopping test----------
      integer    tstusr
      parameter (tstusr=-3 )
      integer    tst0          , tstdfa        , tstexa
      parameter (tst0  =0   , tstdfa=-1 , tstexa=-2)
      integer    tstse         , tstsr
      parameter (tstse =1  , tstsr =2 )
      integer    tstslr        , tstsrr
      parameter (tstslr=3 , tstsrr=4)
      integer    tstre         , tstrr
      parameter (tstre =5  , tstrr =6 )
      integer    tstrlr        , tstrrr
      parameter (tstrlr=7 , tstrrr=8)
*     *---ijob choices----------
      integer    jirt          , jinit         , jinita
      parameter (jirt  =0   , jinit =1  , jinita=2)
      integer    jrun          , jruna         , jrunaq
      parameter (jrun  =3   , jruna =4  , jrunaq=5)
      integer    jtest         , jterm
      parameter (jtest =9  , jterm =-1)
      integer    jav           , jatv          , jqlv
      parameter (jav   =3    , jatv  =4   , jqlv  =5)
      integer    jqltv         , jqrv          , jqrtv
      parameter (jqltv =6  , jqrv  =7   , jqrtv =8)
*     *---matrix scaling choices----------
      integer    scnone        , scsd          , scld
      parameter (scnone=0 , scsd  =1   , scld  =2)
      integer    sclr
      parameter (sclr  =3)
*     *---gr format axis orders----------
      integer    orrg          , orgr
      parameter (orrg  = 0     , orgr  = 1)
      integer    orrcsg        , orrcgs
      parameter (orrcsg= 0     , orrcgs= 1)
      integer    orrscg        , orrsgc
      parameter (orrscg= 2     , orrsgc= 3)
      integer    orrgcs        , orrgsc
      parameter (orrgcs= 4     , orrgsc= 5)
      integer    orcrsg        , orcrgs
      parameter (orcrsg= 6     , orcrgs= 7)
      integer    orcsrg        , orcsgr
      parameter (orcsrg= 8     , orcsgr= 9)
      integer    orcgrs        , orcgsr
      parameter (orcgrs=10     , orcgsr=11)
      integer    orsrcg        , orsrgc
      parameter (orsrcg=12     , orsrgc=13)
      integer    orscrg        , orscgr
      parameter (orscrg=14     , orscgr=15)
      integer    orsgrc        , orsgcr
      parameter (orsgrc=16     , orsgcr=17)
      integer    orgrcs        , orgrsc
      parameter (orgrcs=18     , orgrsc=19)
      integer    orgcrs        , orgcsr
      parameter (orgcrs=20     , orgcsr=21)
      integer    orgsrc        , orgscr
      parameter (orgsrc=22     , orgscr=23)
*     *---gr format processor embeddings----------
      integer    grbin         , grgray
      parameter (grbin=0   , grgray=1)
*
*------------------------end include file pcg.h-------------------------
