************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
** ^ROUTINE: ivaxgr - Compute indexing polynomial for vector,
**                    Regular Grid format.
**                       (^)
**
************************************************************************
**
      integer function ivaxgr (ibr,is,vaxord,nb,ns,nsten)
**
************************************************************************
**
** ^DESCRIPTION:
**    Computes (1-based) indexing polynomial for matrix in regular
**    grid stencil format.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^ALGORITHM:
**
** ^REFERENCES:
**
** ^DOCUMENTATION:
**
** ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer  ibr
      integer  is
      integer  vaxord
      integer  nb, ns, nsten
*
      integer vaxeff
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: ivaxgr.fm4,v 1.3 1994/10/26 19:22:37 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      vaxeff = vaxord
         if (vaxeff .eq. -1) vaxeff = 1
*
      go to (101,102) 1+vaxeff
*
 101  continue
      ivaxgr = ibr + nb*(is -1)
      return
*
 102  continue
      ivaxgr = is  + ns*(ibr-1)
      return
*
      end
