************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
** ^ROUTINE: islice - integer function to map from an element number
**                    in the slice to an element number in the whole
**                    subgrid. (^)
**
************************************************************************
**
      integer function islice (ielt,ndim,nsg,nsl,ilb)
**
************************************************************************
**
** ^DESCRIPTION:
**    For each stencil point in a finite difference operator operating
**    over a rectangular subgrid, a perturbed grid is obtained that is
**    spread over upto 2**ndim subgrids (ndim is the number of
**    dimensions in the problem, = 2 for a 2D problem, etc.).
**    The portions of this perturbed subgrid that lie in each of the
**    2**ndim subgrids are referred to here as slices.
**    Given the integer ielt, which corresponds to the location of a
**    gridpoint in the slice by local natural ordering within the slice,
**    it returns an integer which corresponds to the location of the
**    same gridpoint according to natural ordering in the entire
**    subgrid.
**
** ^AUTHOR:   wdj@beta.lanl.gov
**
** ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: none
**    The subroutine xslice must be accessed before this slice to
**    determine data such as slice dimensions as well as location
**    with respect to the subgrid.
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for a more detailed description.
**
** ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
      integer ielt
      integer ndim
      integer nsg(*)
      integer nsl(*)
      integer ilb(*)
      integer i
      integer itmp
      integer inat
      integer imi(32)
      integer  imodf
      external imodf
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: islice.fm4,v 1.7 1994/07/20 18:20:26 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      itmp = ielt
      do 5500 i = 1, ndim
        imi(i) = imodf(itmp,nsl(i))
        itmp = (itmp-imi(i))/nsl(i)
5500  continue
       do 5501 i = 1, ndim
       imi(i) = imi(i) + ilb(i)
 5501  continue
      inat = imi(ndim)
      do 5502 i = ndim-1, 1, -1
        inat = inat*nsg(i) + imi(i)
5502  continue
      islice = inat
      return
      end
