************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WWRND - Routine to fill a vector with uniformly
**                    distributed random numbers between -1 and 1.
**                   (^)
**
************************************************************************
**
      subroutine dwrnd ( vo ,  iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    The elements of the vector vo are set equal to random numbers.
**    
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below. 
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
**  ^MACROS USED:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    BASICAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
*
      double precision       vo(*)
*
        integer ipme
        integer nproc
      integer nv
      integer i
      integer iseed
*
      external drndv
      double precision drndv
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: wrnd.fm4,v 1.3 1994/06/24 18:19:57 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      ipme  = 0
      nproc = 1
      nv = iparm(3)
*
         iseed = 1
*
       do 5500 i = 1, nv
       vo(i) = drndv (iseed)
 5500  continue
*
      return
      end
*-----------------------------------------------------------------------
      double precision function drndv (i)
*
* simple random number generator
*
      integer i
      integer n1, n2
      parameter (n1=16807,n2=57853)
*
         i = mod(n1*i,n2)
         drndv = (2.*(1d0*i)/n2-1.)
*
      return
      end
