************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WSATOP - Wrapper routine which calls suba with the
**                     appropriate (extended) argument list. (^)
**
************************************************************************
**
      subroutine dsatop ( subx, isetup,  ijob , ia , ja , a , vi , vo ,
     &       iwk , fwk , iparm , fparm , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Wrapper routine which calls subroutine sub with the appropriate
**    (extended) argument list, for the case when the package is called
**    from the top level.  In this case it is desirable to pass down
**    more information than for the simple accelerator-level interface.
**
**    This wrapper routine is used to keep the caller from
**    getting confused by two calls to suba with differing argument
**    lists.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       sub - local name of matrix-vector multiply routine
**             passed in as argument to this subroutine.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*     implicit character*1 (a-z)
*#    MVFFAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
      integer ia(*)
      integer ja(*)
      double precision a(*)
      double precision vi(*)
      double precision vo(*)
      integer  isetup
      external subx
*
      integer iptr
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: satop.fm4,v 1.10 1994/04/30 04:40:08 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      iptr          = iparm(11)
      iparm(11)   = iwk(iptr+isetup)
      call subx ( ijob , ia , ja , a , vi , vo ,
     &       iwk , fwk , iparm , fparm , ier )
      iwk(iptr+isetup) = iparm(11)
      iparm(11)   = iptr
           if (ier .lt. 0) go to 900
*
 900  continue
      return
      end
