************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WJAGRX - Preconditioning routine for Jabobi method
**            preconditioner, regular grid format. Solves a diagonal
**            system each time it is called, returns solution in vo.
**            (^)
**    
************************************************************************
**    
      subroutine djagrx ( ijob , ia , ja , a , vi , vo ,
     &       iwk , fwk , iparm , fparm , ier )
**    
************************************************************************
**    
**  ^DESCRIPTION: Preconditioning routine for Jacobi method
**     preconditioner, regular grid format. For IJOB
**     = 1/2 extract the diagonal of A, inverts, and stores it.
**     = 5 solves $Q_L$ vo = vi
**     = 6 solves $Q_L^*$ vo = vi
**     = 7 solves $Q_R$ vo = vi
**     = 8 solves $Q_R^*$ vo = vi
**
**  ^AUTHOR:   ak@c3.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: see External declerations below
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**    
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**   
************************************************************************
*
*     implicit character*1 (a-z)
*      
*#    MVFFAL            -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
      integer ia(*)
      integer ja(*)
      double precision a(*)
      double precision vi(*)
      double precision vo(*)
*
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
      integer  nv
      integer  ndim
      integer  nsten
      integer  nb
      integer  ns
      integer  imaxgr
      external imaxgr
      integer  ivaxgr
      external ivaxgr
      integer itab
      integer iq
      integer imdiag
      integer iaxis
      integer isten
      integer is
      integer ibr
      integer ibc
*
      double precision dmin
*
      external dwset
      external dhad0
      external dchad0
*
**#   NTAB - size of the saved table = 1
**#   IOFST - stencil offset extracted from ja
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: jagrx.fm4,v 1.7 1994/11/22 05:19:28 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
* Table semantics:
*         1 - pointer to Q_L (which is == Q_R)
*
*-----------------------------------------------------------------------
*
      itab = (iparm(6))
      iq = (iparm(6))
      ipme  = 0
      nproc = 1
      nv     = iparm(3     )
      ndim   = ia   (1 )
      nsten  = ia   (2)
      nb     = ia   (3   )
      ns     = nv / nb
*
*-----------------------------------------------------------------------
*-----------------------------init case---------------------------------
*-----------------------------------------------------------------------
*
      if ((ijob .eq. 1) .or. (ijob .eq. 2)) then
        if (iparm(2) .ge. 4) then       
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),*) '     Point Jacobi Preconditioner.'
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        endif
*
        call ximal (itab,1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        iparm(11) = itab
*
        if (iparm(13) .eq. 0) goto 900
*
        call dfmal (iq,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        iwk(itab+0) = iq
*
       do 5500 ibr = 1, nb
       do 5501 is = 1, ns
       fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 0d0
 5501  continue
 5500  continue
        imdiag = 0
        do 5502 isten = 1, nsten
          do 5503 iaxis = 1, ndim
            if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 10
5503  continue
          imdiag = 1
       do 5504 ibr = 1, nb
       do 5505 is = 1, ns
       fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) =
     &           fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) +
     &           a  (     imaxgr(ibr,ibr,isten,is,ia(4),nb,ns,nsten))
 5505  continue
 5504  continue
   10     continue
5502  continue
        if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'djagrx' , iparm ,
     &                        'No main diagonal' )
                go to 900
        endif
*
        dmin = (abs(fwk(iq-1+ivaxgr(1,1,ia(5),nb,ns,nsten))))
       do 5506 ibr = 1, nb
       do 5507 is = 1, ns
       dmin = min((dmin),
     &                    (abs(fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)
     &))))
 5507  continue
 5506  continue
        if ((dmin) .eq. (0d0)) then
                ier = -9
                call xersho ( ier, 'djagrx' , iparm , ' ' )
                go to 900
        endif
*
*
        if (iparm(13).eq.1 .or. iparm(13).eq.2) then
*
       do 5508 ibr = 1, nb
       do 5509 is = 1, ns
       fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 1d0 / 
     &           fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 5509  continue
 5508  continue
*
        else
       do 5510 ibr = 1, nb
       do 5511 is = 1, ns
       fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 1d0 /
     &           sqrt((abs(fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)))))
 5511  continue
 5510  continue
          fparm(13) = fparm(13) + (4d0*nb*ns)
*
        endif
*
        fparm(13) = fparm(13) + (4d0*nb*ns)
*
        go to 900  
*
      else
        itab = iparm(11)
        if (itab .eq. (iparm(6))) goto 900
        iq = iwk(itab+0)
      endif
*
*-----------------------------------------------------------------------
*-----------------------------apply case--------------------------------
*-----------------------------------------------------------------------
*
      if (ijob .eq. 5) then
        if ((iparm(13).eq.1).or.(iparm(13).eq.3)) then 
          call dhad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          fparm(13) = fparm(13) + (1d0*nb*ns)
          go to 900  
        else
          call dwset ( vo, vi ,  iparm , fparm , iwk , fwk , ier  )
          go to 900  
        endif
      endif
*
      if (ijob .eq. 7) then
        if ((iparm(13).eq.2).or.(iparm(13).eq.3)) then
          call dhad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          fparm(13) = fparm(13) + (1d0*nb*ns)
          go to 900  
        else
          call dwset ( vo, vi ,  iparm , fparm , iwk , fwk , ier  )
          go to 900  
        endif
      endif
*
      if (ijob .eq. 6) then
        if ((iparm(13).eq.1).or.(iparm(13).eq.3)) then
          if (iparm(42) .eq. 1) then
            call dchad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          else
            call dhad0  (nv, vo, 1, fwk(iq), 1, vi, 1)
          endif
          fparm(13) = fparm(13) + (1d0*nb*ns)
          go to 900  
        else
          call dwset ( vo, vi ,  iparm , fparm , iwk , fwk , ier  )
          go to 900  
        endif
      endif
* 
      if (ijob .eq. 8) then
        if ((iparm(13).eq.2).or.(iparm(13).eq.3)) then
          if (iparm(42) .eq. 1) then
            call dchad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          else
            call dhad0  (nv, vo, 1, fwk(iq), 1, vi, 1)
          endif
          fparm(13) = fparm(13) + (1d0*nb*ns)
          go to 900  
        else
          call dwset ( vo, vi ,  iparm , fparm , iwk , fwk , ier  )
          go to 900  
        endif
                ier = -5
                call xersho ( ier, 'djagrx' , iparm , ' ' )
                go to 900
      endif
*
      if (ijob .eq. -1) then
        go to 900  
      endif
*
*-----------------------------------------------------------------------
*-------------------------final termination-----------------------------
*-----------------------------------------------------------------------
*
 900  continue
*
      if (iparm(11) .eq. (iparm(6))) go to 910
*
      if ((ijob.eq.-1) .or. (ier .lt. 0)) then
        call dffre (iq,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call xifre (itab,1, iparm , fparm , iwk , fwk , ier )
        iparm(11) = (iparm(6))
      endif
*       
 910  continue
      return
      end
*-----------------------------------------------------------------------
