************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WITPUT - routine to print out the per-iteration output.
**                     (^)
**
************************************************************************
**
      subroutine ditput ( in , is ,  iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine prints an informative message (depending on the
**    output verbosity level requested) relevant to the current
**    iteration.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    BASICAL - (^)
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
      integer    in
      integer    is
        integer ipme
        integer nproc
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: itput.fm4,v 1.13 1994/09/28 19:24:19 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      if (iparm(2) .lt. 3) return
      ipme  = 0
      nproc = 1
*
      if (iparm(12) .eq. 0) then
        if (in .eq. 0) then
        write (iparm(1),'(/,a,/)') '     Run History:'
        write (iparm(1),'(a)') '         in         is'
**#       '         in         is       smin            smax')
        write (iparm(1),'(a)') '     --------------------'
**#       '     -------------------------------------------------')
        endif
        write (iparm(1),'(1x,i10,1x,i10,2(1x,1pe15.7))') in, is
**#                 FREAL(fparm(SMIN)),
**#                 FREAL(fparm(SMAX)))
      else
        if (in .eq. 0) then
        write (iparm(1),'(/,a,/)') '     Run History:'
        write (iparm(1),'(a)') '         in         is       stptst'
        write (iparm(1),'(a)') '     -----------------------------------
     &-'
        endif
        write (iparm(1),'(1x,i10,1x,i10,3(1x,1pe15.7))') in, is, (fparm(
     &5))
**#                 FREAL(fparm(SMIN)),
**#                 FREAL(fparm(SMAX)))
      endif
*
 900  continue
      return
      end
