************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WHOUSE - Routine to calculate Householder vector.
**                     (^)
**
************************************************************************
**
      subroutine dhouse (ix,ixind,ploc,eloc,iv,ivind,xmult,
     &                    iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    A Householder reflection vector (iv,ivind) is calculated based
**    on (ix,ixind).  The reflection transforms the vector to have
**    zeros except for the vector entry indicated by (ploc,eloc).
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    Gene Golub an Charles Van Loan, Matrix Computations, 2nd ed.,
**    Johns Hopkins Press, 1989, p. 196.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
      integer    ix
      integer    ixind
      integer    ploc
      integer    eloc
      integer    iv
      integer    ivind
      double precision      xmult
*
        integer ipme
        integer nproc
      double precision xdot
      double precision xnorm
      double precision xentry
      double precision sgn
      double precision vdot
      double precision beta
      double precision vnorm
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: house.fm4,v 1.1 1994/06/13 22:10:16 joubert Exp $
*     $Revision: 1.0 $
*     $Log: house.fm4,v $
************************************************************************
*
      ipme  = 0
      nproc = 1
*
          call dwrdot (xdot,fwk(ix+iparm(3)*(ixind)),
     &    fwk(ix+iparm(3)*(ixind)),  iparm , fparm , iwk , fwk , ier  )
      xnorm = sqrt(xdot)
*
      if (xnorm .eq. 0d0) then
        xentry = 0d0
        beta = 1d0
        xmult = 0d0
          call dwfil (fwk(iv+iparm(3)*(ivind)),0d0,
     &     iparm , fparm , iwk , fwk , ier  )
      else
          call dwgete (fwk(ix+iparm(3)*(ixind)),ploc,eloc,ploc,eloc,xent
     &ry,
     &     iparm , fparm , iwk , fwk , ier  )
        if (xentry .eq. 0d0) then
          sgn = 1d0
        else
          sgn = +xentry/abs(xentry)
        endif
*       ---do it----------
        beta = xentry + sgn*xnorm
          call dwscl ( fwk(iv+iparm(3)*(ivind)), fwk(ix+iparm(3)*(ixind)
     &), 1d0/beta,  iparm , fparm , iwk , fwk , ier  )
        xmult = -sgn*xnorm
      endif
*
          call dwsete (fwk(iv+iparm(3)*(ivind)),ploc,eloc,ploc,eloc,1d0,
     &     iparm , fparm , iwk , fwk , ier  )
*
*     ---get normsq of new vector v----------
      vdot = 1d0 + (xdot-(xentry)*xentry)/((beta)*beta)
      vnorm = sqrt(vdot)
      if (vnorm .ne. 0d0) then
          call dwscl ( fwk(iv+iparm(3)*(ivind)), fwk(iv+iparm(3)*(ivind)
     &), 1d0/vnorm,  iparm , fparm , iwk , fwk , ier  )
      endif
*
 900  continue
*
      return
      end
*-----------------------------------------------------------------------
