************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WCKSTG - routine to check for stagnation of the iterative
**                     method. (^)
**
************************************************************************
**
      subroutine dckstg ( iclstg, iwkstg,  iparm , fparm , iwk , fwk , i
     &er  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    This routine is called in association with the stopping test.
**    The current convergence parameter stptst is monitored from
**    iteration to iteration, and if it does not change appreciably
**    for a sequence of iterations, stagnation is flagged and,
**    depending on the appropriate iparm setting, an error return
**    occurs.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*     implicit character*1 (a-z)
*#    BASICAL - (^)
      integer ier
      integer iwk(*)
      integer iparm(*)
      double precision       fwk(*)
      double precision       fparm(*)
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
      integer    iclstg
      integer    iwkstg
      integer    i
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: ckstg.fm4,v 1.15 1994/09/28 19:24:17 joubert Exp $
*     $Revision: 1.15 $
************************************************************************
*
      if (iparm(12) .eq. 0) return
*
      if (iparm(18) .eq. 0) return
*
      if (iclstg .eq. 1) then
        call dfmal (iwkstg,20, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      endif
*
      if (iclstg .eq. -1) then
        call dffre (iwkstg,20, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        go to 900
      endif
*
      if (iclstg .lt. 20) go to 100
      do 5500 i = iclstg-1, iclstg-20+1, -1
        if ((abs(fwk(iwkstg+mod(i,20))-fparm(5)))
     &      .gt. 1.e-4*(fparm(5))) go to 100
5500  continue
*
                ier = -8
                call xersho ( ier, 'dckstg' , iparm , ' ' )
                go to 900
*
 100  continue
*
      fwk(iwkstg+mod(iclstg,20)) = fparm(5)
      iclstg = iclstg + 1
*
 900  continue
*
      return
      end
