************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WWGETE - Routine to get an entry of a vector. (^)
**
************************************************************************
**
      subroutine cwgete ( v , procb, entryb, proce, entrye, values,
     &                    iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below. 
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**    
**  ^ALGORITHM:
**    
**  ^REFERENCES:
**    
**  ^DOCUMENTATION:
**    
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
**  ^MACROS USED:
**
************************************************************************
*
*     implicit character*1 (a-z)
*#    BASICAL             -
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
      integer iwk(*)
      integer iparm(*)
      complex       fwk(*)
      complex       fparm(*)
      integer procb
      integer entryb
      integer proce
      integer entrye
      complex       v(*)
      complex values(*)
*
        integer ipme
        integer nproc
      integer ibeg, iend, iproc, size, itmp, icomwk, iptr, i
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: wgete.fm4,v 1.2 1994/11/22 05:18:57 joubert Exp $
************************************************************************
*
      ipme  = 0
      nproc = 1
      icomwk = (iparm(6))
*
      if (procb.lt.0 .or. procb.gt.nproc-1) goto 900
      if (proce.lt.0 .or. proce.gt.nproc-1) goto 900
*
      if (ipme .eq. procb) then
        ibeg = entryb
      else if (ipme .gt. procb) then
        ibeg = 1
      else
        ibeg = iparm(3) + 1
      endif
      if (ipme .eq. proce) then
        iend = entrye
      else if (ipme .lt. proce) then
        iend = iparm(3)
      else
        iend = 0
      endif
*
       do 5500 i = ibeg, iend
       values(1+i-ibeg) = v(i)
 5500  continue
*
 900  continue
*
      return
      end
