************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WWDOT - Routine to take dot products.  Can be called as
**                       wcdot, wrdot, or wdot.  The first, wcdot, takes
**                       the actual or pseudo dot product based on the
**                       passed variable idot.  The second, wrdot,
**                       computes the real part of the dot product.  The
**                       third, wdot, calculates the actual dot product
**                       only.
**
************************************************************************
**
      subroutine cwdot ( c , y , x , 
     &                      iparm , fparm , iwk , fwk , ier  )
**
************************************************************************
**
**  ^DESCRIPTION:
**    wcdot - Compute either the true dot product (c =y^{*} x), or a
**    pseudo dot product (c =y^{T} x) which uses the transpose rather
**    than the conjugate transpose of the left vector. The subroutine
**    argument idot is used to toggle between taking the actual
**    (idot = 1) and pseudo (idot = 0) dot product.  In the calling
**    program idot is normally set in the iparm varialbe iparm(IDOT).
**
**   wdot - Ccompute the true dot product (c =y^{*} x).
**
**   wrdot - Compute the real part of the (actual) dot product 
**    (c = y^{*} x) of two vectors.  
**
**    These three routines are part of the Low-level level-1 BLAS-type
**    routine required by pcg package.  Written for Sun, Cray YMP, and
**    generic f77; as set by m4 variable MACHINE.  On a Cray YMP the
**    vector is partitioned out to all available processors.  The
**    partitioning is done using compiler directives, thus the compiler
**    decides how the partitioning is done.
**      
**  ^AUTHOR:   wdj@beta.lanl.gov
**    
**  ^MODIFIED: aal@marvin.ae.utexas.edu on Mon Nov  8 22:02:42 1993 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below. 
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**    During complex computations when calculation of only the
**    real part of the dot product is requested, the global add need
**    only be done on the real part of c, however, it is now done on
**    both the real and imaginary parts, requiring extra communications
**    work.
**    
**  ^ALGORITHM:
**    Euclidean inner product
**    
**  ^REFERENCES:
**    
**  ^DOCUMENTATION:
**      
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
**  ^MACROS USED:
**
************************************************************************
*
*     implicit character*1 (a-z)
*      
*#    BASICAL             (^)
**
      integer ier
      integer iwk(*)
      integer iparm(*)
      complex       fwk(*)
      complex       fparm(*)
      complex       y(*)
      complex       x(*)
          complex c
*
          complex sum
      integer nv
      integer i
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: dot_template.m4,v 1.6 1994/07/15 19:43:42 joubert Exp $
*     $Revision: 1.0 $
*     $Log: dot_template.m4,v $
************************************************************************
*
      nv = iparm(3)
*
            sum = (0e0,0.0e0)
      do 5500 i = 1, nv
                    sum = sum + conjg(y(i))*x(i)
5500  continue
*
              c = sum
*
          fparm(3) = fparm(3) + (8.*nv)
*
*
 900  continue
      return
      end
