************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WTFQFR - Reverse communication level routine for Freund's
**                     transpose free QMR algorithm. (^)
**
************************************************************************
**
      subroutine ctfqfr ( ijob , ireq ,
     &       u , uexact , b ,
     &       iva , ivql , ivqr ,
     &       iwk , fwk , iparm , fparm , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**   Preconditioned transpose free QMR routine
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    TFQMR
**
**  ^REFERENCES:
**    R. W. Freund, ``A Transpose-Free Quasi-Minimal Residual
**    Algorithm for Non-Hermitian Linear Systems,'' {\sl SIAM
**    J. Sci. Stat. Comput.}
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
      integer iwk(*)
      integer iparm(*)
      complex       fwk(*)
      complex       fparm(*)
      complex u(*)
      complex uexact(*)
      complex b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer    iitab
      integer    iftab
      integer    iwkstg
      integer    iclstg
      integer    in
      integer    is
      integer    iretlb
      integer    ivitmp, ivotmp
      integer    iv1tst, iv2tst
      integer    istab1, istab2, istab
      integer    ib1,ib2, iu1,iu2
      integer    iud
      parameter (iud  =0)
      integer    ibd
      parameter (ibd  =1)
      integer    ilbd
      parameter (ilbd =2)
      integer    irlbd
      parameter (irlbd=3)
      integer    ied
      parameter (ied  =4)
      integer    ird
      parameter (ird  =5)
      integer    ilrd
      parameter (ilrd =6)
      integer    irlrd
      parameter (irlrd=7)
      complex      urndf
      complex      top
      complex      bot
      parameter (urndf=.1)
      complex      mydot1, mydot2
      external   cargck
      external   cckstg
      external   cwrnd
      external   cifppr
      external   citput
      external   xtimer
        integer ipme
        integer nproc
      external ximini
      external ximal
      external xifre
      external cfmini
      external cfmal
      external cffre
*     integer imv1, imv2
      integer    irt
      integer    ir
      integer    iqlr
      integer    iqrqlr
*
      integer    iqlw
      integer    iqrqlw
*
      integer    iqlv
      integer    iqrqlv
*
      integer    iry
      integer    iary
      integer    ilary
      integer    irlary
*
      integer    irdd
      integer    iard
      integer    ilard
      integer    irlard
*
      integer    iv1
      integer    iv2
      complex      rdot
      complex      rnorm
      complex      r0norm
      complex      tau
      complex      theta
      complex      eta
      complex      sigma
      complex      alpha
      complex      beta
      complex      c
      complex      rho
      complex      rhoold
      complex      uudot, uexdt
*
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: tfqfr.fm4,v 1.9 1994/11/22 05:20:46 joubert Exp $
*     $Revision: 1.0 $
*     $Log: tfqfr.fm4,v $
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      irt = (iparm(6))
      iqlw = (iparm(6))
      iqrqlw = (iparm(6))
      iqlv = (iparm(6))
      iqrqlv = (iparm(6))
      iry = (iparm(6))
      iary = (iparm(6))
      ilary = (iparm(6))
      irlary = (iparm(6))
      irdd = (iparm(6))
      iard = (iparm(6))
      ilard = (iparm(6))
      irlard = (iparm(6))
      iv1 = (iparm(6))
      iv2 = (iparm(6))
*
*     *---go to the brancher unless this is the init call---
      if (ijob .ne. 1) go to 1000
*
*     *---inits----------
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
*     *---initialize pointers----------
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
*     *---initialize----------
      ipme  = 0
      nproc = 1
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
*       *---init integer memory----------
        call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---init floating point memory----------
        call cfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
*       *---check arguments----------
        call cargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*       *---initialize timer----------
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
*     *---start timer------
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
*     *---print i/fparm if requested----------
      if (iparm(27) .eq. 0) then
        call cifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
*     *---reserve place to save integer and float variables----------
*     *---across revcom calls----------
      call ximal (iitab,37, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iftab,14, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/''     Transpose Free QMR Method (Freund Vers
     &ion).''/)') 
      endif
*
      call cfmal (irt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqlv,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irdd,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iry,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilard,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilary,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call cfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (iard,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (iary,iparm(3)*(2), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
        endif
      else
        ir   = iqlr
        iary = ilary
        iard = ilard
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cfmal (iqrqlv,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (iqrqlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (irlard,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cfmal (irlary,iparm(3)*(2), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
        endif
      else
        iqrqlv = iqlv
        iqrqlw = iqlw
        iqrqlr = iqlr
        irlard = ilard
        irlary = ilary
      endif
      call cfmal (iv1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iv2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
*     *---set u to zero----------
      if (iparm(14) .eq. -2
     &    ) then
          call cwfil (u,(0e0,0.0e0),
     &     iparm , fparm , iwk , fwk , ier  )
      endif
*
*     *---random u----------
      if (iparm(14) .eq. 2
     &    .or. iparm(14) .eq. -1) go to 5500
                 go to 5501
 5500  continue
          call cwrdot (mydot1,b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
        call cwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2000
        go to 1500
 2000   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwrdot (mydot2,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call cwscl ( u, u, urndf*sqrt(mydot1/mydot2),  iparm , fparm ,
     & iwk , fwk , ier  )
                go to 5502
 5501 continue
 5502 continue
*
*     *---random u perturbation----------
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2001
        go to 1500
 2001   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call cwrdot (mydot1,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iv1),u,
     &     iparm , fparm , iwk , fwk , ier  )
        call cwrnd (u,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv2 
         ireq = 3
        iretlb = 2002
        go to 1500
 2002   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwrdot (mydot2,fwk(iv2),
     &    fwk(iv2),  iparm , fparm , iwk , fwk , ier  )
          call cwsax (u,fwk(iv1),
     &    u, -urndf*sqrt(mydot1/mydot2),  iparm , fparm , iwk , fwk , ie
     &r  )
                go to 5505
 5504 continue
 5505 continue
*
*     *---begin iteration statistics calculation----------
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
        call cfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call cwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call cwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5511
 5510 continue
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2003
        go to 1500
 2003   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5511 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call cwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5514
 5513 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2004
        go to 1500
 2004   continue
         if (ijob .eq. -1) go to 900
 5514 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call cwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2005
        go to 1500
 2005   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call cwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call cwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5517
 5516 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2006
        go to 1500
 2006   continue
         if (ijob .eq. -1) go to 900
 5517 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call cwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5520
 5519 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2007
        go to 1500
 2007   continue
         if (ijob .eq. -1) go to 900
 5520 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Initial iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*     *---end iteration statistics calculation----------
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5527
                 go to 5528
 5527  continue
          call cwset (fwk(ir),b,
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          call cwset (fwk(iqlr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5532
 5531 continue
          iva = ir 
          ivql = iqlr 
         ireq = 5
        iretlb = 2008
        go to 1500
 2008   continue
         if (ijob .eq. -1) go to 900
 5532 continue
*        *---end revcom precon----------
                go to 5529
 5528 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call cwset (fwk(iqlr),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5535
 5534 continue
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iqlr 
         ireq = 5
        iretlb = 2009
        go to 1500
 2009   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5535 continue
*        *---end revcom precon----------
 5529 continue
                go to 5526
 5525 continue
          call cwset (fwk(iqlr),b,
     &     iparm , fparm , iwk , fwk , ier  )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5539
                 go to 5540
 5539  continue
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ir 
         ireq = 3
        iretlb = 2010
        go to 1500
 2010   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(ir),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call cwset (fwk(iqlr),fwk(ir),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5544
 5543 continue
          iva = ir 
          ivql = iqlr 
         ireq = 5
        iretlb = 2011
        go to 1500
 2011   continue
         if (ijob .eq. -1) go to 900
 5544 continue
*        *---end revcom precon----------
                go to 5541
 5540 continue
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iv1 
         ireq = 3
        iretlb = 2012
        go to 1500
 2012   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(iv1),
     &    b, fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5545
                 go to 5546
 5545  continue
          call cwset (fwk(iqlr),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5547
 5546 continue
          iva = iv1 
          ivql = iqlr 
         ireq = 5
        iretlb = 2013
        go to 1500
 2013   continue
         if (ijob .eq. -1) go to 900
 5547 continue
*        *---end revcom precon----------
 5541 continue
                go to 5538
 5537 continue
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = iqlr 
         ireq = 3
        iretlb = 2014
        go to 1500
 2014   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(iqlr),
     &    b, fwk(ir),  iparm , fparm , iwk , fwk , ier  )
 5538 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5548
                 go to 5549
 5548  continue
        if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5551
                 go to 5552
 5551  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5554
                 go to 5555
 5554  continue
          call cwset (fwk(iqrqlr),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5556
 5555 continue
          ivql = iqlr 
          ivqr = iqrqlr 
         ireq = 7
        iretlb = 2015
        go to 1500
 2015   continue
         if (ijob .eq. -1) go to 900
 5556 continue
*        *---end revcom precon----------
                go to 5553
 5552 continue
 5553 continue
                go to 5550
 5549 continue
 5550 continue
*
          call cwrdot (rdot,fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
      rnorm  = sqrt(abs(rdot))
      r0norm = rnorm
*
*---------------------------iteration loop------------------------------
*
 100  continue
*
        if (iparm(2) .ge. 5) then
        write (iparm(1),500) 'rnorm               ', rnorm
        endif
*
*     *---begin user stopping test----------
        if (iparm(12).eq.-3) go to 5557
                 go to 5558
 5557  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir 
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr 
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr 
          endif
          ireq   = 9
        iretlb = 2016
        go to 1500
 2016   continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call citput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        write (iparm(1),'(/a/)') ' User-requested termination of iterati
     &ve method.'
            endif
            go to 900
          endif
                go to 5559
 5558 continue
 5559 continue
        if (iparm(12) .gt. 1) go to 5560
                 go to 5561
 5560  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
              endif
          call cwdot (bot, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            endif
            call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier
     & )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call cwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
            call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call cwdot (bot, b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
            endif
          call cwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
          endif
          if (iparm(12) .eq. 3) go to 5563
                 go to 5564
 5563  continue
            if (iparm(5) .eq. 0) go to 5566
                 go to 5567
 5566  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5569
                 go to 5570
 5569  continue
          call cwdot (bot, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5571
 5570 continue
                call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5572
                 go to 5573
 5572  continue
          call cwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5574
 5573 continue
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2017
        go to 1500
 2017   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5574 continue
*        *---end revcom precon----------
          call cwdot (bot, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
                call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5571 continue
                go to 5568
 5567 continue
 5568 continue
          call cwdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5565
 5564 continue
 5565 continue
          if (iparm(12) .eq. 4) go to 5575
                 go to 5576
 5575  continue
            if (iparm(5) .eq. 0) go to 5578
                 go to 5579
 5578  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5581
                 go to 5582
 5581  continue
          call cwdot (bot, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5583
 5582 continue
                call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
                call cfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk ,
     & ier )
           if (ier .lt. 0) go to 900
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call cwset (fwk(iv1tst),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5586
 5585 continue
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = iv1tst 
         ireq = 5
        iretlb = 2018
        go to 1500
 2018   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
         if (ijob .eq. -1) go to 900
 5586 continue
*        *---end revcom precon----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5587
                 go to 5588
 5587  continue
          call cwset (fwk(iv2tst),fwk(iv1tst),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5589
 5588 continue
          ivql = iv1tst 
          ivqr = iv2tst 
         ireq = 7
        iretlb = 2019
        go to 1500
 2019   continue
         if (ijob .eq. -1) go to 900
 5589 continue
*        *---end revcom precon----------
          call cwdot (bot, fwk(iv2tst),
     &    fwk(iv2tst),  iparm , fparm , iwk , fwk , ier  )
                call cffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
                call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , f
     &wk , ier )
           if (ier .lt. 0) go to 900
 5583 continue
                go to 5580
 5579 continue
 5580 continue
          call cwdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5577
 5576 continue
 5577 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        '19 and 12 incompatible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call cwdot (top, uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
            else
              call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , i
     &er )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call cwdot (top, fwk(iv1tst),
     &    fwk(iv1tst),  iparm , fparm , iwk , fwk , ier  )
              call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk
     & , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call cwdot (top, fwk(ir),
     &    fwk(ir),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call cwdot (top, fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call cwdot (top, fwk(iqrqlr),
     &    fwk(iqrqlr),  iparm , fparm , iwk , fwk , ier  )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (real(top) .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (real(bot) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(top)/real(bot))
          call citput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
                go to 5562
 5561 continue
 5562 continue
*     *---end user stopping test----------
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. (0e0,0.0e0)) then
                ier = -10
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call citput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*
*       *---begin exact stopping test----------
        if (iparm(12) .eq. -2) then
          call cwsub ( fwk(iv1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call cwrdot (uudot,fwk(iv1),
     &    fwk(iv1),  iparm , fparm , iwk , fwk , ier  )
          call cwrdot (uexdt,uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
          if (real(uudot)  .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Attempt to take sqrt of negative number' 
     &)
                go to 900
          endif
          if (real(uexdt) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Attempt to divide by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(uudot)/real(uexdt))
          call citput ( in , is ,  iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*       *---end exact stopping test----------
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
          go to 900
        endif
*
        if (iparm(18) .ne. -1) then
          call cckstg ( iclstg, iwkstg,  iparm , fparm , iwk , fwk , ier
     &  )
           if (ier .lt. 0) go to 900
        endif
*
*-----------------------proceed with iteration--------------------------
*
        if (in .eq. 0) go to 5590
                 go to 5591
 5590  continue
          call cwset (fwk(irt ),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iqlw),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwset (fwk(iqrqlw),fwk(iqrqlr),
     &     iparm , fparm , iwk , fwk , ier  )
            endif
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5596
                 go to 5597
 5596  continue
          call cwset (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iqrqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5598
 5597 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5599
                 go to 5600
 5599  continue
          call cwset (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5601
 5600 continue
          ivql = iqlr 
          ivqr = iry + iparm(3)*((mod((in),2)))
         ireq = 7
        iretlb = 2020
        go to 1500
 2020   continue
         if (ijob .eq. -1) go to 900
 5601 continue
*        *---end revcom precon----------
 5598 continue
                go to 5595
 5594 continue
          call cwset (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iqlr),
     &     iparm , fparm , iwk , fwk , ier  )
 5595 continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
            if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5605
                 go to 5606
 5605  continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = iary + iparm(3)*((mod((in),2)))
         ireq = 3
        iretlb = 2021
        go to 1500
 2021   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in),2)))),fwk(iary+iparm
     &(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5610
 5609 continue
          iva = iary + iparm(3)*((mod((in),2)))
          ivql = ilary + iparm(3)*((mod((in),2)))
         ireq = 5
        iretlb = 2022
        go to 1500
 2022   continue
         if (ijob .eq. -1) go to 900
 5610 continue
*        *---end revcom precon----------
                go to 5607
 5606 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = iv1 
         ireq = 3
        iretlb = 2023
        go to 1500
 2023   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5611
                 go to 5612
 5611  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in),2)))),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5613
 5612 continue
          iva = iv1 
          ivql = ilary + iparm(3)*((mod((in),2)))
         ireq = 5
        iretlb = 2024
        go to 1500
 2024   continue
         if (ijob .eq. -1) go to 900
 5613 continue
*        *---end revcom precon----------
 5607 continue
                go to 5604
 5603 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = ilary + iparm(3)*((mod((in),2)))
         ireq = 3
        iretlb = 2025
        go to 1500
 2025   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5604 continue
          call cwset (fwk(iqlv),fwk(ilary+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5614
                 go to 5615
 5614  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5617
                 go to 5618
 5617  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5620
                 go to 5621
 5620  continue
          call cwset (fwk(irlary+iparm(3)*((mod((in),2)))),fwk(ilary+ipa
     &rm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5622
 5621 continue
          ivql = ilary + iparm(3)*((mod((in),2)))
          ivqr = irlary + iparm(3)*((mod((in),2)))
         ireq = 7
        iretlb = 2026
        go to 1500
 2026   continue
         if (ijob .eq. -1) go to 900
 5622 continue
*        *---end revcom precon----------
          call cwset (fwk(iqrqlv),fwk(irlary+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5619
 5618 continue
 5619 continue
                go to 5616
 5615 continue
 5616 continue
          tau = r0norm
          call cwdot (rho, fwk(irt),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
                go to 5592
 5591 continue
 5592 continue
*
        if (mod(in,2).eq.0 .and. in.ne.0) go to 5623
                 go to 5624
 5623  continue
          rhoold = rho
          call cwdot (rho, fwk(irt),
     &    fwk(iqlw),  iparm , fparm , iwk , fwk , ier  )
          if (rhoold .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
                go to 900
          endif
          beta = rho / rhoold
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5626
                 go to 5627
 5626  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5629
                 go to 5630
 5629  continue
          call cwsax (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iqrqlw),
     &    fwk(iry+iparm(3)*((mod((in-1),2)))), beta,  iparm , fparm , iw
     &k , fwk , ier  )
                go to 5631
 5630 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5632
                 go to 5633
 5632  continue
          call cwset (fwk(iv1),fwk(iqlw),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5634
 5633 continue
          ivql = iqlw 
          ivqr = iv1 
         ireq = 7
        iretlb = 2027
        go to 1500
 2027   continue
         if (ijob .eq. -1) go to 900
 5634 continue
*        *---end revcom precon----------
          call cwsax (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iv1),
     &    fwk(iry+iparm(3)*((mod((in-1),2)))), beta,  iparm , fparm , iw
     &k , fwk , ier  )
 5631 continue
                go to 5628
 5627 continue
          call cwsax (fwk(iry+iparm(3)*((mod((in),2)))),fwk(iqrqlw),
     &    fwk(iry+iparm(3)*((mod((in-1),2)))), beta,  iparm , fparm , iw
     &k , fwk , ier  )
 5628 continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5635
                 go to 5636
 5635  continue
            if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5638
                 go to 5639
 5638  continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = iary + iparm(3)*((mod((in),2)))
         ireq = 3
        iretlb = 2028
        go to 1500
 2028   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5641
                 go to 5642
 5641  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in),2)))),fwk(iary+iparm
     &(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5643
 5642 continue
          iva = iary + iparm(3)*((mod((in),2)))
          ivql = ilary + iparm(3)*((mod((in),2)))
         ireq = 5
        iretlb = 2029
        go to 1500
 2029   continue
         if (ijob .eq. -1) go to 900
 5643 continue
*        *---end revcom precon----------
                go to 5640
 5639 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = iv1 
         ireq = 3
        iretlb = 2030
        go to 1500
 2030   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5644
                 go to 5645
 5644  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in),2)))),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5646
 5645 continue
          iva = iv1 
          ivql = ilary + iparm(3)*((mod((in),2)))
         ireq = 5
        iretlb = 2031
        go to 1500
 2031   continue
         if (ijob .eq. -1) go to 900
 5646 continue
*        *---end revcom precon----------
 5640 continue
                go to 5637
 5636 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in),2)))
          iva = ilary + iparm(3)*((mod((in),2)))
         ireq = 3
        iretlb = 2032
        go to 1500
 2032   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5637 continue
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5647
                 go to 5648
 5647  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5650
                 go to 5651
 5650  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5653
                 go to 5654
 5653  continue
          call cwset (fwk(irlary+iparm(3)*((mod((in),2)))),fwk(ilary+ipa
     &rm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5655
 5654 continue
          ivql = ilary + iparm(3)*((mod((in),2)))
          ivqr = irlary + iparm(3)*((mod((in),2)))
         ireq = 7
        iretlb = 2033
        go to 1500
 2033   continue
         if (ijob .eq. -1) go to 900
 5655 continue
*        *---end revcom precon----------
                go to 5652
 5651 continue
 5652 continue
                go to 5649
 5648 continue
 5649 continue
          call cwsax (fwk(iqlv),fwk(ilary+iparm(3)*((mod((in-1),2)))),
     &    fwk(iqlv), beta,  iparm , fparm , iwk , fwk , ier  )
          call cwsax (fwk(iqlv),fwk(ilary+iparm(3)*((mod((in  ),2)))),
     &    fwk(iqlv), beta,  iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwsax (fwk(iqrqlv),fwk(irlary+iparm(3)*((mod((in-1),2))))
     &,
     &    fwk(iqrqlv), beta,  iparm , fparm , iwk , fwk , ier  )
          call cwsax (fwk(iqrqlv),fwk(irlary+iparm(3)*((mod((in  ),2))))
     &,
     &    fwk(iqrqlv), beta,  iparm , fparm , iwk , fwk , ier  )
            endif
          endif
                go to 5625
 5624 continue
 5625 continue
*
        if (mod(in,2) .eq. 0) go to 5656
                 go to 5657
 5656  continue
          call cwdot (sigma, fwk(irt),
     &    fwk(iqlv),  iparm , fparm , iwk , fwk , ier  )
          if (sigma .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
                go to 900
          endif
          alpha = rho / sigma
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5659
                 go to 5660
 5659  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5662
                 go to 5663
 5662  continue
          call cwsax (fwk(iry+iparm(3)*((mod((in+1),2)))),fwk(iry+iparm(
     &3)*((mod((in),2)))),
     &    fwk(iqrqlv), -alpha,  iparm , fparm , iwk , fwk , ier  )
                go to 5664
 5663 continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5665
                 go to 5666
 5665  continue
          call cwset (fwk(iv1),fwk(iqlv),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5667
 5666 continue
          ivql = iqlv 
          ivqr = iv1 
         ireq = 7
        iretlb = 2034
        go to 1500
 2034   continue
         if (ijob .eq. -1) go to 900
 5667 continue
*        *---end revcom precon----------
          call cwsax (fwk(iry+iparm(3)*((mod((in+1),2)))),fwk(iry+iparm(
     &3)*((mod((in),2)))),
     &    fwk(iv1), -alpha,  iparm , fparm , iwk , fwk , ier  )
 5664 continue
                go to 5661
 5660 continue
          call cwsax (fwk(iry+iparm(3)*((mod((in+1),2)))),fwk(iry+iparm(
     &3)*((mod((in),2)))),
     &    fwk(iqrqlv), -alpha,  iparm , fparm , iwk , fwk , ier  )
 5661 continue
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5668
                 go to 5669
 5668  continue
            if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) go to 5671
                 go to 5672
 5671  continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in+1),2)))
          iva = iary + iparm(3)*((mod((in+1),2)))
         ireq = 3
        iretlb = 2035
        go to 1500
 2035   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5674
                 go to 5675
 5674  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in+1),2)))),fwk(iary+ipa
     &rm(3)*((mod((in+1),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5676
 5675 continue
          iva = iary + iparm(3)*((mod((in+1),2)))
          ivql = ilary + iparm(3)*((mod((in+1),2)))
         ireq = 5
        iretlb = 2036
        go to 1500
 2036   continue
         if (ijob .eq. -1) go to 900
 5676 continue
*        *---end revcom precon----------
                go to 5673
 5672 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in+1),2)))
          iva = iv1 
         ireq = 3
        iretlb = 2037
        go to 1500
 2037   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5677
                 go to 5678
 5677  continue
          call cwset (fwk(ilary+iparm(3)*((mod((in+1),2)))),fwk(iv1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5679
 5678 continue
          iva = iv1 
          ivql = ilary + iparm(3)*((mod((in+1),2)))
         ireq = 5
        iretlb = 2038
        go to 1500
 2038   continue
         if (ijob .eq. -1) go to 900
 5679 continue
*        *---end revcom precon----------
 5673 continue
                go to 5670
 5669 continue
*        *---begin revcom matvec----------
          ivqr = iry + iparm(3)*((mod((in+1),2)))
          iva = ilary + iparm(3)*((mod((in+1),2)))
         ireq = 3
        iretlb = 2039
        go to 1500
 2039   continue
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
 5670 continue
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5680
                 go to 5681
 5680  continue
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) go to 5683
                 go to 5684
 5683  continue
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5686
                 go to 5687
 5686  continue
          call cwset (fwk(irlary+iparm(3)*((mod((in+1),2)))),fwk(ilary+i
     &parm(3)*((mod((in+1),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5688
 5687 continue
          ivql = ilary + iparm(3)*((mod((in+1),2)))
          ivqr = irlary + iparm(3)*((mod((in+1),2)))
         ireq = 7
        iretlb = 2040
        go to 1500
 2040   continue
         if (ijob .eq. -1) go to 900
 5688 continue
*        *---end revcom precon----------
                go to 5685
 5684 continue
 5685 continue
                go to 5682
 5681 continue
 5682 continue
                go to 5658
 5657 continue
 5658 continue
*
          call cwsax (fwk(iqlw),fwk(iqlw),
     &    fwk(ilary+iparm(3)*((mod((in),2)))), -alpha,  iparm , fparm , 
     &iwk , fwk , ier  )
        if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwsax (fwk(iqrqlw),fwk(iqrqlw),
     &    fwk(irlary+iparm(3)*((mod((in),2)))), -alpha,  iparm , fparm ,
     & iwk , fwk , ier  )
          endif
        endif
        if (in .eq. 0) then
          call cwset (fwk(irdd),fwk(iry+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call cwset (fwk(iard),fwk(iary+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
            endif
          endif
          call cwset (fwk(ilard),fwk(ilary+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwset (fwk(irlard),fwk(irlary+iparm(3)*((mod((in),2)))),
     &     iparm , fparm , iwk , fwk , ier  )
            endif
          endif
        else
          if (alpha .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
                go to 900
          endif
          call cwsax (fwk(irdd),fwk(iry+iparm(3)*((mod((in),2)))),
     &    fwk(irdd), (theta**2*eta/alpha),  iparm , fparm , iwk , fwk , 
     &ier  )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call cwsax (fwk(iard),fwk(iary+iparm(3)*((mod((in),2)))),
     &    fwk(iard), (theta**2*eta/alpha),  iparm , fparm , iwk , fwk , 
     &ier  )
            endif
          endif
          call cwsax (fwk(ilard),fwk(ilary+iparm(3)*((mod((in),2)))),
     &    fwk(ilard), (theta**2*eta/alpha),  iparm , fparm , iwk , fwk ,
     & ier  )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
            if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwsax (fwk(irlard),fwk(irlary+iparm(3)*((mod((in),2)))),
     &    fwk(irlard), (theta**2*eta/alpha),  iparm , fparm , iwk , fwk 
     &, ier  )
            endif
          endif
        endif
          call cwrdot (theta,fwk(iqlw),
     &    fwk(iqlw),  iparm , fparm , iwk , fwk , ier  )
        if (tau .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
                go to 900
        endif
        theta = sqrt(theta) / tau
        c = sqrt((1e0,0.0e0)+theta**2)
        if (c .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ctfqfr' , iparm , ' ' )
                go to 900
        endif
        c = (1e0,0.0e0)/c
        tau = tau*theta*c
        eta = c**2 * alpha
          call cwsax (u,u,
     &    fwk(irdd), eta,  iparm , fparm , iwk , fwk , ier  )
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
          if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call cwsax (fwk(ir),fwk(ir),
     &    fwk(iard), -eta,  iparm , fparm , iwk , fwk , ier  )
          endif
        endif
          call cwsax (fwk(iqlr),fwk(iqlr),
     &    fwk(ilard), -eta,  iparm , fparm , iwk , fwk , ier  )
        if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cwsax (fwk(iqrqlr),fwk(iqrqlr),
     &    fwk(irlard), -eta,  iparm , fparm , iwk , fwk , ier  )
          endif
        endif
*
          call cwrdot (rdot,fwk(iqlr),
     &    fwk(iqlr),  iparm , fparm , iwk , fwk , ier  )
        rnorm  = sqrt(abs(rdot))
*
        in         = in + 1
        iparm(5) = in
        is         = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        write (iparm(1),'(/a,i7,a/)') '     Transpose Free QMR Method ha
     &s converged in ', iparm(5), ' iterations.'
      endif
*
*-------------------------------terminate-------------------------------
*
 900  continue
*
      if (iclstg .ne. 1) then
        if (iparm(18) .ne. -1) then
          call cckstg (-1, iwkstg,  iparm , fparm , iwk , fwk , ier )
        endif
      endif
*
*     *---begin iteration statistics calculation----------
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5689
                 go to 5690
 5689  continue
        call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
        call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
        call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact,
     &    uexact,  iparm , fparm , iwk , fwk , ier  )
        endif
          call cwdot (fwk(istab+ibd ), b,
     &    b,  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5692
                 go to 5693
 5692  continue
          call cwset (fwk(ib2),b,
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5694
 5693 continue
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call cwset (fwk(iva),b,
     &     iparm , fparm , iwk , fwk , ier  )
          ivql = ib2 
         ireq = 5
        iretlb = 2041
        go to 1500
 2041   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
 5694 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+ilbd), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5695
                 go to 5696
 5695  continue
          call cwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5697
 5696 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2042
        go to 1500
 2042   continue
         if (ijob .eq. -1) go to 900
 5697 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+irlbd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1),
     &    u, uexact,  iparm , fparm , iwk , fwk , ier  )
          call cwdot (fwk(istab+ied), fwk(iu1),
     &    fwk(iu1),  iparm , fparm , iwk , fwk , ier  )
        endif
*        *---begin revcom matvec----------
          call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call cwset (fwk(ivqr),u,
     &     iparm , fparm , iwk , fwk , ier  )
          iva = ib1 
         ireq = 3
        iretlb = 2043
        go to 1500
 2043   continue
          call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
         if (ijob .eq. -1) go to 900
*        *---end revcom matvec----------
          call cwsub ( fwk(ib1),
     &    b, fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
          call cwdot (fwk(istab+ird), fwk(ib1),
     &    fwk(ib1),  iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5698
                 go to 5699
 5698  continue
          call cwset (fwk(ib2),fwk(ib1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5700
 5699 continue
          iva = ib1 
          ivql = ib2 
         ireq = 5
        iretlb = 2044
        go to 1500
 2044   continue
         if (ijob .eq. -1) go to 900
 5700 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+ilrd ), fwk(ib2),
     &    fwk(ib2),  iparm , fparm , iwk , fwk , ier  )
          call cwset (fwk(iu1),fwk(ib2),
     &     iparm , fparm , iwk , fwk , ier  )
*        *---begin revcom precon----------
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5701
                 go to 5702
 5701  continue
          call cwset (fwk(iu2),fwk(iu1),
     &     iparm , fparm , iwk , fwk , ier  )
                go to 5703
 5702 continue
          ivql = iu1 
          ivqr = iu2 
         ireq = 7
        iretlb = 2045
        go to 1500
 2045   continue
         if (ijob .eq. -1) go to 900
 5703 continue
*        *---end revcom precon----------
          call cwdot (fwk(istab+irlrd), fwk(iu2),
     &    fwk(iu2),  iparm , fparm , iwk , fwk , ier  )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Value of RELERR may be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Value of RELRSD may be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        write (iparm(1),'(5x,''Final iteration statistics'')') 
        write (iparm(1),'()') 
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ibd))
        write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilbd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlbd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''2-norm of error             '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ird))
        write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+ilrd))
        write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10,2
     &x,1pg20.10)') sqrt(fwk(istab+irlrd))
        if (iparm(19) .eq. 1) then
        write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10,2
     &x,1pg20.10)') fparm(8)
        endif
        write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10,2
     &x,1pg20.10)') fparm(7)
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        endif
        call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        call cffre (istab2,8, iparm , fparm , iwk , fwk , ier )
        call cffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5691
 5690 continue
 5691 continue
*     *---end iteration statistics calculation----------
*
      call cffre (iv2 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iv1 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/8,2).eq.1) .or.
     &    iparm(12).eq.4    .or. iparm(12).eq.8)) then
          call cffre (irlary,iparm(3)*(2), iparm , fparm , iwk , fwk , i
     &er )
          call cffre (irlard,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
          call cffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
          call cffre (iqrqlw,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
          call cffre (iqrqlv,iparm(3)*(1), iparm , fparm , iwk , fwk , i
     &er )
        endif
      endif
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1)     .or.
     &    iparm(12).eq.2     .or. iparm(12).eq.6)) then
          call cffre (iary,iparm(3)*(2), iparm , fparm , iwk , fwk , ier
     & )
          call cffre (iard,iparm(3)*(1), iparm , fparm , iwk , fwk , ier
     & )
          call cffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        endif
      endif
      call cffre (ilary,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
      call cffre (ilard,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iry,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
      call cffre (irdd,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iqlw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iqlv,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call cffre (iftab,14, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,37, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
 910  continue
      if (iparm(27) .eq. 0) then
        call cifppr ( -1 , iparm, fparm, ier )
      endif
*
*     *---reset iclev----------
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq        = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme  = 0
      nproc = 1
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Values of ijob and iparm(iptr) incompatib
     &le' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
*     *---remember parameters out of tables----------
        iitab  = iwk(iitab+0)
        iftab  = iwk(iitab+1)
        istab  = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in     = iwk(iitab+5)
        is     = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ib1    = iwk(iitab+15)
        ib2    = iwk(iitab+16)
        iu1    = iwk(iitab+17)
        iu2    = iwk(iitab+18)
        ir     = iwk(iitab+19)
        iqlr   = iwk(iitab+20)
        iqrqlr = iwk(iitab+21)
        irt    = iwk(iitab+22)
        iqlw   = iwk(iitab+23)
        iqrqlw = iwk(iitab+24)
        iqlv   = iwk(iitab+25)
        iqrqlv = iwk(iitab+26)
        iry    = iwk(iitab+27)
        iary   = iwk(iitab+28)
        ilary  = iwk(iitab+29)
        irlary = iwk(iitab+30)
        irdd   = iwk(iitab+31)
        iard   = iwk(iitab+32)
        ilard  = iwk(iitab+33)
        irlard = iwk(iitab+34)
        iv1    = iwk(iitab+35)
        iv2    = iwk(iitab+36)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot   = fwk(iftab+2)
        rnorm  = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        tau    = fwk(iftab+5)
        theta  = fwk(iftab+6)
        eta    = fwk(iftab+7)
        sigma  = fwk(iftab+8)
        alpha  = fwk(iftab+9)
        beta   = fwk(iftab+10)
        c      = fwk(iftab+11)
        rho    = fwk(iftab+12)
        rhoold = fwk(iftab+13)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'ctfqfr' , iparm ,
     &                        'Argument ijob invalid' )
      endif
*
*     *---perform the branch to where we left off----------
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011
     &,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,
     &2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2
     &038,2039,2040,2041,2042,2043,2044,2045),
     &       iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
*     *---save tables----------
        iwk(iitab+0) = iitab 
        iwk(iitab+1) = iftab 
        iwk(iitab+2) = istab 
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in    
        iwk(iitab+6) = is    
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ib1   
        iwk(iitab+16) = ib2   
        iwk(iitab+17) = iu1   
        iwk(iitab+18) = iu2   
        iwk(iitab+19) = ir    
        iwk(iitab+20) = iqlr  
        iwk(iitab+21) = iqrqlr
        iwk(iitab+22) = irt   
        iwk(iitab+23) = iqlw  
        iwk(iitab+24) = iqrqlw
        iwk(iitab+25) = iqlv  
        iwk(iitab+26) = iqrqlv
        iwk(iitab+27) = iry   
        iwk(iitab+28) = iary  
        iwk(iitab+29) = ilary 
        iwk(iitab+30) = irlary
        iwk(iitab+31) = irdd  
        iwk(iitab+32) = iard  
        iwk(iitab+33) = ilard 
        iwk(iitab+34) = irlard
        iwk(iitab+35) = iv1   
        iwk(iitab+36) = iv2   
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot  
        fwk(iftab+3) = rnorm 
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = tau   
        fwk(iftab+6) = theta 
        fwk(iftab+7) = eta   
        fwk(iftab+8) = sigma 
        fwk(iftab+9) = alpha 
        fwk(iftab+10) = beta  
        fwk(iftab+11) = c     
        fwk(iftab+12) = rho   
        fwk(iftab+13) = rhoold
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10,2x,1pg20.10 )
*
      end
