************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
** ^ROUTINE: WIFPPR - Routine to print i/fparm values. (^)
**
************************************************************************
**
      subroutine cifppr ( ijob, iparm, fparm, ier )
**
************************************************************************
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^DESCRIPTION:
**    Print out values of iparm and fparm at the beginning
**    or end of run, depending on iparm(level)
**
** ^AUTHOR:   wdj@beta.lanl.gov
**
** ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: none
**
** ^SIDE_EFFECTS: none
**
** ^DOCUMENTATION:
**
** ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
      integer ijob
      integer ier
      integer iparm(*)
      complex fparm(*)
        integer ipme
        integer nproc
      integer icallr
      integer i
      character*6 inames(50), fnames(30)
      data inames(1) / 'nout  ' /
      data inames(2) / 'levout' /
      data inames(3) / 'nru   ' /
      data inames(4) / 'itsmax' /
      data inames(5) / 'its   ' /
      data inames(6) / 'malloc' /
      data inames(7) / 'nwi   ' /
      data inames(8) / 'nwf   ' /
      data inames(9) / 'nwiusd' /
      data inames(10) / 'nwfusd' /
      data inames(11) / 'iptr  ' /
      data inames(12) / 'ntest ' /
      data inames(13) / 'iqside' /
      data inames(14) / 'iuinit' /
      data inames(15) / 'needrc' /
      data inames(16) / 'ns1   ' /
      data inames(17) / 'ns2   ' /
      data inames(18) / 'ickstg' /
      data inames(19) / 'iuexac' /
      data inames(20) / 'idot  ' /
      data inames(21) / 'istats' /
      data inames(22) / 'itimer' /
      data inames(23) / 'icomm ' /
      data inames(24) / 'msgmin' /
      data inames(25) / 'msgmax' /
      data inames(26) / 'msgtyp' /
      data inames(27) / 'iclev ' /
      data inames(41) / 'iscale' /
      data inames(42) / 'ictran' /
      data fnames(1) / 'ctimer' /
      data fnames(2) / 'rtimer' /
      data fnames(3) / 'flopsr' /
      data fnames(4) / 'zeta  ' /
      data fnames(5) / 'stptst' /
      data fnames(6) / 'alpha ' /
      data fnames(7) / 'relrsd' /
      data fnames(8) / 'relerr' /
      data fnames(11) / 'ctimei' /
      data fnames(12) / 'rtimei' /
      data fnames(13) / 'flopsi' /
      data fnames(21) / 'ctimet' /
      data fnames(22) / 'rtimet' /
      data fnames(23) / 'flopst' /
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: ifppr.fm4,v 1.11 1994/04/30 04:39:42 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
      if (ijob.ne.1 .and. ijob.ne.-1) return
      ipme  = 0
      nproc = 1
      if (iparm(2) .lt. 4) go to 900
      icallr = iparm(27)
      if (icallr .ge. 2) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        if (ijob .eq. 1) then
        write (iparm(1),'(5x,''Initial top level parameters:'')') 
        else
        write (iparm(1),'(5x,''Final top level parameters:'')') 
        endif
        write (iparm(1),'()') 
        write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i),
     &        i=41,
     &          42)
        write (iparm(1),'(5x,a6,8x,1pg20.10,2x,1pg20.10)') (fnames(i),fp
     &arm(i),
     &        i=21,
     &          23)
        write (iparm(1),'()') 
      endif
      if (icallr .ge. 1) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        if (ijob .eq. 1) then
        write (iparm(1),'(5x,''Initial iterative method level parameters
     &:'')') 
        else
        write (iparm(1),'(5x,''Final iterative method level parameters:'
     &')') 
        endif
        write (iparm(1),'()') 
        write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i),
     &        i=31,
     &          30)
        write (iparm(1),'(5x,a6,8x,1pg20.10,2x,1pg20.10)') (fnames(i),fp
     &arm(i),
     &        i=11,
     &          13)
        write (iparm(1),'()') 
      endif
      if (icallr .ge. 0) then
        write (iparm(1),'()') 
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
        if (ijob .eq. 1) then
        write (iparm(1),'(5x,''Initial revcom level parameters:'')') 
        else
        write (iparm(1),'(5x,''Final revcom level parameters:'')') 
        endif
        write (iparm(1),'()') 
        write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i),
     &        i=1,
     &          27)
        write (iparm(1),'(5x,a6,8x,1pg20.10,2x,1pg20.10)') (fnames(i),fp
     &arm(i),
     &        i=1,
     &          8)
        write (iparm(1),'()') 
      endif
        write (iparm(1),'(1x, 60(''*''))') 
        write (iparm(1),'()') 
 900  continue
      return
      end
